package org.apache.polaris.service.catalog.api;

import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.service.types.ListGenericTablesResponse;
import org.apache.polaris.service.types.LoadGenericTableResponse;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

/**
 * The GenericTableApi API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/catalog/polaris/v1/{prefix}/namespaces/{namespace}/generic-tables")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.398743462Z[UTC]", comments = "Generator version: 7.12.0")
public class PolarisCatalogGenericTableApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogGenericTableApi.class);

  private final PolarisCatalogGenericTableApiService service;

  @Inject
  public PolarisCatalogGenericTableApi(PolarisCatalogGenericTableApiService service) {
    this.service = service;
  }

  /**
   * Create a generic table under the given namespace, and return the created table information as a response.
   *
   * Response type: {@code LoadGenericTableResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param createGenericTableRequest Required - 
   *
   * @return 200 - Table result if successfully created a generic table.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 409 - Conflict - The table already exists under the given namespace
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.GenericTableApi.createGenericTable")
  @Timeout
  public Response createGenericTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Nonnull @Valid CreateGenericTableRequest createGenericTableRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking GenericTableApi with params")
      .addKeyValue("operation", "createGenericTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("createGenericTableRequest", String.valueOf(createGenericTableRequest))
      .log();

    Response ret =
      service.createGenericTable(prefix,namespace,createGenericTableRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createGenericTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a table under the given namespace from the catalog
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param genericTable Required - A generic table name
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableError, Generic table to drop does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @DELETE
  @Path("/{generic-table}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.GenericTableApi.dropGenericTable")
  @Timeout
  public Response dropGenericTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("generic-table") String genericTable,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking GenericTableApi with params")
      .addKeyValue("operation", "dropGenericTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("genericTable", genericTable)
      .log();

    Response ret =
      service.dropGenericTable(prefix,namespace,genericTable,realmContext,securityContext);
    LOGGER.debug("Completed execution of dropGenericTable API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Return all generic table identifiers under this namespace
   *
   * Response type: {@code ListGenericTablesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   *
   * @return 200 - List of generic table identifiers.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.GenericTableApi.listGenericTables")
  @Timeout
  public Response listGenericTables( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @QueryParam("pageToken")  String pageToken, @QueryParam("pageSize")  @Min(1) Integer pageSize,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking GenericTableApi with params")
      .addKeyValue("operation", "listGenericTables")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .log();

    Response ret =
      service.listGenericTables(prefix,namespace,pageToken,pageSize,realmContext,securityContext);
    LOGGER.debug("Completed execution of listGenericTables API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Load a generic table from the catalog under the given namespace. The response contains all table information passed during create.
   *
   * Response type: {@code LoadGenericTableResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param genericTable Required - A generic table name
   *
   * @return 200 - Table result if successfully load a generic table.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableError, generic table to load does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/{generic-table}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.GenericTableApi.loadGenericTable")
  @Timeout
  public Response loadGenericTable( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @PathParam("generic-table") String genericTable,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking GenericTableApi with params")
      .addKeyValue("operation", "loadGenericTable")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("genericTable", genericTable)
      .log();

    Response ret =
      service.loadGenericTable(prefix,namespace,genericTable,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadGenericTable API with status code {}", ret.getStatus());
    return ret;
  }
}
