package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.service.types.PolicyAttachmentTarget;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class AttachPolicyRequest   {

  @NotNull
  @Valid
  private final PolicyAttachmentTarget target;
  private final Map<String, String> parameters;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "target", required = true)
    public PolicyAttachmentTarget getTarget() {
        return target;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "parameters")
    public Map<String, String> getParameters() {
        return parameters;
    }
    
    @JsonCreator
    public AttachPolicyRequest(@JsonProperty(value = "target", required = true) PolicyAttachmentTarget target, @JsonProperty(value = "parameters") Map<String, String> parameters) {
        this.target = target;
        this.parameters = Objects.requireNonNullElse(parameters, new HashMap<>());
    }


    public AttachPolicyRequest(PolicyAttachmentTarget target) {
        this.target = target;
        this.parameters = new HashMap<>();
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PolicyAttachmentTarget target) {
        return new Builder(target);
    }


    public static final class Builder {
      private PolicyAttachmentTarget target;
      private Map<String, String> parameters;
      private Builder() {
      }
      private Builder(PolicyAttachmentTarget target) {
        this.target = target;
      }

      public Builder setTarget(PolicyAttachmentTarget target) {
        this.target = target;
        return this;
      }
      public Builder setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
      }


      public AttachPolicyRequest build() {
        AttachPolicyRequest inst = new AttachPolicyRequest(target, parameters);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttachPolicyRequest attachPolicyRequest = (AttachPolicyRequest) o;
    return Objects.equals(this.target, attachPolicyRequest.target) &&
        Objects.equals(this.parameters, attachPolicyRequest.parameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(target, parameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttachPolicyRequest {\n");
    
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
