/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.admintool;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    public static final String INIT_SCRIPT = "init-script";
    private PostgreSQLContainer<?> postgres;
    private String initScript;
    private DevServicesContext context;
    private Path rootDir;

    public void init(Map<String, String> initArgs) {
        this.initScript = initArgs.get(INIT_SCRIPT);
    }

    public void setIntegrationTestContext(DevServicesContext context) {
        this.context = context;
    }

    public Map<String, String> start() {
        this.postgres = new PostgreSQLContainer(DockerImageName.parse((String)"postgres:17-alpine")).withDatabaseName("polaris_realm1").withUsername("polaris").withPassword("polaris");
        if (this.initScript != null) {
            this.postgres.withInitScript(this.initScript);
        }
        this.context.containerNetworkId().ifPresent(arg_0 -> this.postgres.withNetworkMode(arg_0));
        this.postgres.start();
        return Map.of("polaris.persistence.type", "eclipse-link", "polaris.persistence.eclipselink.configuration-file", this.createPersistenceXml().toString());
    }

    public void stop() {
        if (this.postgres != null) {
            try {
                this.postgres.stop();
            }
            finally {
                this.postgres = null;
            }
        }
        if (this.rootDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.rootDir.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.rootDir = null;
            }
        }
    }

    private Path createPersistenceXml() {
        try {
            this.rootDir = Files.createTempDirectory("root", new FileAttribute[0]);
            Path archiveDir = this.rootDir.resolve("archive");
            Files.createDirectory(archiveDir, new FileAttribute[0]);
            String persistenceXmlContent = "<persistence version=\"2.0\" xmlns=\"http://java.sun.com/xml/ns/persistence\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd\">\n  <persistence-unit name=\"polaris\" transaction-type=\"RESOURCE_LOCAL\">\n    <provider>org.eclipse.persistence.jpa.PersistenceProvider</provider>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntity</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityActive</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityChangeTracking</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityDropped</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelGrantRecord</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelPrincipalSecrets</class>\n    <class>org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelSequenceId</class>\n    <shared-cache-mode>NONE</shared-cache-mode>\n    <properties>\n      <property name=\"jakarta.persistence.jdbc.url\" value=\"%s\"/>\n      <property name=\"jakarta.persistence.jdbc.user\" value=\"%s\"/>\n      <property name=\"jakarta.persistence.jdbc.password\" value=\"%s\"/>\n      <property name=\"jakarta.persistence.schema-generation.database.action\" value=\"create\"/>\n      <property name=\"eclipselink.logging.level.sql\" value=\"FINE\"/>\n      <property name=\"eclipselink.logging.parameters\" value=\"true\"/>\n      <property name=\"eclipselink.persistence-context.flush-mode\" value=\"auto\"/>\n    </properties>\n  </persistence-unit>\n</persistence>\n".formatted(this.postgres.getJdbcUrl().replace("realm1", "{realm}"), this.postgres.getUsername(), this.postgres.getPassword());
            Path file = Files.createTempFile(archiveDir, "persistence", "xml", new FileAttribute[0]);
            Files.writeString(file, (CharSequence)persistenceXmlContent, new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

