/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.Properties;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.test.WorkflowTestCase;
import org.junit.Assume;

public class TestWorkflow
extends WorkflowTestCase {
    public void testWorkflowWithStartAndEndCompletesSuccessfully() throws Exception {
        String workflowXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='test-wf'>    <start to='end'/>    <end name='end'/></workflow-app>";
        this.submitAndAssert("<workflow-app xmlns='uri:oozie:workflow:0.1' name='test-wf'>    <start to='end'/>    <end name='end'/></workflow-app>", WorkflowJob.Status.SUCCEEDED);
    }

    public void testFsDecisionWorkflowCompletesSuccessfully() throws Exception {
        String workflowFileName = "fs-decision.xml";
        Properties additionalWorkflowProperties = new Properties();
        this.runWorkflowFromFile("fs-decision.xml", additionalWorkflowProperties);
    }

    public void testParallelFsAndShellWorkflowCompletesSuccessfully() throws Exception {
        String workflowFileName = "parallel-fs-and-shell.xml";
        Properties additionalWorkflowProperties = new Properties();
        boolean isEvenSecond = new Date().getTime() % 2L == 0L;
        additionalWorkflowProperties.setProperty("choosePath1", Boolean.toString(isEvenSecond));
        String envJavaHome = System.getenv("JAVA_HOME");
        Assume.assumeFalse((String)"Environment variable JAVA_HOME has to be set", (boolean)Strings.isNullOrEmpty((String)envJavaHome));
        additionalWorkflowProperties.setProperty("oozie.launcher.yarn.app.mapreduce.am.env", envJavaHome);
        this.runWorkflowFromFile("parallel-fs-and-shell.xml", additionalWorkflowProperties);
    }
}

