/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.OoziePigStats;
import org.apache.pig.PigRunner;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;

public class PigMain
extends LauncherMain {
    private static final Set<String> DISALLOWED_PIG_OPTIONS = new HashSet<String>();
    public static final int STRING_BUFFER_SIZE = 100;
    public static final String LOG_EXPANDED_PIG_SCRIPT = "oozie.action.pig.log.expandedscript";
    @VisibleForTesting
    static final Pattern[] PIG_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("HadoopJobId: (job_\\S*)"), Pattern.compile("Submitted application (application[0-9_]*)")};

    public static void main(String[] args) throws Exception {
        PigMain.run(PigMain.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        String[] params;
        System.out.println();
        System.out.println("Oozie Pig action configuration");
        System.out.println("=================================================================");
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        PigMain.setYarnTag((Configuration)actionConf);
        PigMain.setApplicationTags((Configuration)actionConf, (String)"tez.application.tags");
        Properties pigProperties = new Properties();
        for (Map.Entry entry : actionConf) {
            pigProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String jobTokenFile = PigMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (jobTokenFile != null) {
            pigProperties.setProperty("mapreduce.job.credentials.binary", jobTokenFile);
            pigProperties.setProperty("tez.credentials.path", jobTokenFile);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to:" + jobTokenFile);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", jobTokenFile);
        } else {
            System.out.println("Non-kerberos execution");
        }
        String callerId = "oozie:" + System.getProperty("oozie.job.id");
        pigProperties.setProperty("pig.log.trace.id", callerId);
        PigMain.createFileWithContentIfNotExists((String)"pig.properties", (Properties)pigProperties);
        PigMain.logMasking((String)"pig.properties:", pigProperties.entrySet());
        ArrayList<String> arguments = new ArrayList<String>();
        String script = actionConf.get("oozie.pig.script");
        if (script == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.pig.script] property");
        }
        if (!new File(script).exists()) {
            throw new RuntimeException("Error: Pig script file [" + script + "] does not exist");
        }
        this.printScript(script, "");
        arguments.add("-file");
        arguments.add(script);
        for (String param : params = ActionUtils.getStrings((Configuration)actionConf, (String)"oozie.pig.params")) {
            arguments.add("-param");
            arguments.add(param);
        }
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("pig-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        String pigLogLevel = actionConf.get("oozie.pig.log.level", "INFO");
        String rootLogLevel = actionConf.get("oozie.action.rootlogger.log.level", "INFO");
        this.log4jProperties.setProperty("log4j.rootLogger", rootLogLevel + ", A, B");
        this.log4jProperties.setProperty("log4j.logger.org.apache.pig", pigLogLevel + ", A, B");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.pig", "false");
        this.log4jProperties.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        this.log4jProperties.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.A.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.appender.B", "org.apache.log4j.FileAppender");
        this.log4jProperties.setProperty("log4j.appender.B.file", logFile);
        this.log4jProperties.setProperty("log4j.appender.B.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.B.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "INFO, B");
        String localProps = new File("piglog4j.properties").getAbsolutePath();
        PigMain.createFileWithContentIfNotExists((String)localProps, (Properties)this.log4jProperties);
        arguments.add("-log4jconf");
        arguments.add(localProps);
        File localDir = new File(localProps).getParentFile();
        System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
        String pigLog = "pig-" + hadoopJobId + ".log";
        arguments.add("-logfile");
        arguments.add(pigLog);
        String[] pigArgs = ActionUtils.getStrings((Configuration)actionConf, (String)"oozie.pig.args");
        for (String pigArg : pigArgs) {
            if (DISALLOWED_PIG_OPTIONS.contains(pigArg)) {
                throw new RuntimeException("Error: Pig argument " + pigArg + " is not supported");
            }
            arguments.add(pigArg);
        }
        if (actionConf.getBoolean(LOG_EXPANDED_PIG_SCRIPT, true) && ScriptEngine.getSupportedScriptLang((String)script) == null) {
            this.logExpandedScript(script, arguments);
        }
        System.out.println("Pig command arguments :");
        for (String arg : arguments) {
            System.out.println("             " + arg);
        }
        LauncherMain.killChildYarnJobs((Configuration)actionConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Pig command line now >>>");
        System.out.println();
        System.out.flush();
        System.out.println();
        this.runPigJob(new String[]{"-version"}, null, true, false);
        System.out.println();
        System.out.flush();
        boolean hasStats = Boolean.parseBoolean(actionConf.get("oozie.action.external.stats.write"));
        this.runPigJob(arguments.toArray(new String[arguments.size()]), pigLog, false, hasStats);
        System.out.println();
        System.out.println("<<< Invocation of Pig command completed <<<");
        System.out.println();
        File file = new File(System.getProperty("oozie.action.externalChildIDs"));
        if (!file.exists()) {
            PigMain.writeExternalChildIDs((String)logFile, (Pattern[])PIG_JOB_IDS_PATTERNS, (String)"Pig");
        }
    }

    private void logExpandedScript(String script, List<String> arguments) {
        ArrayList<String> dryrunArgs = new ArrayList<String>();
        dryrunArgs.addAll(arguments);
        dryrunArgs.add("-dryrun");
        try {
            PigRunner.run((String[])dryrunArgs.toArray(new String[dryrunArgs.size()]), null);
            this.printScript(script + ".expanded", "Expanded");
        }
        catch (Exception e) {
            System.out.println("Failure while expanding pig script");
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printScript(String name, String type) {
        block9: {
            FileInputStream fin = null;
            InputStreamReader inReader = null;
            BufferedReader bufReader = null;
            try {
                File script = new File(name);
                if (!script.exists()) {
                    return;
                }
                System.out.println("-----------------------------------------------------------");
                System.out.println(type + " Pig script [" + name + "] content: ");
                System.out.println("-----------------------------------------------------------");
                fin = new FileInputStream(script);
                inReader = new InputStreamReader((InputStream)fin, "UTF-8");
                bufReader = new BufferedReader(inReader);
                String line = bufReader.readLine();
                while (line != null) {
                    System.out.println(line);
                    line = bufReader.readLine();
                }
                bufReader.close();
                IOUtils.closeQuietly((InputStream)fin);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                System.out.println("Unable to read " + name);
                e.printStackTrace(System.out);
                break block9;
            }
            finally {
                IOUtils.closeQuietly(fin);
                IOUtils.closeQuietly(inReader);
                IOUtils.closeQuietly(bufReader);
            }
            IOUtils.closeQuietly((Reader)inReader);
            IOUtils.closeQuietly((Reader)bufReader);
        }
        System.out.println();
        System.out.flush();
        System.out.println("-----------------------------------------------------------");
        System.out.println();
    }

    private void handleError(String pigLog) throws Exception {
        System.err.println();
        System.err.println("Pig logfile dump:");
        System.err.println();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pigLog), "UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                System.err.println(line);
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("pig log file: " + pigLog + "  not found.");
        }
    }

    protected void runPigJob(String[] args, String pigLog, boolean resetSecurityManager, boolean retrieveStats) throws Exception {
        PigStats stats = PigRunner.run((String[])args, null);
        String jobIds = this.getHadoopJobIds(stats);
        if (jobIds != null && !jobIds.isEmpty()) {
            System.out.println("Hadoop Job IDs executed by Pig: " + jobIds);
            File f = new File(System.getProperty("oozie.action.externalChildIDs"));
            PigMain.writeExternalData(jobIds, f);
        }
        if (!stats.isSuccessful()) {
            if (pigLog != null) {
                this.handleError(pigLog);
            }
            throw new LauncherMainException(2);
        }
        if (resetSecurityManager) {
            return;
        }
        if (retrieveStats) {
            String JSONString;
            try {
                OoziePigStats pigStats = new OoziePigStats(stats);
                JSONString = pigStats.toJSON();
            }
            catch (UnsupportedOperationException uoe) {
                throw new UnsupportedOperationException("Pig stats are not supported for this type of operation", uoe);
            }
            File f = new File(System.getProperty("oozie.action.stats.properties"));
            PigMain.writeExternalData(JSONString, f);
        }
    }

    private static void writeExternalData(String data, File f) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            out.write(data);
        }
    }

    protected String getHadoopJobIds(PigStats pigStats) {
        StringBuilder sb = new StringBuilder(100);
        String separator = ",";
        try {
            PigStats.JobGraph jobGraph = pigStats.getJobGraph();
            for (JobStats jobStats : jobGraph) {
                String hadoopJobId = jobStats.getJobId();
                if (StringUtils.isEmpty((String)hadoopJobId) || hadoopJobId.trim().equalsIgnoreCase("NULL")) continue;
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(hadoopJobId);
            }
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
        return sb.toString();
    }

    static {
        DISALLOWED_PIG_OPTIONS.add("-4");
        DISALLOWED_PIG_OPTIONS.add("-log4jconf");
        DISALLOWED_PIG_OPTIONS.add("-e");
        DISALLOWED_PIG_OPTIONS.add("-execute");
        DISALLOWED_PIG_OPTIONS.add("-f");
        DISALLOWED_PIG_OPTIONS.add("-file");
        DISALLOWED_PIG_OPTIONS.add("-l");
        DISALLOWED_PIG_OPTIONS.add("-logfile");
        DISALLOWED_PIG_OPTIONS.add("-r");
        DISALLOWED_PIG_OPTIONS.add("-dryrun");
        DISALLOWED_PIG_OPTIONS.add("-P");
        DISALLOWED_PIG_OPTIONS.add("-propertyFile");
    }
}

