/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.GitMain;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;

class GitOperations {
    private final URI srcURL;
    private final String branch;
    private final File credentialFile;

    GitOperations(URI gitSrc, String branch, File credentialFile) {
        this.srcURL = gitSrc;
        this.branch = branch;
        this.credentialFile = credentialFile;
    }

    private void cloneRepo(File outputDir) throws GitOperationsException {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
                JSch defaultJSch = super.createDefaultJSch(fs);
                if (GitOperations.this.credentialFile != null) {
                    defaultJSch.addIdentity(GitOperations.this.credentialFile.toString());
                }
                return defaultJSch;
            }
        };
        CloneCommand cloneCommand = Git.cloneRepository();
        cloneCommand.setURI(this.srcURL.toString());
        if (this.srcURL.getScheme().toLowerCase().equals("ssh")) {
            cloneCommand.setTransportConfigCallback(new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
                final /* synthetic */ SshSessionFactory val$sshSessionFactory;
                {
                    this.val$sshSessionFactory = sshSessionFactory;
                }

                public void configure(Transport transport) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                }
            });
        }
        cloneCommand.setDirectory(outputDir);
        if (this.branch != null) {
            cloneCommand.setBranchesToClone(Arrays.asList("refs/heads/" + this.branch));
        }
        try {
            cloneCommand.call();
        }
        catch (GitAPIException e) {
            throw new GitOperationsException("Unable to clone Git repo: ", e);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path is created runtime")
    String cloneRepoToFS(Path destination) throws IOException, GitOperationsException {
        File tempDir = GitMain.createTempDir("git");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)destination.toUri(), (Configuration)conf);
        this.cloneRepo(tempDir);
        File src = new File(tempDir.getAbsolutePath());
        ArrayList<Path> srcs = new ArrayList<Path>(1000);
        File[] sourceFiles = src.listFiles();
        if (sourceFiles != null) {
            for (File sourceFile : sourceFiles) {
                srcs.add(new Path(sourceFile.toString()));
            }
        }
        System.out.println("Finished cloning to local");
        fs.mkdirs(destination);
        fs.copyFromLocalFile(false, true, srcs.toArray(new Path[0]), destination);
        System.out.println("Finished copying to " + destination.toString());
        return destination.toString();
    }

    static class GitOperationsException
    extends Exception {
        GitOperationsException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

