/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.GitOperations;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;

public class GitMain
extends LauncherMain {
    private static final String OOZIE_ACTION_CONF = "oozie.action.conf.xml";
    private String nameNode;
    private String keyPath;
    private String destinationUri;
    private String gitUri;
    private String gitBranch;

    public static void main(String[] args) throws Exception {
        GitMain.run(GitMain.class, (String[])args);
    }

    @VisibleForTesting
    void setNameNode(String nameNode) {
        this.nameNode = nameNode;
    }

    protected void run(String[] args) throws Exception {
        System.out.println("=============================================");
        System.out.println("Oozie Git Action Configuration");
        System.out.println("=============================================");
        Configuration actionConf = this.prepareActionConf();
        this.parseActionConfiguration(actionConf);
        File localKey = this.getLocalKeyFile();
        GitOperations gitRepo = new GitOperations(new URI(this.gitUri), this.gitBranch, localKey);
        try {
            gitRepo.cloneRepoToFS(new Path(this.destinationUri));
        }
        catch (IOException | GitOperations.GitOperationsException e) {
            System.err.println(e.getMessage());
            throw e;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File created without user input")
    private Configuration prepareActionConf() {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty(OOZIE_ACTION_CONF);
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        return actionConf;
    }

    private File getLocalKeyFile() throws IOException, URISyntaxException {
        File localKey = null;
        if (this.keyPath != null) {
            localKey = this.getKeyFromFS(new Path(this.keyPath));
        }
        return localKey;
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File created without user input")
    File getKeyFromFS(Path location) throws IOException, URISyntaxException {
        String keyCopyMsg = "Copied keys to local container!";
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.newInstance((URI)new URI(this.nameNode), (Configuration)conf);
        File key = GitMain.createTempDir("git");
        fs.copyToLocalFile(location, new Path("file:///" + key.getAbsolutePath() + "/privkey"));
        System.out.println("Copied keys to local container!");
        return new File(key.getAbsolutePath() + "/privkey");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File created without user input")
    static File createTempDir(String prefix) throws IOException {
        File tempDir = new File(Files.createTempDirectory(Paths.get(".", new String[0]), prefix + "_" + Long.toString(System.nanoTime()), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"))).toString());
        tempDir.deleteOnExit();
        String localMkdirMsg = "Local mkdir called creating temp. dir at: " + tempDir.getAbsolutePath();
        System.out.println(localMkdirMsg);
        return tempDir;
    }

    private URI isValidUri(String testUri) throws OozieActionConfiguratorException {
        URI uri;
        try {
            uri = new URI(testUri);
        }
        catch (URISyntaxException e) {
            throw new OozieActionConfiguratorException("Action Configuration does not have a proper URI: " + testUri + " exception " + e.toString());
        }
        if (uri.getScheme() == null) {
            throw new OozieActionConfiguratorException("Action Configuration does not have a proper URI " + testUri + " null scheme.");
        }
        return uri;
    }

    String checkAndGetTrimmed(Configuration actionConf, String name) {
        Objects.requireNonNull(actionConf.getTrimmed(name), () -> String.format("Action Configuration does not have [%s] property", name));
        return actionConf.getTrimmed(name);
    }

    private void parseActionConfiguration(Configuration actionConf) throws OozieActionConfiguratorException {
        this.nameNode = this.checkAndGetTrimmed(actionConf, "oozie.name.node");
        this.destinationUri = this.checkAndGetTrimmed(actionConf, "oozie.git.destination.uri");
        try {
            FileSystem fs = FileSystem.get((URI)this.isValidUri(this.destinationUri), (Configuration)actionConf);
            this.destinationUri = fs.makeQualified(new Path(this.destinationUri)).toString();
        }
        catch (IOException e) {
            throw new OozieActionConfiguratorException("Action Configuration does not have a valid filesystem for URI oozie.git.destination.uriexception " + e.toString());
        }
        this.gitUri = this.isValidUri(this.checkAndGetTrimmed(actionConf, "oozie.git.source.uri")).toString();
        this.gitBranch = actionConf.get("oozie.git.branch");
        this.keyPath = actionConf.get("oozie.git.key.path");
    }
}

