/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.OozieStatusServer;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;

public class OozieStatusServerProvider
implements Provider<OozieStatusServer> {
    public static final String OOZIE_STATUS_SERVER_ENABLED = "oozie.status.server.enabled";
    public static final String OOZIE_STATUS_SERVER_HOSTNAME = "oozie.status.server.hostname";
    public static final String OOZIE_STATUS_SERVER_PORT = "oozie.status.server.port";
    public static final String OOZIE_STATUS_SERVER_MAX_THREAD = "oozie.status.server.max.threads";
    private final Configuration oozieConfiguration;

    @Inject
    public OozieStatusServerProvider(Services oozieServices) {
        this.oozieConfiguration = ((ConfigurationService)oozieServices.get(ConfigurationService.class)).getConf();
    }

    public OozieStatusServer get() {
        boolean enabled = this.oozieConfiguration.getBoolean(OOZIE_STATUS_SERVER_ENABLED, true);
        int httpPort = this.oozieConfiguration.getInt(OOZIE_STATUS_SERVER_PORT, 21443);
        String hostname = this.oozieConfiguration.get(OOZIE_STATUS_SERVER_HOSTNAME, "localhost");
        int maxThread = this.oozieConfiguration.getInt(OOZIE_STATUS_SERVER_MAX_THREAD, 10);
        return new OozieStatusServer(enabled, httpPort, hostname, maxThread);
    }
}

