/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.EmbeddedOozieServer;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.util.security.Constraint;

class ConstraintSecurityHandlerProvider
implements Provider<ConstraintSecurityHandler> {
    private final Configuration oozieConfiguration;

    @Inject
    public ConstraintSecurityHandlerProvider(Services oozieServices) {
        this.oozieConfiguration = ((ConfigurationService)oozieServices.get(ConfigurationService.class)).getConf();
    }

    public ConstraintSecurityHandler get() {
        String contextPath = EmbeddedOozieServer.getContextPath(this.oozieConfiguration);
        ConstraintMapping callbackConstraintMapping = new ConstraintMapping();
        callbackConstraintMapping.setPathSpec(String.format("%s/callback/*", contextPath));
        Constraint unsecureConstraint = new Constraint();
        unsecureConstraint.setDataConstraint(0);
        callbackConstraintMapping.setConstraint(unsecureConstraint);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        Constraint constraint = new Constraint();
        constraint.setDataConstraint(2);
        mapping.setConstraint(constraint);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(Arrays.asList(callbackConstraintMapping, mapping));
        return security;
    }
}

