/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.HttpConfigurationWrapper;
import org.apache.oozie.service.ConfigurationService;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLServerConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLServerConnectorFactory.class);
    public static final String OOZIE_HTTPS_KEYSTORE_PASS = "oozie.https.keystore.pass";
    public static final String OOZIE_HTTPS_KEYSTORE_FILE = "oozie.https.keystore.file";
    public static final String OOZIE_HTTPS_EXCLUDE_PROTOCOLS = "oozie.https.exclude.protocols";
    public static final String OOZIE_HTTPS_INCLUDE_PROTOCOLS = "oozie.https.include.protocols";
    public static final String OOZIE_HTTPS_INCLUDE_CIPHER_SUITES = "oozie.https.include.cipher.suites";
    public static final String OOZIE_HTTPS_EXCLUDE_CIPHER_SUITES = "oozie.https.exclude.cipher.suites";
    public static final String OOZIE_HSTS_MAX_AGE_SECONDS = "oozie.hsts.max.age.seconds";
    public static final String SERVER_KEYSTORE_PASSWORD = "ssl.server.keystore.password";
    public static final String SERVER_KEYSTORE_LOCATION = "ssl.server.keystore.location";
    @VisibleForTesting
    static final long OOZIE_DEFAULT_HSTS_MAX_AGE = 31536000L;
    private SslContextFactory sslContextFactory;
    private Configuration conf;
    private Configuration sslServerConf;

    @Inject
    public SSLServerConnectorFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "sslContextFactory is null");
    }

    public ServerConnector createSecureServerConnector(int oozieHttpsPort, Configuration conf, Configuration sslServerConf, Server server) {
        this.conf = Objects.requireNonNull(conf, "conf is null");
        this.sslServerConf = sslServerConf;
        Objects.requireNonNull(server, "server is null");
        Preconditions.checkState((oozieHttpsPort >= 1 && oozieHttpsPort <= 65535 ? 1 : 0) != 0, (Object)String.format("Invalid port number specified: '%d'. It should be between 1 and 65535.", oozieHttpsPort));
        this.setIncludeProtocols();
        this.setExcludeProtocols();
        this.setIncludeCipherSuites();
        this.setExludeCipherSuites();
        this.setKeyStoreFile();
        this.setKeystorePass();
        HttpConfiguration httpsConfiguration = this.getHttpsConfiguration();
        ServerConnector secureServerConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfiguration)});
        secureServerConnector.setPort(oozieHttpsPort);
        LOG.info(String.format("Secure server connector created, listening on port %d", oozieHttpsPort));
        return secureServerConnector;
    }

    private void setExludeCipherSuites() {
        String excludeCipherList = this.conf.get(OOZIE_HTTPS_EXCLUDE_CIPHER_SUITES);
        Object[] excludeCipherSuites = excludeCipherList.split(",");
        this.sslContextFactory.setExcludeCipherSuites((String[])excludeCipherSuites);
        LOG.info(String.format("SSL context - excluding cipher suites: %s", Arrays.toString(excludeCipherSuites)));
    }

    private void setIncludeCipherSuites() {
        String includeCipherList = this.conf.get(OOZIE_HTTPS_INCLUDE_CIPHER_SUITES);
        if (includeCipherList == null || includeCipherList.isEmpty()) {
            return;
        }
        Object[] includeCipherSuites = includeCipherList.split(",");
        this.sslContextFactory.setIncludeCipherSuites((String[])includeCipherSuites);
        LOG.info(String.format("SSL context - including cipher suites: %s", Arrays.toString(includeCipherSuites)));
    }

    private void setIncludeProtocols() {
        String enabledProtocolsList = this.conf.get(OOZIE_HTTPS_INCLUDE_PROTOCOLS);
        Object[] enabledProtocols = enabledProtocolsList.split(",");
        this.sslContextFactory.setIncludeProtocols((String[])enabledProtocols);
        LOG.info(String.format("SSL context - including protocols: %s", Arrays.toString(enabledProtocols)));
    }

    private void setExcludeProtocols() {
        String excludedProtocolsList = this.conf.get(OOZIE_HTTPS_EXCLUDE_PROTOCOLS);
        if (excludedProtocolsList == null || excludedProtocolsList.isEmpty()) {
            return;
        }
        Object[] excludedProtocols = excludedProtocolsList.split(",");
        this.sslContextFactory.setExcludeProtocols((String[])excludedProtocols);
        LOG.info(String.format("SSL context - excluding protocols: %s", Arrays.toString(excludedProtocols)));
    }

    private void setKeystorePass() {
        String keystorePass = ConfigurationService.getPassword((Configuration)this.conf, (String)OOZIE_HTTPS_KEYSTORE_PASS);
        if ((keystorePass == null || keystorePass.equals("")) && this.sslServerConf != null) {
            try {
                keystorePass = new String(this.sslServerConf.getPassword(SERVER_KEYSTORE_PASSWORD));
            }
            catch (IOException e) {
                LOG.error("Can't get keystore password: " + e);
            }
        }
        Objects.requireNonNull(keystorePass, "keystorePass is null");
        this.sslContextFactory.setKeyStorePassword(keystorePass);
    }

    private void setKeyStoreFile() {
        String keystoreFile = this.conf.get(OOZIE_HTTPS_KEYSTORE_FILE);
        if ((keystoreFile == null || keystoreFile.equals("")) && this.sslServerConf != null) {
            keystoreFile = this.sslServerConf.get(SERVER_KEYSTORE_LOCATION);
        }
        Objects.requireNonNull(keystoreFile, "keystoreFile is null");
        this.sslContextFactory.setKeyStorePath(keystoreFile);
    }

    private HttpConfiguration getHttpsConfiguration() {
        HttpConfiguration https = new HttpConfigurationWrapper(this.conf).getDefaultHttpConfiguration();
        https.setSecureScheme("https");
        long htsMaxAgeSeconds = this.conf.getLong(OOZIE_HSTS_MAX_AGE_SECONDS, 31536000L);
        boolean sniHostCheck = true;
        boolean stsIncludeSubdomains = false;
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(sniHostCheck, htsMaxAgeSeconds, stsIncludeSubdomains));
        return https;
    }
}

