/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.inject.Inject;
import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.oozie.servlet.AuthFilter;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.HttpResponseHeaderFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class FilterMapper {
    private final WebAppContext servletContextHandler;

    @Inject
    public FilterMapper(WebAppContext servletContextHandler) {
        this.servletContextHandler = Objects.requireNonNull(servletContextHandler, "ServletContextHandler is null");
    }

    void addFilters() {
        this.mapFilter(new FilterHolder((Filter)new HostnameFilter()), "/*");
        this.mapFilter(new FilterHolder((Filter)new HttpResponseHeaderFilter()), "/*");
        FilterHolder authFilter = new FilterHolder((Filter)new AuthFilter());
        this.mapFilter(authFilter, "/versions/*");
        this.mapFilter(authFilter, "/v0/*");
        this.mapFilter(authFilter, "/v1/*");
        this.mapFilter(authFilter, "/v2/*");
        this.mapFilter(authFilter, "/index.jsp");
        this.mapFilter(authFilter, "/admin/*");
        this.mapFilter(authFilter, "/*.js");
        this.mapFilter(authFilter, "/ext-2.2/*");
        this.mapFilter(authFilter, "/docs/*");
        this.mapFilter(authFilter, "/error/*");
    }

    private void mapFilter(FilterHolder filterHolder, String pathSpec) {
        this.servletContextHandler.addFilter(filterHolder, pathSpec, EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE));
    }
}

