/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.server.FilterMapper;
import org.apache.oozie.server.HttpConfigurationWrapper;
import org.apache.oozie.server.JspHandler;
import org.apache.oozie.server.OozieStatusServer;
import org.apache.oozie.server.SSLServerConnectorFactory;
import org.apache.oozie.server.ServletMapper;
import org.apache.oozie.server.guice.OozieGuiceModule;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.rewrite.handler.HeaderPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedOozieServer {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedOozieServer.class);
    protected static final String OOZIE_HTTPS_TRUSTSTORE_FILE = "oozie.https.truststore.file";
    protected static final String OOZIE_HTTPS_TRUSTSTORE_PASS = "oozie.https.truststore.pass";
    protected static final String TRUSTSTORE_PATH_SYSTEM_PROPERTY = "javax.net.ssl.trustStore";
    protected static final String TRUSTSTORE_PASS_SYSTEM_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String SERVER_TRUSTSTORE_PASSWORD = "ssl.server.truststore.password";
    public static final String SERVER_TRUSTSTORE_LOCATION = "ssl.server.truststore.location";
    public static final String SSL_SERVER_XML = "ssl-server.xml";
    public static final String CORE_SITE_XML = "core-site.xml";
    private static String contextPath;
    protected Server server;
    private OozieStatusServer statusServer;
    private int httpPort;
    private int httpsPort;
    private final WebAppContext servletContextHandler;
    private final ServletMapper oozieServletMapper;
    private final FilterMapper oozieFilterMapper;
    private JspHandler jspHandler;
    private Services serviceController;
    private SSLServerConnectorFactory sslServerConnectorFactory;
    private Configuration conf;
    private final RewriteHandler oozieRewriteHandler;
    private final ConstraintSecurityHandler constraintSecurityHandler;
    private Configuration sslServerConf;

    @Inject
    public EmbeddedOozieServer(Server server, JspHandler jspHandler, Services serviceController, SSLServerConnectorFactory sslServerConnectorFactory, RewriteHandler oozieRewriteHandler, WebAppContext servletContextHandler, ServletMapper oozieServletMapper, FilterMapper oozieFilterMapper, ConstraintSecurityHandler constraintSecurityHandler, OozieStatusServer statusServer) {
        this.constraintSecurityHandler = constraintSecurityHandler;
        this.serviceController = Objects.requireNonNull(serviceController, "serviceController is null");
        this.jspHandler = Objects.requireNonNull(jspHandler, "jspHandler is null");
        this.sslServerConnectorFactory = Objects.requireNonNull(sslServerConnectorFactory, "sslServerConnectorFactory is null");
        this.server = Objects.requireNonNull(server, "server is null");
        this.oozieRewriteHandler = Objects.requireNonNull(oozieRewriteHandler, "rewriter is null");
        this.servletContextHandler = Objects.requireNonNull(servletContextHandler, "servletContextHandler is null");
        this.oozieServletMapper = Objects.requireNonNull(oozieServletMapper, "oozieServletMapper is null");
        this.oozieFilterMapper = Objects.requireNonNull(oozieFilterMapper, "oozieFilterMapper is null");
        this.statusServer = Objects.requireNonNull(statusServer, "oozieStatusServer is null");
    }

    public void setup() throws URISyntaxException, IOException, ServiceException {
        this.conf = ((ConfigurationService)this.serviceController.get(ConfigurationService.class)).getConf();
        String hadoopConfPath = System.getProperty("hadoop_conf_directory");
        if (hadoopConfPath != null) {
            this.sslServerConf = new Configuration();
            this.sslServerConf.addResource(new Path(hadoopConfPath + CORE_SITE_XML));
            this.sslServerConf.addResource(new Path(hadoopConfPath + SSL_SERVER_XML));
        }
        EmbeddedOozieServer.setContextPath(this.conf);
        this.httpPort = this.getConfigPort("oozie.http.port");
        HttpConfiguration httpConfiguration = new HttpConfigurationWrapper(this.conf).getDefaultHttpConfiguration();
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        connector.setPort(this.httpPort);
        connector.setHost(this.conf.get("oozie.http.hostname"));
        HandlerCollection handlerCollection = new HandlerCollection();
        this.setTrustStore();
        this.setTrustStorePassword();
        if (this.isSecured()) {
            this.httpsPort = this.getConfigPort("oozie.https.port");
            httpConfiguration.setSecurePort(this.httpsPort);
            httpConfiguration.setSecureScheme(HttpScheme.HTTPS.asString());
            ServerConnector sslConnector = this.sslServerConnectorFactory.createSecureServerConnector(this.httpsPort, this.conf, this.sslServerConf, this.server);
            this.server.setConnectors(new Connector[]{connector, sslConnector});
            this.constraintSecurityHandler.setHandler((Handler)this.servletContextHandler);
            handlerCollection.addHandler((Handler)this.constraintSecurityHandler);
        } else {
            this.server.setConnectors(new Connector[]{connector});
        }
        this.servletContextHandler.setContextPath(contextPath);
        this.oozieServletMapper.mapOozieServlets();
        this.oozieFilterMapper.addFilters();
        this.servletContextHandler.setParentLoaderPriority(true);
        this.jspHandler.setupWebAppContext(this.servletContextHandler);
        this.addErrorHandler();
        handlerCollection.addHandler((Handler)this.servletContextHandler);
        handlerCollection.addHandler((Handler)this.oozieRewriteHandler);
        this.server.setHandler((Handler)handlerCollection);
        this.applyHeadersConfiguration();
    }

    private void applyHeadersConfiguration() throws IOException {
        Properties properties = new Properties();
        String headersFile = this.conf.get("oozie.server.response.headers");
        if (StringUtils.isNotBlank((String)headersFile) && new File(headersFile).exists()) {
            properties.loadFromXML(FileUtils.openInputStream((File)new File(headersFile)));
        }
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            HeaderPatternRule rule = new HeaderPatternRule("*", name, value);
            this.oozieRewriteHandler.addRule((Rule)rule);
        }
    }

    private void setTrustStore() {
        if (System.getProperty(TRUSTSTORE_PATH_SYSTEM_PROPERTY) == null) {
            String trustStorePath = this.conf.get(OOZIE_HTTPS_TRUSTSTORE_FILE);
            if ((trustStorePath == null || trustStorePath.equals("")) && this.sslServerConf != null) {
                trustStorePath = this.sslServerConf.get(SERVER_TRUSTSTORE_LOCATION);
            }
            if (trustStorePath != null) {
                LOG.info("Setting javax.net.ssl.trustStore from config file");
                System.setProperty(TRUSTSTORE_PATH_SYSTEM_PROPERTY, trustStorePath);
            }
        } else {
            LOG.info("javax.net.ssl.trustStore is already set. The value from config file will be ignored");
        }
    }

    private void setTrustStorePassword() {
        if (System.getProperty(TRUSTSTORE_PASS_SYSTEM_PROPERTY) == null) {
            String trustStorePassword = this.conf.get(OOZIE_HTTPS_TRUSTSTORE_PASS);
            if ((trustStorePassword == null || trustStorePassword.equals("")) && this.sslServerConf != null) {
                try {
                    trustStorePassword = new String(this.sslServerConf.getPassword(SERVER_TRUSTSTORE_PASSWORD));
                }
                catch (IOException e) {
                    LOG.error("Can't get truststore password: " + e);
                }
            }
            if (trustStorePassword != null) {
                LOG.info("Setting javax.net.ssl.trustStorePassword from config file");
                System.setProperty(TRUSTSTORE_PASS_SYSTEM_PROPERTY, trustStorePassword);
            }
        } else {
            LOG.info("javax.net.ssl.trustStorePassword is already set. The value from config file will be ignored");
        }
    }

    private void addErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(400, "/error");
        errorHandler.addErrorPage(401, "/error");
        errorHandler.addErrorPage(403, "/error");
        errorHandler.addErrorPage(404, "/error");
        errorHandler.addErrorPage(405, "/error");
        errorHandler.addErrorPage(409, "/error");
        errorHandler.addErrorPage(500, "/error");
        errorHandler.addErrorPage(501, "/error");
        errorHandler.addErrorPage(503, "/error");
        errorHandler.addErrorPage("java.lang.Throwable", "/error");
        this.servletContextHandler.setErrorHandler((ErrorHandler)errorHandler);
    }

    private int getConfigPort(String confVar) {
        int port;
        String confHttpPort = this.conf.get(confVar);
        try {
            port = Integer.parseInt(confHttpPort);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(String.format("Port number for '%s \"%s\" ('%s') is not an integer.", confVar, confHttpPort, confHttpPort));
        }
        return port;
    }

    private boolean isSecured() {
        String isSSLEnabled = this.conf.get("oozie.https.enabled");
        LOG.info("Server started with oozie.https.enabled = " + isSSLEnabled);
        return isSSLEnabled != null && Boolean.valueOf(isSSLEnabled) != false;
    }

    public static void setContextPath(Configuration oozieConfiguration) {
        String baseUrl = oozieConfiguration.get("oozie.base.url");
        String contextPath = baseUrl.substring(baseUrl.lastIndexOf("/"));
        LOG.info("Server started with contextPath = " + contextPath);
        EmbeddedOozieServer.contextPath = contextPath;
    }

    public static String getContextPath(Configuration oozieConfiguration) {
        if (contextPath != null) {
            return contextPath;
        }
        EmbeddedOozieServer.setContextPath(oozieConfiguration);
        return contextPath;
    }

    public void start() throws Exception {
        this.server.start();
        this.statusServer.start();
        LOG.info("Server started.");
    }

    public void shutdown() throws Exception {
        LOG.info("Shutting down.");
        if (this.serviceController != null) {
            this.serviceController.destroy();
            LOG.info("Oozie services stopped.");
        }
        if (this.statusServer != null) {
            this.statusServer.stop();
            LOG.info("Status server stopped.");
        }
        if (this.server != null) {
            this.server.stop();
            LOG.info("Server stopped.");
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    EmbeddedOozieServer.this.shutdown();
                }
                catch (Exception e) {
                    LOG.error(String.format("There were errors during shutdown. Error message: %s", e.getMessage()));
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Injector guiceInjector = Guice.createInjector((Module[])new Module[]{new OozieGuiceModule()});
        EmbeddedOozieServer embeddedOozieServer = null;
        try {
            embeddedOozieServer = (EmbeddedOozieServer)guiceInjector.getInstance(EmbeddedOozieServer.class);
        }
        catch (ProvisionException ex) {
            LOG.error(ex.getMessage());
            System.exit(1);
        }
        embeddedOozieServer.addShutdownHook();
        embeddedOozieServer.setup();
        try {
            embeddedOozieServer.start();
        }
        catch (Exception e) {
            LOG.error(String.format("Could not start EmbeddedOozieServer! Error message: %s", e.getMessage()));
            System.exit(1);
        }
        embeddedOozieServer.join();
    }
}

