/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;

public class EvolvingDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB) {
        return switch (type) {
            case DifferenceType.COMPONENT_ADDED -> String.format("%s with ID %s was added to flow", componentB.getComponentType().getTypeName(), componentB.getIdentifier());
            case DifferenceType.COMPONENT_REMOVED -> String.format("%s with ID %s was removed from flow", componentA.getComponentType().getTypeName(), componentA.getIdentifier());
            case DifferenceType.SCHEDULED_STATE_CHANGED -> {
                if (valueB == ScheduledState.RUNNING) {
                    yield String.format("%s was started", componentB.getComponentType().getTypeName());
                }
                if (valueB == ScheduledState.ENABLED) {
                    yield String.format("%s was enabled", componentB.getComponentType().getTypeName());
                }
                yield String.format("%s was disabled", componentA.getComponentType().getTypeName());
            }
            case DifferenceType.PROPERTY_ADDED -> String.format("Property '%s' was added to %s with ID %s", fieldName, componentB.getComponentType().getTypeName(), componentB.getIdentifier());
            case DifferenceType.PROPERTY_REMOVED -> String.format("Property '%s' was removed from %s with ID %s", fieldName, componentA.getComponentType().getTypeName(), componentA.getIdentifier());
            case DifferenceType.PROPERTY_PARAMETERIZED -> String.format("Property '%s' was parameterized", fieldName);
            case DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED -> String.format("Property '%s' is no longer a parameter reference", fieldName);
            case DifferenceType.VARIABLE_ADDED -> String.format("Variable '%s' was added to Process Group with ID %s", fieldName, componentB.getIdentifier());
            case DifferenceType.VARIABLE_REMOVED -> String.format("Variable '%s' was removed from Process Group with ID %s", fieldName, componentA.getIdentifier());
            default -> String.format("%s for %s with ID %s from '%s' to '%s'", type.getDescription(), componentA.getComponentType().getTypeName(), componentA.getIdentifier(), valueA, valueB);
        };
    }
}

