/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifferenceUtil;

public class ConciseEvolvingDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB) {
        return switch (type) {
            case DifferenceType.COMPONENT_ADDED -> String.format("%s was added", componentB.getComponentType().getTypeName());
            case DifferenceType.COMPONENT_REMOVED -> String.format("%s was removed", componentA.getComponentType().getTypeName());
            case DifferenceType.SCHEDULED_STATE_CHANGED -> {
                if (valueB == ScheduledState.RUNNING) {
                    yield String.format("%s was started", componentB.getComponentType().getTypeName());
                }
                if (valueB == ScheduledState.ENABLED) {
                    yield String.format("%s was enabled", componentB.getComponentType().getTypeName());
                }
                yield String.format("%s was disabled", componentA.getComponentType().getTypeName());
            }
            case DifferenceType.PROPERTY_ADDED -> String.format("Property '%s' was added", fieldName);
            case DifferenceType.PROPERTY_REMOVED -> String.format("Property '%s' was removed", fieldName);
            case DifferenceType.PROPERTY_PARAMETERIZED -> String.format("Property '%s' was parameterized", fieldName);
            case DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED -> String.format("Property '%s' is no longer a parameter reference", fieldName);
            case DifferenceType.VARIABLE_ADDED -> String.format("Variable '%s' was added", fieldName);
            case DifferenceType.VARIABLE_REMOVED -> String.format("Variable '%s' was removed", fieldName);
            case DifferenceType.POSITION_CHANGED -> "Position was changed";
            case DifferenceType.SIZE_CHANGED -> "Size was changed";
            case DifferenceType.BENDPOINTS_CHANGED -> "Connection Bendpoints changed";
            case DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED -> {
                VersionedFlowCoordinates coordinatesB;
                VersionedFlowCoordinates coordinatesA;
                if (valueA instanceof VersionedFlowCoordinates && valueB instanceof VersionedFlowCoordinates && FlowDifferenceUtil.areRegistryUrlsEqual(coordinatesA = (VersionedFlowCoordinates)valueA, coordinatesB = (VersionedFlowCoordinates)valueB) && Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && coordinatesA.getVersion() != coordinatesB.getVersion()) {
                    yield String.format("Flow Version changed from %s to %s", coordinatesA.getVersion(), coordinatesB.getVersion());
                }
                yield String.format("From '%s' to '%s'", valueA, valueB);
            }
            default -> String.format("From '%s' to '%s'", valueA, valueB);
        };
    }
}

