/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.zendesk;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.configuration.DefaultSettings;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.common.zendesk.ZendeskProperties;
import org.apache.nifi.common.zendesk.util.ZendeskUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.zendesk.AbstractZendesk;
import org.apache.nifi.processors.zendesk.ZendeskExportMethod;
import org.apache.nifi.processors.zendesk.ZendeskResource;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpResponseStatus;
import org.apache.nifi.web.client.api.HttpUriBuilder;

@PrimaryNodeOnly
@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@DefaultSettings(yieldDuration="20 sec")
@Tags(value={"zendesk"})
@CapabilityDescription(value="Incrementally fetches data from Zendesk API.")
@Stateful(scopes={Scope.CLUSTER}, description="Paging cursor for Zendesk API is stored. Cursor is updated after each successful request.")
@WritesAttributes(value={@WritesAttribute(attribute="record.count", description="The number of records fetched by the processor.")})
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class GetZendesk
extends AbstractZendesk {
    static final int HTTP_TOO_MANY_REQUESTS = 429;
    static final String ZENDESK_EXPORT_METHOD_NAME = "zendesk-export-method";
    static final String ZENDESK_RESOURCE_NAME = "zendesk-resource";
    static final String ZENDESK_QUERY_START_TIMESTAMP_NAME = "zendesk-query-start-timestamp";
    private static final Set<Relationship> RELATIONSHIPS = Collections.singleton(REL_SUCCESS);
    private static final PropertyDescriptor ZENDESK_EXPORT_METHOD = new PropertyDescriptor.Builder().name("zendesk-export-method").displayName("Export Method").description("Method for incremental export.").required(true).allowableValues(ZendeskExportMethod.class).build();
    private static final PropertyDescriptor ZENDESK_RESOURCE = new PropertyDescriptor.Builder().name("zendesk-resource").displayName("Resource").description("The particular Zendesk resource which is meant to be exported.").required(true).allowableValues(ZendeskResource.class).build();
    private static final PropertyDescriptor ZENDESK_QUERY_START_TIMESTAMP = new PropertyDescriptor.Builder().name("zendesk-query-start-timestamp").displayName("Query Start Timestamp").description("Initial timestamp to query Zendesk API from in Unix timestamp seconds format.").addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    private static final List<PropertyDescriptor> DESCRIPTORS = Stream.of(ZendeskProperties.WEB_CLIENT_SERVICE_PROVIDER, ZendeskProperties.ZENDESK_SUBDOMAIN, ZendeskProperties.ZENDESK_USER, ZendeskProperties.ZENDESK_AUTHENTICATION_TYPE, ZendeskProperties.ZENDESK_AUTHENTICATION_CREDENTIAL, ZENDESK_EXPORT_METHOD, ZENDESK_RESOURCE, ZENDESK_QUERY_START_TIMESTAMP).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = OBJECT_MAPPER.getFactory();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(1);
        ZendeskExportMethod exportMethod = ZendeskExportMethod.forName(validationContext.getProperty(ZENDESK_EXPORT_METHOD).getValue());
        ZendeskResource zendeskResource = ZendeskResource.forName(validationContext.getProperty(ZENDESK_RESOURCE).getValue());
        if (!zendeskResource.supportsExportMethod(exportMethod)) {
            results.add(new ValidationResult.Builder().subject(ZENDESK_EXPORT_METHOD_NAME).valid(false).explanation("Not supported export method for resource.").build());
        }
        return results;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        ZendeskExportMethod exportMethod;
        ZendeskResource zendeskResource = ZendeskResource.forName(context.getProperty(ZENDESK_RESOURCE).getValue());
        URI uri = this.createUri(context, zendeskResource, exportMethod = ZendeskExportMethod.forName(context.getProperty(ZENDESK_EXPORT_METHOD).getValue()));
        HttpResponseEntity response = this.zendeskClient.performGetRequest(uri);
        if (response.statusCode() == HttpResponseStatus.OK.getCode()) {
            AtomicInteger resultCount = new AtomicInteger(0);
            FlowFile createdFlowFile = session.write(session.create(), this.httpResponseParser(context, response, zendeskResource, exportMethod, resultCount));
            int recordCount = resultCount.get();
            if (recordCount > 0) {
                FlowFile updatedFlowFile = session.putAttribute(createdFlowFile, "record.count", Integer.toString(recordCount));
                session.getProvenanceReporter().receive(updatedFlowFile, uri.toString());
                session.transfer(updatedFlowFile, REL_SUCCESS);
            } else {
                session.remove(createdFlowFile);
            }
        } else if (response.statusCode() == 429) {
            this.getLogger().error("Rate limit exceeded for uri={}, yielding before retrying request.", new Object[]{uri});
            context.yield();
        } else {
            this.getLogger().error("HTTP {} error for uri={} with response={}, yielding before retrying request.", new Object[]{response.statusCode(), uri, ZendeskUtils.getResponseBody((HttpResponseEntity)response)});
            context.yield();
        }
    }

    private URI createUri(ProcessContext context, ZendeskResource zendeskResource, ZendeskExportMethod exportMethod) {
        String resourcePath = zendeskResource.apiPath(exportMethod);
        HttpUriBuilder uriBuilder = this.uriBuilder(resourcePath);
        String cursor = this.getCursorState(context, zendeskResource, exportMethod);
        if (cursor == null) {
            String queryStartTimestamp = context.getProperty(ZENDESK_QUERY_START_TIMESTAMP).evaluateAttributeExpressions().getValue();
            uriBuilder.addQueryParameter(exportMethod.getInitialCursorQueryParameterName(), queryStartTimestamp);
        } else {
            uriBuilder.addQueryParameter(exportMethod.getCursorQueryParameterName(), cursor);
        }
        return uriBuilder.build();
    }

    private String getCursorState(ProcessContext context, ZendeskResource zendeskResource, ZendeskExportMethod exportMethod) {
        try {
            return context.getStateManager().getState(Scope.CLUSTER).get(zendeskResource.getValue() + exportMethod.getValue());
        }
        catch (IOException e) {
            throw new ProcessException("Failed to retrieve cursor state", (Throwable)e);
        }
    }

    private OutputStreamCallback httpResponseParser(ProcessContext context, HttpResponseEntity response, ZendeskResource zendeskResource, ZendeskExportMethod exportMethod, AtomicInteger resultCount) {
        return out -> {
            try (JsonParser parser = JSON_FACTORY.createParser(response.body());
                 JsonGenerator generator = JSON_FACTORY.createGenerator(out, JsonEncoding.UTF8);){
                while (parser.nextToken() != null) {
                    if (parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    if (zendeskResource.getResponseFieldName().equals(fieldName)) {
                        int numberOfExtractedRecords = this.extractZendeskResourceData(parser, generator);
                        resultCount.addAndGet(numberOfExtractedRecords);
                    }
                    if (!exportMethod.getCursorJsonFieldName().equals(fieldName) || parser.currentToken() == JsonToken.VALUE_NULL) continue;
                    this.updateCursorState(context, zendeskResource, exportMethod, parser.getText());
                }
            }
        };
    }

    private int extractZendeskResourceData(JsonParser parser, JsonGenerator generator) throws IOException {
        ArrayNode zendeskItems = (ArrayNode)OBJECT_MAPPER.readTree(parser);
        if (zendeskItems.size() > 0) {
            generator.writeStartArray();
            for (JsonNode zendeskItem : zendeskItems) {
                generator.writeTree((TreeNode)zendeskItem);
            }
            generator.writeEndArray();
        }
        return zendeskItems.size();
    }

    private void updateCursorState(ProcessContext context, ZendeskResource zendeskResource, ZendeskExportMethod exportMethod, String cursor) {
        try {
            context.getStateManager().setState(Collections.singletonMap(zendeskResource.getValue() + exportMethod.getValue(), cursor), Scope.CLUSTER);
        }
        catch (IOException e) {
            throw new ProcessException("Failed to update cursor state", (Throwable)e);
        }
    }
}

