/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.zendesk;

import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.common.zendesk.ZendeskAuthenticationContext;
import org.apache.nifi.common.zendesk.ZendeskAuthenticationType;
import org.apache.nifi.common.zendesk.ZendeskClient;
import org.apache.nifi.common.zendesk.ZendeskProperties;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public abstract class AbstractZendesk
extends AbstractProcessor {
    static final String RECORD_COUNT_ATTRIBUTE_NAME = "record.count";
    ZendeskClient zendeskClient;
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("For FlowFiles created as a result of a successful HTTP request.").build();

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        WebClientServiceProvider webClientServiceProvider = (WebClientServiceProvider)context.getProperty(ZendeskProperties.WEB_CLIENT_SERVICE_PROVIDER).asControllerService(WebClientServiceProvider.class);
        String user = context.getProperty(ZendeskProperties.ZENDESK_USER).evaluateAttributeExpressions().getValue();
        ZendeskAuthenticationType authenticationType = ZendeskAuthenticationType.forName((String)context.getProperty(ZendeskProperties.ZENDESK_AUTHENTICATION_TYPE).getValue());
        String authenticationCredentials = context.getProperty(ZendeskProperties.ZENDESK_AUTHENTICATION_CREDENTIAL).evaluateAttributeExpressions().getValue();
        String subdomain = context.getProperty(ZendeskProperties.ZENDESK_SUBDOMAIN).evaluateAttributeExpressions().getValue();
        ZendeskAuthenticationContext authenticationContext = new ZendeskAuthenticationContext(subdomain, user, authenticationType, authenticationCredentials);
        this.zendeskClient = new ZendeskClient(webClientServiceProvider, authenticationContext);
    }

    HttpUriBuilder uriBuilder(String resourcePath) {
        return this.zendeskClient.uriBuilder(resourcePath);
    }
}

