/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk.validation;

import com.fasterxml.jackson.core.JsonPointer;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.record.path.exception.RecordPathException;

public class JsonPointerPropertyNameValidator
implements Validator {
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        try {
            JsonPointer.compile((String)subject);
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).explanation("Valid JsonPointer").build();
        }
        catch (RecordPathException e) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Property Name is not a valid JsonPointer value: " + e.getMessage()).build();
        }
    }
}

