/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.util.StringUtils;

public final class HeaderMapExtractor {
    public static final String HEADER_PREFIX = "header.";

    private HeaderMapExtractor() {
    }

    public static Map<String, List<String>> getHeaderMap(Map<String, String> flowFileAttributes) {
        return flowFileAttributes.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(HEADER_PREFIX)).filter(entry -> StringUtils.isNotBlank((String)((String)entry.getValue()))).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>(StringUtils.substringAfter((String)((String)entry.getKey()), (String)HEADER_PREFIX), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, HeaderMapExtractor::headerValueMapper));
    }

    private static List<String> headerValueMapper(Map.Entry<String, String> entry) {
        return Arrays.stream(entry.getValue().split(",")).map(String::trim).collect(Collectors.toList());
    }
}

