/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.websocket.WebSocketConfigurationException;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.WebSocketServerService;
import org.apache.nifi.websocket.jetty.AbstractJettyWebSocketService;
import org.apache.nifi.websocket.jetty.RoutingWebSocketListener;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

@Tags(value={"WebSocket", "Jetty", "server"})
@CapabilityDescription(value="Implementation of WebSocketServerService. This service uses Jetty WebSocket server module to provide WebSocket session management throughout the application.")
public class JettyWebSocketServer
extends AbstractJettyWebSocketService
implements WebSocketServerService {
    private static final Map<Integer, JettyWebSocketServer> portToControllerService = new ConcurrentHashMap<Integer, JettyWebSocketServer>();
    public static final AllowableValue CLIENT_NONE = new AllowableValue("no", "No Authentication", "Processor will not authenticate clients. Anyone can communicate with this Processor anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("want", "Want Authentication", "Processor will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("need", "Need Authentication", "Processor will reject communications from any client unless the client provides a certificate that is trusted by the TrustStore specified in the SSL Context Service");
    public static final AllowableValue LOGIN_SERVICE_HASH = new AllowableValue("hash", "HashLoginService", "See http://www.eclipse.org/jetty/javadoc/current/org/eclipse/jetty/security/HashLoginService.html for detail.");
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("client-authentication").displayName("SSL Client Authentication").description("Specifies whether or not the Processor should authenticate client by its certificate. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new AllowableValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();
    public static final PropertyDescriptor LISTEN_PORT = new PropertyDescriptor.Builder().name("listen-port").displayName("Listen Port").description("The port number on which this WebSocketServer listens to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor BASIC_AUTH = new PropertyDescriptor.Builder().name("basic-auth").displayName("Enable Basic Authentication").description("If enabled, client connection requests are authenticated with Basic authentication using the specified Login Provider.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor AUTH_PATH_SPEC = new PropertyDescriptor.Builder().name("auth-path-spec").displayName("Basic Authentication Path Spec").description("Specify a Path Spec to apply Basic Authentication.").required(false).defaultValue("/*").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor AUTH_ROLES = new PropertyDescriptor.Builder().name("auth-roles").displayName("Basic Authentication Roles").description("The authenticated user must have one of specified role. Multiple roles can be set as comma separated string. '*' represents any role and so does '**' any role including no role.").required(false).defaultValue("**").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor LOGIN_SERVICE = new PropertyDescriptor.Builder().name("login-service").displayName("Login Service").description("Specify which Login Service to use for Basic Authentication.").required(false).allowableValues(new AllowableValue[]{LOGIN_SERVICE_HASH}).defaultValue(LOGIN_SERVICE_HASH.getValue()).build();
    public static final PropertyDescriptor USERS_PROPERTIES_FILE = new PropertyDescriptor.Builder().name("users-properties-file").displayName("Users Properties File").description("Specify a property file containing users for Basic Authentication using HashLoginService. See http://www.eclipse.org/jetty/documentation/current/configuring-security.html for detail.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    private static final List<PropertyDescriptor> properties;
    private WebSocketPolicy configuredPolicy;
    private Server server;
    private Integer listenPort;
    private ServletHandler servletHandler;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String loginServiceValue;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(BASIC_AUTH).asBoolean().booleanValue() && LOGIN_SERVICE_HASH.equals((Object)(loginServiceValue = validationContext.getProperty(LOGIN_SERVICE).getValue())) && !validationContext.getProperty(USERS_PROPERTIES_FILE).isSet()) {
            results.add(new ValidationResult.Builder().subject(USERS_PROPERTIES_FILE.getDisplayName()).explanation("it is required by HashLoginService").valid(false).build());
        }
        return results;
    }

    @OnEnabled
    public void startServer(ConfigurationContext context) throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.getLogger().info("A WebSocket server is already running. {}", new Object[]{this.server});
            return;
        }
        this.configuredPolicy = WebSocketPolicy.newServerPolicy();
        this.configurePolicy(context, this.configuredPolicy);
        this.server = new Server();
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection();
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (context.getProperty(BASIC_AUTH).asBoolean().booleanValue()) {
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            contextHandler.insertHandler((HandlerWrapper)securityHandler);
            Constraint constraint = new Constraint();
            constraint.setName("auth");
            constraint.setAuthenticate(true);
            String roles = context.getProperty(AUTH_ROLES).evaluateAttributeExpressions().getValue();
            constraint.setRoles(roles.split(","));
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setPathSpec(context.getProperty(AUTH_PATH_SPEC).evaluateAttributeExpressions().getValue());
            constraintMapping.setConstraint(constraint);
            DefaultAuthenticatorFactory authenticatorFactory = new DefaultAuthenticatorFactory();
            securityHandler.setAuthenticatorFactory((Authenticator.Factory)authenticatorFactory);
            securityHandler.setAuthMethod("BASIC");
            securityHandler.setRealmName(((Object)((Object)this)).getClass().getSimpleName());
            securityHandler.setConstraintMappings(Collections.singletonList(constraintMapping));
            String loginServiceValue = context.getProperty(LOGIN_SERVICE).getValue();
            if (!LOGIN_SERVICE_HASH.equals((Object)loginServiceValue)) {
                throw new IllegalArgumentException("Unsupported Login Service: " + loginServiceValue);
            }
            String usersFilePath = context.getProperty(USERS_PROPERTIES_FILE).evaluateAttributeExpressions().getValue();
            HashLoginService loginService = new HashLoginService("HashLoginService", usersFilePath);
            this.server.addBean((Object)loginService);
            securityHandler.setLoginService((LoginService)loginService);
        }
        this.servletHandler = new ServletHandler();
        contextHandler.insertHandler((HandlerWrapper)this.servletHandler);
        handlerCollection.setHandlers(new Handler[]{contextHandler});
        this.server.setHandler((Handler)handlerCollection);
        this.listenPort = context.getProperty(LISTEN_PORT).evaluateAttributeExpressions().asInteger();
        SslContextFactory sslContextFactory = this.createSslFactory(context);
        ServerConnector serverConnector = this.createConnector(sslContextFactory, this.listenPort);
        this.server.setConnectors(new Connector[]{serverConnector});
        this.servletHandler.addServletWithMapping(JettyWebSocketServlet.class, "/*");
        this.getLogger().info("Starting JettyWebSocketServer on port {}.", new Object[]{this.listenPort});
        this.server.start();
        this.listenPort = serverConnector.getLocalPort();
        portToControllerService.put(this.listenPort, this);
    }

    public int getListeningPort() {
        return this.listenPort;
    }

    private ServerConnector createConnector(SslContextFactory sslContextFactory, Integer listenPort) {
        ServerConnector serverConnector;
        if (sslContextFactory == null) {
            serverConnector = new ServerConnector(this.server);
        } else {
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
        }
        serverConnector.setPort(listenPort.intValue());
        return serverConnector;
    }

    private SslContextFactory createSslFactory(ConfigurationContext context) {
        boolean want;
        boolean need;
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
        if (CLIENT_NEED.equals((Object)clientAuthValue)) {
            need = true;
            want = false;
        } else if (CLIENT_WANT.equals((Object)clientAuthValue)) {
            need = false;
            want = true;
        } else {
            need = false;
            want = false;
        }
        SslContextFactory sslFactory = sslService == null ? null : this.createSslFactory(sslService, need, want, null);
        return sslFactory;
    }

    @OnDisabled
    @OnShutdown
    public void stopServer() throws Exception {
        if (this.server == null) {
            return;
        }
        this.getLogger().info("Stopping JettyWebSocketServer.");
        this.server.stop();
        if (portToControllerService.containsKey(this.listenPort) && this.getIdentifier().equals(portToControllerService.get(this.listenPort).getIdentifier())) {
            portToControllerService.remove(this.listenPort);
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.addAll(JettyWebSocketServer.getAbstractPropertyDescriptors());
        props.add(LISTEN_PORT);
        props.add(SSL_CONTEXT);
        props.add(CLIENT_AUTH);
        props.add(BASIC_AUTH);
        props.add(AUTH_PATH_SPEC);
        props.add(AUTH_ROLES);
        props.add(LOGIN_SERVICE);
        props.add(USERS_PROPERTIES_FILE);
        properties = Collections.unmodifiableList(props);
    }

    public static class JettyWebSocketServlet
    extends WebSocketServlet
    implements WebSocketCreator {
        public void configure(WebSocketServletFactory webSocketServletFactory) {
            webSocketServletFactory.setCreator((WebSocketCreator)this);
        }

        public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
            WebSocketMessageRouter router;
            URI requestURI = servletUpgradeRequest.getRequestURI();
            int port = servletUpgradeRequest.getLocalPort();
            final JettyWebSocketServer service = portToControllerService.get(port);
            if (service == null) {
                throw new RuntimeException("No controller service is bound with port: " + port);
            }
            String path = requestURI.getPath();
            try {
                router = service.routers.getRouterOrFail(path);
            }
            catch (WebSocketConfigurationException e) {
                throw new IllegalStateException("Failed to get router due to: " + e, e);
            }
            RoutingWebSocketListener listener = new RoutingWebSocketListener(router){

                @Override
                public void onWebSocketConnect(Session session) {
                    WebSocketPolicy currentPolicy = session.getPolicy();
                    currentPolicy.setInputBufferSize(service.configuredPolicy.getInputBufferSize());
                    currentPolicy.setMaxTextMessageSize(service.configuredPolicy.getMaxTextMessageSize());
                    currentPolicy.setMaxBinaryMessageSize(service.configuredPolicy.getMaxBinaryMessageSize());
                    super.onWebSocketConnect(session);
                }
            };
            return listener;
        }
    }
}

