/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import dto.SessionInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.websocket.WebSocketClientService;
import org.apache.nifi.websocket.WebSocketConfigurationException;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.jetty.AbstractJettyWebSocketService;
import org.apache.nifi.websocket.jetty.RoutingWebSocketListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import util.HeaderMapExtractor;

@Tags(value={"WebSocket", "Jetty", "client"})
@CapabilityDescription(value="Implementation of WebSocketClientService. This service uses Jetty WebSocket client module to provide WebSocket session management throughout the application.")
public class JettyWebSocketClient
extends AbstractJettyWebSocketService
implements WebSocketClientService {
    public static final PropertyDescriptor WS_URI = new PropertyDescriptor.Builder().name("websocket-uri").displayName("WebSocket URI").description("The WebSocket URI this client connects to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.URI_VALIDATOR).addValidator((subject, input, context) -> {
        ValidationResult.Builder result = new ValidationResult.Builder().valid(input.startsWith("/")).subject(subject);
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            result.explanation("Expression Language Present").valid(true);
        } else {
            result.explanation("Protocol should be either 'ws' or 'wss'.").valid(input.startsWith("ws://") || input.startsWith("wss://"));
        }
        return result.build();
    }).build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("connection-timeout").displayName("Connection Timeout").description("The timeout to connect the WebSocket URI.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("3 sec").build();
    public static final PropertyDescriptor CONNECTION_ATTEMPT_COUNT = new PropertyDescriptor.Builder().name("connection-attempt-timeout").displayName("Connection Attempt Count").description("The number of times to try and establish a connection.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("3").build();
    public static final PropertyDescriptor SESSION_MAINTENANCE_INTERVAL = new PropertyDescriptor.Builder().name("session-maintenance-interval").displayName("Session Maintenance Interval").description("The interval between session maintenance activities. A WebSocket session established with a WebSocket server can be terminated due to different reasons including restarting the WebSocket server or timing out inactive sessions. This session maintenance activity is periodically executed in order to reconnect those lost sessions, so that a WebSocket client can reuse the same session id transparently after it reconnects successfully.  The maintenance activity is executed until corresponding processors or this controller service is stopped.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10 sec").build();
    public static final PropertyDescriptor USER_NAME = new PropertyDescriptor.Builder().name("user-name").displayName("User Name").description("The user name for Basic Authentication.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor USER_PASSWORD = new PropertyDescriptor.Builder().name("user-password").displayName("User Password").description("The user password for Basic Authentication.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor AUTH_CHARSET = new PropertyDescriptor.Builder().name("authentication-charset").displayName("Authentication Header Charset").description("The charset for Basic Authentication header base64 string.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).defaultValue("US-ASCII").build();
    public static final PropertyDescriptor CUSTOM_AUTH = new PropertyDescriptor.Builder().name("custom-authorization").displayName("Custom Authorization").description("Configures a custom HTTP Authorization Header as described in RFC 7235 Section 4.2. Setting a custom Authorization Header excludes configuring the User Name and User Password properties for Basic Authentication.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("proxy-host").displayName("HTTP Proxy Host").description("The host name of the HTTP Proxy.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("proxy-port").displayName("HTTP Proxy Port").description("The port number of the HTTP Proxy.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties;
    private final Map<String, SessionInfo> activeSessions = new ConcurrentHashMap<String, SessionInfo>();
    private final ReentrantLock connectionLock = new ReentrantLock();
    private WebSocketClient client;
    private URI webSocketUri;
    private long connectionTimeoutMillis;
    private volatile ScheduledExecutorService sessionMaintenanceScheduler;
    private ConfigurationContext configurationContext;
    protected String authorizationHeader;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnEnabled
    public void startClient(ConfigurationContext context) throws Exception {
        this.configurationContext = context;
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        SslContextFactory sslContextFactory = null;
        if (sslService != null) {
            sslContextFactory = this.createSslFactory(sslService, false, false, null);
        }
        HttpClient httpClient = new HttpClient(sslContextFactory);
        String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
        Integer proxyPort = context.getProperty(PROXY_PORT).evaluateAttributeExpressions().asInteger();
        if (proxyHost != null && proxyPort != null) {
            HttpProxy httpProxy = new HttpProxy(proxyHost, proxyPort.intValue());
            httpClient.getProxyConfiguration().getProxies().add(httpProxy);
        }
        this.client = new WebSocketClient(httpClient);
        this.configurePolicy(context, this.client.getPolicy());
        String userName = context.getProperty(USER_NAME).evaluateAttributeExpressions().getValue();
        String userPassword = context.getProperty(USER_PASSWORD).evaluateAttributeExpressions().getValue();
        String customAuth = context.getProperty(CUSTOM_AUTH).evaluateAttributeExpressions().getValue();
        if (!StringUtils.isEmpty((String)customAuth)) {
            this.authorizationHeader = customAuth;
        } else if (!StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)userPassword)) {
            String charsetName = context.getProperty(AUTH_CHARSET).evaluateAttributeExpressions().getValue();
            if (StringUtils.isEmpty((String)charsetName)) {
                throw new IllegalArgumentException(AUTH_CHARSET.getDisplayName() + " was not specified.");
            }
            Charset charset = Charset.forName(charsetName);
            String base64String = Base64.getEncoder().encodeToString((userName + ":" + userPassword).getBytes(charset));
            this.authorizationHeader = "Basic " + base64String;
        } else {
            this.authorizationHeader = null;
        }
        this.client.start();
        this.activeSessions.clear();
        this.webSocketUri = new URI(context.getProperty(WS_URI).evaluateAttributeExpressions(new HashMap()).getValue());
        this.connectionTimeoutMillis = context.getProperty(CONNECTION_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS);
        Long sessionMaintenanceInterval = context.getProperty(SESSION_MAINTENANCE_INTERVAL).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS);
        this.sessionMaintenanceScheduler = Executors.newSingleThreadScheduledExecutor();
        this.sessionMaintenanceScheduler.scheduleAtFixedRate(() -> {
            try {
                this.maintainSessions();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to maintain sessions due to {}", new Object[]{e}, (Throwable)e);
            }
        }, sessionMaintenanceInterval, sessionMaintenanceInterval, TimeUnit.MILLISECONDS);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean isBaseAuthUsed;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(1);
        boolean proxyHostSet = validationContext.getProperty(PROXY_HOST).isSet();
        boolean proxyPortSet = validationContext.getProperty(PROXY_PORT).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            results.add(new ValidationResult.Builder().subject("HTTP Proxy Host and Port").valid(false).explanation("If HTTP Proxy Host or HTTP Proxy Port is set, both must be set").build());
        }
        boolean bl = isBaseAuthUsed = validationContext.getProperty(USER_NAME).isSet() || validationContext.getProperty(USER_PASSWORD).isSet();
        if (isBaseAuthUsed && validationContext.getProperty(CUSTOM_AUTH).isSet()) {
            results.add(new ValidationResult.Builder().subject("Authentication").valid(false).explanation("Properties related to Basic Authentication (\"User Name\" and \"User Password\") cannot be used together with \"Custom Authorization\"").build());
        }
        return results;
    }

    @OnDisabled
    @OnShutdown
    public void stopClient() throws Exception {
        this.activeSessions.clear();
        if (this.sessionMaintenanceScheduler != null) {
            try {
                this.sessionMaintenanceScheduler.shutdown();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to shutdown session maintainer due to {}", new Object[]{e}, (Throwable)e);
            }
            this.sessionMaintenanceScheduler = null;
        }
        if (this.client == null) {
            return;
        }
        this.client.stop();
        this.client = null;
    }

    public void connect(String clientId) throws IOException {
        this.connect(clientId, null, Collections.emptyMap());
    }

    public void connect(String clientId, Map<String, String> flowFileAttributes) throws IOException {
        this.connect(clientId, null, flowFileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String clientId, String sessionId, Map<String, String> flowFileAttributes) throws IOException {
        try {
            this.webSocketUri = new URI(this.configurationContext.getProperty(WS_URI).evaluateAttributeExpressions(flowFileAttributes).getValue());
        }
        catch (URISyntaxException e) {
            throw new ProcessException("Could not create websocket URI", (Throwable)e);
        }
        this.connectionLock.lock();
        try {
            WebSocketMessageRouter router;
            try {
                router = this.routers.getRouterOrFail(clientId);
            }
            catch (WebSocketConfigurationException e) {
                throw new IllegalStateException("Failed to get router due to: " + e, e);
            }
            RoutingWebSocketListener listener = new RoutingWebSocketListener(router);
            listener.setSessionId(sessionId);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            if (!flowFileAttributes.isEmpty()) {
                request.setHeaders(HeaderMapExtractor.getHeaderMap(flowFileAttributes));
            }
            if (!StringUtils.isEmpty((String)this.authorizationHeader)) {
                request.setHeader(HttpHeader.AUTHORIZATION.asString(), this.authorizationHeader);
            }
            int connectCount = this.configurationContext.getProperty(CONNECTION_ATTEMPT_COUNT).evaluateAttributeExpressions().asInteger();
            Session session = null;
            for (int i = 0; i < connectCount; ++i) {
                Future<Session> connect = this.createWebsocketSession(listener, request);
                this.getLogger().info("Connecting to : {}", new Object[]{this.webSocketUri});
                try {
                    session = connect.get(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (Exception e) {
                    if (i == connectCount - 1) {
                        throw new IOException("Failed to connect " + this.webSocketUri + " due to: " + e, e);
                    }
                    this.getLogger().warn("Failed to connect to {}, reconnection attempt {}", new Object[]{this.webSocketUri, i + 1});
                    continue;
                }
            }
            this.getLogger().info("Connected, session={}", new Object[]{session});
            this.activeSessions.put(clientId, new SessionInfo(listener.getSessionId(), flowFileAttributes));
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    Future<Session> createWebsocketSession(RoutingWebSocketListener listener, ClientUpgradeRequest request) throws IOException {
        return this.client.connect((Object)listener, this.webSocketUri, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maintainSessions() throws Exception {
        if (this.client == null) {
            return;
        }
        this.connectionLock.lock();
        ComponentLog logger = this.getLogger();
        try {
            for (String clientId : this.activeSessions.keySet()) {
                WebSocketMessageRouter router;
                try {
                    router = this.routers.getRouterOrFail(clientId);
                }
                catch (WebSocketConfigurationException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The clientId {} is no longer active. Discarding the clientId.", new Object[]{clientId});
                    }
                    this.activeSessions.remove(clientId);
                    continue;
                }
                SessionInfo sessionInfo = this.activeSessions.get(clientId);
                if (router.containsSession(sessionInfo.getSessionId())) continue;
                this.connect(clientId, sessionInfo.getSessionId(), sessionInfo.getFlowFileAttributes());
            }
        }
        finally {
            this.connectionLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Session maintenance completed. activeSessions={}", new Object[]{this.activeSessions});
        }
    }

    public String getTargetUri() {
        return this.webSocketUri.toString();
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(JettyWebSocketClient.getAbstractPropertyDescriptors());
        props.add(WS_URI);
        props.add(SSL_CONTEXT);
        props.add(CONNECTION_TIMEOUT);
        props.add(CONNECTION_ATTEMPT_COUNT);
        props.add(SESSION_MAINTENANCE_INTERVAL);
        props.add(USER_NAME);
        props.add(USER_PASSWORD);
        props.add(AUTH_CHARSET);
        props.add(CUSTOM_AUTH);
        props.add(PROXY_HOST);
        props.add(PROXY_PORT);
        properties = Collections.unmodifiableList(props);
    }
}

