/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.util.UUID;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.WebSocketSession;
import org.apache.nifi.websocket.jetty.JettyWebSocketSession;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class RoutingWebSocketListener
extends WebSocketAdapter {
    private final WebSocketMessageRouter router;
    private String sessionId;

    public RoutingWebSocketListener(WebSocketMessageRouter router) {
        this.router = router;
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        if (this.sessionId == null || this.sessionId.isEmpty()) {
            this.sessionId = UUID.randomUUID().toString();
        }
        JettyWebSocketSession webSocketSession = new JettyWebSocketSession(this.sessionId, session);
        this.router.captureSession((WebSocketSession)webSocketSession);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        this.router.onWebSocketClose(this.sessionId, statusCode, reason);
    }

    public void onWebSocketText(String message) {
        this.router.onWebSocketText(this.sessionId, message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.router.onWebSocketBinary(this.sessionId, payload, offset, len);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

