/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationRequest;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponse;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenTypeHint;
import org.apache.nifi.web.security.token.LogoutAuthenticationToken;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcLogoutSuccessHandler
implements LogoutSuccessHandler {
    static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String LOGOUT_COMPLETE_PATH = "/nifi/logout-complete";
    private static final String ID_TOKEN_HINT_PARAMETER = "id_token_hint";
    private static final String POST_LOGOUT_REDIRECT_URI_PARAMETER = "post_logout_redirect_uri";
    private static final Logger logger = LoggerFactory.getLogger(OidcLogoutSuccessHandler.class);
    private final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final LogoutRequestManager logoutRequestManager;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private final TokenRevocationResponseClient tokenRevocationResponseClient;

    public OidcLogoutSuccessHandler(LogoutRequestManager logoutRequestManager, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository, TokenRevocationResponseClient tokenRevocationResponseClient) {
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Logout Request Manager required");
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository, "Client Registration Repository required");
        this.authorizedClientRepository = Objects.requireNonNull(authorizedClientRepository, "Authorized Client Repository required");
        this.tokenRevocationResponseClient = Objects.requireNonNull(tokenRevocationResponseClient, "Revocation Response Client required");
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Optional<String> logoutRequestIdentifier = this.applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
        if (logoutRequestIdentifier.isPresent()) {
            String targetUrl;
            String requestIdentifier = logoutRequestIdentifier.get();
            LogoutRequest logoutRequest = this.logoutRequestManager.get(requestIdentifier);
            if (logoutRequest == null) {
                logger.warn("OIDC Logout Request [{}] not found", (Object)requestIdentifier);
                targetUrl = this.getPostLogoutRedirectUri(request);
            } else {
                String mappedUserIdentity = logoutRequest.getMappedUserIdentity();
                targetUrl = this.processLogoutRequest(request, response, requestIdentifier, mappedUserIdentity);
            }
            response.sendRedirect(targetUrl);
        }
    }

    private String processLogoutRequest(HttpServletRequest request, HttpServletResponse response, String requestIdentifier, String mappedUserIdentity) {
        String targetUrl;
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(OidcRegistrationProperty.REGISTRATION_ID.getProperty());
        OidcAuthorizedClient oidcAuthorizedClient = this.getOidcAuthorizedClient(clientRegistration, mappedUserIdentity, request);
        if (oidcAuthorizedClient == null) {
            targetUrl = this.getPostLogoutRedirectUri(request);
            logger.warn("OIDC Logout Request [{}] Identity [{}] ID Token not found", (Object)requestIdentifier, (Object)mappedUserIdentity);
        } else {
            URI endSessionEndpoint = this.getEndSessionEndpoint(clientRegistration);
            if (endSessionEndpoint == null) {
                targetUrl = this.getPostLogoutRedirectUri(request);
                logger.debug("OIDC Logout Request [{}] Identity [{}] end_session_endpoint not provided", (Object)requestIdentifier, (Object)mappedUserIdentity);
            } else {
                String postLogoutRedirectUri = this.getPostLogoutRedirectUri(request);
                OidcIdToken oidcIdToken = oidcAuthorizedClient.getIdToken();
                String idToken = oidcIdToken.getTokenValue();
                targetUrl = this.getEndSessionTargetUrl(endSessionEndpoint, idToken, postLogoutRedirectUri);
                logger.info("OIDC Logout Request [{}] Identity [{}] initiated", (Object)requestIdentifier, (Object)mappedUserIdentity);
            }
            LogoutAuthenticationToken principal = new LogoutAuthenticationToken(mappedUserIdentity);
            this.authorizedClientRepository.removeAuthorizedClient(OidcRegistrationProperty.REGISTRATION_ID.getProperty(), (Authentication)principal, request, response);
            this.processRefreshTokenRevocation(oidcAuthorizedClient, mappedUserIdentity);
            this.processAccessTokenRevocation(oidcAuthorizedClient, mappedUserIdentity);
        }
        return targetUrl;
    }

    private void processAccessTokenRevocation(OidcAuthorizedClient oidcAuthorizedClient, String userIdentity) {
        OAuth2AccessToken accessToken = oidcAuthorizedClient.getAccessToken();
        String token = accessToken.getTokenValue();
        TokenRevocationRequest revocationRequest = new TokenRevocationRequest(token, TokenTypeHint.ACCESS_TOKEN.getHint());
        TokenRevocationResponse revocationResponse = this.tokenRevocationResponseClient.getRevocationResponse(revocationRequest);
        logger.info("Identity [{}] OIDC Access Token Revocation completed [HTTP {}]", (Object)userIdentity, (Object)revocationResponse.getStatusCode());
    }

    private void processRefreshTokenRevocation(OidcAuthorizedClient oidcAuthorizedClient, String userIdentity) {
        OAuth2RefreshToken refreshToken = oidcAuthorizedClient.getRefreshToken();
        if (refreshToken == null) {
            logger.debug("Identity [{}] OIDC Refresh Token not found for revocation", (Object)userIdentity);
        } else {
            String token = refreshToken.getTokenValue();
            TokenRevocationRequest revocationRequest = new TokenRevocationRequest(token, TokenTypeHint.REFRESH_TOKEN.getHint());
            TokenRevocationResponse revocationResponse = this.tokenRevocationResponseClient.getRevocationResponse(revocationRequest);
            logger.info("Identity [{}] OIDC Refresh Token Revocation completed [HTTP {}]", (Object)userIdentity, (Object)revocationResponse.getStatusCode());
        }
    }

    private OidcAuthorizedClient getOidcAuthorizedClient(ClientRegistration clientRegistration, String userIdentity, HttpServletRequest request) {
        OidcAuthorizedClient oidcAuthorizedClient;
        LogoutAuthenticationToken authenticationToken;
        String clientRegistrationId = clientRegistration.getRegistrationId();
        OAuth2AuthorizedClient authorizedClient = this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, (Authentication)(authenticationToken = new LogoutAuthenticationToken(userIdentity)), request);
        if (authorizedClient == null) {
            logger.warn("Identity [{}] OpenID Connect Authorized Client not found", (Object)userIdentity);
            oidcAuthorizedClient = null;
        } else if (authorizedClient instanceof OidcAuthorizedClient) {
            oidcAuthorizedClient = (OidcAuthorizedClient)authorizedClient;
        } else {
            logger.error("Identity [{}] OpenID Connect Authorized Client Class not found [{}]", (Object)userIdentity, authorizedClient.getClass());
            oidcAuthorizedClient = null;
        }
        return oidcAuthorizedClient;
    }

    private URI getEndSessionEndpoint(ClientRegistration clientRegistration) {
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        Map configurationMetadata = providerDetails.getConfigurationMetadata();
        Object endSessionEndpoint = configurationMetadata.get(END_SESSION_ENDPOINT);
        return endSessionEndpoint == null ? null : URI.create(endSessionEndpoint.toString());
    }

    private String getEndSessionTargetUrl(URI endSessionEndpoint, String idToken, String postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam(ID_TOKEN_HINT_PARAMETER, new Object[]{idToken});
        builder.queryParam(POST_LOGOUT_REDIRECT_URI_PARAMETER, new Object[]{postLogoutRedirectUri});
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    private String getPostLogoutRedirectUri(HttpServletRequest request) {
        return RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).path(LOGOUT_COMPLETE_PATH).build().toString();
    }
}

