/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxAuthenticationFilter;
import org.apache.nifi.web.security.knox.KnoxAuthenticationRequestToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class KnoxAuthenticationFilterTest {
    private static final String COOKIE_NAME = "hadoop-jwt";
    private KnoxAuthenticationFilter knoxAuthenticationFilter;

    @BeforeEach
    public void setUp() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isKnoxSsoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)nifiProperties.getKnoxCookieName()).thenReturn((Object)COOKIE_NAME);
        this.knoxAuthenticationFilter = new KnoxAuthenticationFilter();
        this.knoxAuthenticationFilter.setProperties(nifiProperties);
    }

    @Test
    public void testInsecureHttp() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
        Assertions.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testNullCookies() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn(null);
        Assertions.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testNoCookies() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
        Assertions.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testWrongCookieName() {
        String jwt = "my-jwt";
        Cookie knoxCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)knoxCookie.getName()).thenReturn((Object)"not-hadoop-jwt");
        Mockito.when((Object)knoxCookie.getValue()).thenReturn((Object)"my-jwt");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{knoxCookie});
        KnoxAuthenticationRequestToken authRequest = (KnoxAuthenticationRequestToken)this.knoxAuthenticationFilter.attemptAuthentication(request);
        Assertions.assertNull((Object)authRequest);
    }

    @Test
    public void testKnoxCookie() {
        String jwt = "my-jwt";
        Cookie knoxCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)knoxCookie.getName()).thenReturn((Object)COOKIE_NAME);
        Mockito.when((Object)knoxCookie.getValue()).thenReturn((Object)"my-jwt");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{knoxCookie});
        KnoxAuthenticationRequestToken authRequest = (KnoxAuthenticationRequestToken)this.knoxAuthenticationFilter.attemptAuthentication(request);
        Assertions.assertNotNull((Object)authRequest);
        Assertions.assertEquals((Object)"my-jwt", (Object)authRequest.getToken());
    }
}

