/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import java.time.Instant;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtLogoutListener;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@ExtendWith(value={MockitoExtension.class})
public class StandardJwtLogoutListenerTest {
    private static final String ID = UUID.randomUUID().toString();
    private static final Instant EXPIRES = Instant.now();
    private static final String TOKEN = "TOKEN";
    private static final String TYPE_FIELD = "typ";
    private static final String JWT_TYPE = "JWT";
    @Mock
    private JwtRevocationService jwtRevocationService;
    @Mock
    private JwtDecoder jwtDecoder;
    private Jwt jwt;
    private StandardJwtLogoutListener listener;

    @BeforeEach
    public void setListener() {
        this.listener = new StandardJwtLogoutListener(this.jwtDecoder, this.jwtRevocationService);
        this.jwt = Jwt.withTokenValue((String)TOKEN).header(TYPE_FIELD, (Object)JWT_TYPE).jti(ID).expiresAt(EXPIRES).build();
    }

    @Test
    public void testLogoutBearerTokenNullZeroInteractions() {
        this.listener.logout(null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.jwtDecoder});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.jwtRevocationService});
    }

    @Test
    public void testLogoutBearerToken() {
        Mockito.when((Object)this.jwtDecoder.decode((String)ArgumentMatchers.eq((Object)TOKEN))).thenReturn((Object)this.jwt);
        this.listener.logout(TOKEN);
        ((JwtRevocationService)Mockito.verify((Object)this.jwtRevocationService)).setRevoked((String)ArgumentMatchers.eq((Object)ID), (Instant)ArgumentMatchers.eq((Object)EXPIRES));
    }
}

