/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.nifi.web.security.jwt.provider.StandardIssuerProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class StandardIssuerProviderTest {
    private static final String HTTPS_SCHEME = "https";
    private static final String LOCALHOST = "localhost.localdomain";
    private static final int PORT = 8443;
    private static final String EMPTY = "";

    StandardIssuerProviderTest() {
    }

    @Test
    void testGetIssuer() {
        StandardIssuerProvider provider = new StandardIssuerProvider(LOCALHOST, 8443);
        URI issuer = provider.getIssuer();
        Assertions.assertNotNull((Object)issuer);
        Assertions.assertEquals((Object)HTTPS_SCHEME, (Object)issuer.getScheme());
        Assertions.assertEquals((Object)LOCALHOST, (Object)issuer.getHost());
        Assertions.assertEquals((int)8443, (int)issuer.getPort());
        Assertions.assertEquals((Object)EMPTY, (Object)issuer.getPath());
        Assertions.assertNull((Object)issuer.getQuery());
    }

    @Test
    void testGetIssuerNullHostResolved() {
        String localHost = this.getLocalHost();
        Assumptions.assumeFalse((localHost == null ? 1 : 0) != 0);
        StandardIssuerProvider provider = new StandardIssuerProvider(null, 8443);
        URI issuer = provider.getIssuer();
        Assertions.assertNotNull((Object)issuer);
        Assertions.assertEquals((Object)HTTPS_SCHEME, (Object)issuer.getScheme());
        Assertions.assertEquals((Object)localHost, (Object)issuer.getHost());
        Assertions.assertEquals((int)8443, (int)issuer.getPort());
        Assertions.assertEquals((Object)EMPTY, (Object)issuer.getPath());
        Assertions.assertNull((Object)issuer.getQuery());
    }

    private String getLocalHost() {
        try {
            InetAddress localHostAddress = InetAddress.getLocalHost();
            return localHostAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

