/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.JwsSignerProvider;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;
import org.apache.nifi.web.security.jwt.provider.StandardBearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@ExtendWith(value={MockitoExtension.class})
public class StandardBearerTokenProviderTest {
    private static final String IDENTITY = "IDENTITY";
    private static final Instant EXPIRATION = Instant.now().plusSeconds(300L);
    private static final Duration MAXIMUM_DURATION_EXCEEDED = Duration.parse("PT12H5M");
    private static final Duration MINIMUM_DURATION_EXCEEDED = Duration.parse("PT30S");
    private static final URI ISSUER = URI.create("https://localhost:8443");
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.PS512;
    private static final String GROUP = "ProviderGroup";
    private static KeyPair keyPair;
    @Mock
    private JwsSignerProvider jwsSignerProvider;
    @Mock
    private IssuerProvider issuerProvider;
    private StandardBearerTokenProvider provider;
    private JWSVerifier jwsVerifier;

    @BeforeAll
    public static void setKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(4096);
        keyPair = keyPairGenerator.generateKeyPair();
    }

    @BeforeEach
    public void setProvider() {
        this.provider = new StandardBearerTokenProvider(this.jwsSignerProvider, this.issuerProvider);
        this.jwsVerifier = new RSASSAVerifier((RSAPublicKey)keyPair.getPublic());
        RSASSASigner jwsSigner = new RSASSASigner(keyPair.getPrivate());
        String keyIdentifier = UUID.randomUUID().toString();
        JwsSignerContainer jwsSignerContainer = new JwsSignerContainer(keyIdentifier, JWS_ALGORITHM, (JWSSigner)jwsSigner);
        Mockito.when((Object)this.jwsSignerProvider.getJwsSignerContainer((Instant)ArgumentMatchers.isA(Instant.class))).thenReturn((Object)jwsSignerContainer);
        Mockito.when((Object)this.issuerProvider.getIssuer()).thenReturn((Object)ISSUER);
    }

    @Test
    public void testGetBearerToken() throws ParseException, JOSEException {
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, EXPIRATION, Collections.emptySet());
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        this.assertTokenMatched(bearerToken, loginAuthenticationToken);
    }

    @Test
    public void testGetBearerTokenGroups() throws ParseException, JOSEException {
        SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority(GROUP);
        List<SimpleGrantedAuthority> authorities = Collections.singletonList(grantedAuthority);
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, EXPIRATION, authorities);
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        this.assertTokenMatched(bearerToken, loginAuthenticationToken);
    }

    @Test
    public void testGetBearerTokenExpirationMaximum() throws ParseException, JOSEException {
        Instant expiration = Instant.now().plus(MAXIMUM_DURATION_EXCEEDED);
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, expiration, Collections.emptySet());
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = Date.from(loginAuthenticationToken.getExpiration());
        Assertions.assertNotSame((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time matched");
        Assertions.assertTrue((boolean)claimExpirationTime.toInstant().isBefore(loginExpirationTime.toInstant()), (String)"Claim Expiration after Login Expiration");
    }

    @Test
    public void testGetBearerTokenExpirationMinimum() throws ParseException, JOSEException {
        Instant expiration = Instant.now().plus(MINIMUM_DURATION_EXCEEDED);
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, expiration, Collections.emptySet());
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = Date.from(loginAuthenticationToken.getExpiration());
        Assertions.assertNotSame((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time matched");
        Assertions.assertTrue((boolean)claimExpirationTime.toInstant().isAfter(loginExpirationTime.toInstant()), (String)"Claim Expiration before Login Expiration");
    }

    private SignedJWT assertTokenVerified(String bearerToken) throws ParseException, JOSEException {
        SignedJWT signedJwt = SignedJWT.parse((String)bearerToken);
        Assertions.assertTrue((boolean)signedJwt.verify(this.jwsVerifier), (String)"Verification Failed");
        return signedJwt;
    }

    private void assertTokenMatched(String bearerToken, LoginAuthenticationToken loginAuthenticationToken) throws ParseException, JOSEException {
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Assertions.assertNotNull((Object)claims.getIssueTime(), (String)"Issue Time not found");
        Assertions.assertNotNull((Object)claims.getNotBeforeTime(), (String)"Not Before Time not found");
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = Date.from(loginAuthenticationToken.getExpiration());
        Assertions.assertEquals((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time not matched");
        Assertions.assertEquals((Object)ISSUER.toString(), (Object)claims.getIssuer());
        Assertions.assertEquals(Collections.singletonList(ISSUER.toString()), (Object)claims.getAudience());
        Assertions.assertEquals((Object)IDENTITY, (Object)claims.getSubject());
        Assertions.assertEquals((Object)IDENTITY, (Object)claims.getClaim(SupportedClaim.PREFERRED_USERNAME.getClaim()));
        Assertions.assertNotNull((Object)claims.getJWTID(), (String)"JSON Web Token Identifier not found");
        List groups = claims.getStringListClaim(SupportedClaim.GROUPS.getClaim());
        Assertions.assertNotNull((Object)groups);
        Collection grantedAuthorities = loginAuthenticationToken.getAuthorities();
        List authorities = grantedAuthorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        Assertions.assertEquals(authorities, (Object)groups);
    }
}

