/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.anonymous;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationProvider;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationRequestToken;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;

public class NiFiAnonymousAuthenticationProviderTest {
    @Test
    public void testAnonymousDisabledNotSecure() {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)false);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(false, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assertions.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }

    @Test
    public void testAnonymousEnabledNotSecure() {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)true);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(false, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assertions.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }

    @Test
    public void testAnonymousDisabledSecure() {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)false);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(true, "");
        Assertions.assertThrows(InvalidAuthenticationException.class, () -> anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest));
    }

    @Test
    public void testAnonymousEnabledSecure() {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)true);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(true, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assertions.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }
}

