/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProxiedEntitiesUtils {
    @Test
    public void testBuildProxiedEntityGroupsString() {
        LinkedHashSet<String> groups = new LinkedHashSet<String>(Arrays.asList("group1", "group2", "group3"));
        String groupsString = ProxiedEntitiesUtils.buildProxiedEntityGroupsString(groups);
        Assertions.assertNotNull((Object)groupsString);
        Assertions.assertEquals((Object)"<group1><group2><group3>", (Object)groupsString);
    }

    @Test
    public void testBuildProxiedEntityGroupsStringWhenEmpty() {
        String groupsString = ProxiedEntitiesUtils.buildProxiedEntityGroupsString(Collections.emptySet());
        Assertions.assertNotNull((Object)groupsString);
        Assertions.assertEquals((Object)"<>", (Object)groupsString);
    }

    @Test
    public void testBuildProxiedEntityGroupsStringWithEscaping() {
        LinkedHashSet<String> groups = new LinkedHashSet<String>(Arrays.asList("gro<up1", "gro>up2", "group3"));
        String groupsString = ProxiedEntitiesUtils.buildProxiedEntityGroupsString(groups);
        Assertions.assertNotNull((Object)groupsString);
        Assertions.assertEquals((Object)"<gro\\<up1><gro\\>up2><group3>", (Object)groupsString);
    }

    @Test
    public void testTokenizeProxiedEntityGroups() {
        Set groups = ProxiedEntitiesUtils.tokenizeProxiedEntityGroups((String)"<group1><group2><group3>");
        Assertions.assertEquals((int)3, (int)groups.size());
        Assertions.assertTrue((boolean)groups.contains("group1"));
        Assertions.assertTrue((boolean)groups.contains("group2"));
        Assertions.assertTrue((boolean)groups.contains("group3"));
    }

    @Test
    public void testTokenizeProxiedEntityGroupsWhenEscaped() {
        Set groups = ProxiedEntitiesUtils.tokenizeProxiedEntityGroups((String)"<gr\\<oup1><gro\\>up2><group3>");
        Assertions.assertEquals((int)3, (int)groups.size());
        Assertions.assertTrue((boolean)groups.contains("gr<oup1"));
        Assertions.assertTrue((boolean)groups.contains("gro>up2"));
        Assertions.assertTrue((boolean)groups.contains("group3"));
    }

    @Test
    public void testTokenizeProxiedEntityGroupsWhenEmpty() {
        Set groups = ProxiedEntitiesUtils.tokenizeProxiedEntityGroups((String)"<>");
        Assertions.assertEquals((int)0, (int)groups.size());
    }

    @Test
    public void testTokenizeProxiedEntityGroupsWhenNull() {
        Set groups = ProxiedEntitiesUtils.tokenizeProxiedEntityGroups(null);
        Assertions.assertEquals((int)0, (int)groups.size());
    }
}

