/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.authentication;

import org.apache.nifi.web.security.oidc.authentication.StandardOidcIdTokenDecoderFactory;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestOperations;

@ExtendWith(value={MockitoExtension.class})
class StandardOidcIdTokenDecoderFactoryTest {
    private static final String REDIRECT_URI = "https://localhost:8443/nifi-api/callback";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String JWK_SET_URI = "http://localhost/token";
    private static final String CLIENT_ID = "client-id";
    private static final String CLIENT_SECRET = "client-secret";
    private static final String NULL_JWS_ALGORITHM = null;
    private static final SignatureAlgorithm DEFAULT_JWS_ALGORITHM = SignatureAlgorithm.RS256;
    @Mock
    RestOperations restOperations;
    StandardOidcIdTokenDecoderFactory factory;

    StandardOidcIdTokenDecoderFactoryTest() {
    }

    @Test
    void testNullJwsAlgorithmJwkSetUriRequired() {
        this.factory = new StandardOidcIdTokenDecoderFactory(NULL_JWS_ALGORITHM, this.restOperations);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().jwkSetUri("http://localhost/token").build();
        JwtDecoder decoder = this.factory.createDecoder(clientRegistration);
        Assertions.assertNotNull((Object)decoder);
    }

    @Test
    void testNullJwsAlgorithmJwkSetUriNotFound() {
        this.factory = new StandardOidcIdTokenDecoderFactory(NULL_JWS_ALGORITHM, this.restOperations);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().build();
        OAuth2AuthenticationException exception = (OAuth2AuthenticationException)Assertions.assertThrows(OAuth2AuthenticationException.class, () -> this.factory.createDecoder(clientRegistration));
        OAuth2Error error = exception.getError();
        String description = error.getDescription();
        Assertions.assertTrue((boolean)description.contains(DEFAULT_JWS_ALGORITHM.name()));
    }

    @Test
    void testMacJwsAlgorithmClientSecretRequired() {
        this.factory = new StandardOidcIdTokenDecoderFactory(MacAlgorithm.HS256.getName(), this.restOperations);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().clientSecret(CLIENT_SECRET).build();
        JwtDecoder decoder = this.factory.createDecoder(clientRegistration);
        Assertions.assertNotNull((Object)decoder);
    }

    @Test
    void testMacJwsAlgorithmClientSecretNotFound() {
        MacAlgorithm macAlgorithm = MacAlgorithm.HS256;
        this.factory = new StandardOidcIdTokenDecoderFactory(macAlgorithm.getName(), this.restOperations);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().build();
        OAuth2AuthenticationException exception = (OAuth2AuthenticationException)Assertions.assertThrows(OAuth2AuthenticationException.class, () -> this.factory.createDecoder(clientRegistration));
        OAuth2Error error = exception.getError();
        String description = error.getDescription();
        Assertions.assertTrue((boolean)description.contains(macAlgorithm.name()));
    }

    ClientRegistration.Builder getClientRegistrationBuilder() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri("http://localhost/token");
    }
}

