/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.requests;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.security.requests.ContentLengthFilter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContentLengthFilterTest {
    private static final String POST_REQUEST = "POST / HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\n\r\n%s";
    public static final int FORM_CONTENT_SIZE = 128;
    private static final int SMALL_CLAIM_SIZE_BYTES = 150;
    private static final String SMALL_PAYLOAD = StringUtils.repeat((String)"1", (int)150);
    private static final int LARGE_CLAIM_SIZE_BYTES = 2000;
    private static final String LARGE_PAYLOAD = StringUtils.repeat((String)"1", (int)2000);
    private Server serverUnderTest;
    private LocalConnector localConnector;

    ContentLengthFilterTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.createSimpleReadServer();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.stopServer();
    }

    @Test
    public void testRequestsWithMissingContentLengthHeader() throws Exception {
        String response = this.localConnector.getResponse("POST / HTTP/1.0\r\n\r\n");
        Assertions.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)response, (CharSequence)"411 Length Required"));
    }

    @Test
    public void testShouldRejectRequestWithLongContentLengthHeader() throws Exception {
        String requestBody = String.format(POST_REQUEST, 2000, LARGE_PAYLOAD);
        String response = this.localConnector.getResponse(requestBody);
        Assertions.assertTrue((boolean)response.contains("413 Payload Too Large"));
    }

    @Test
    public void testShouldRejectRequestWithLongContentLengthHeaderAndSmallPayload() throws Exception {
        String incompletePayload = StringUtils.repeat((String)"1", (int)75);
        String requestBody = String.format(POST_REQUEST, 2000, incompletePayload);
        String response = this.localConnector.getResponse(requestBody);
        Assertions.assertTrue((boolean)response.contains("413 Payload Too Large"));
    }

    @Test
    public void testShouldRejectRequestWithSmallContentLengthHeaderAndLargePayload() throws Exception {
        String requestBody = String.format(POST_REQUEST, 150, LARGE_PAYLOAD);
        String response = this.localConnector.getResponse(requestBody);
        Assertions.assertTrue((boolean)response.contains("200"));
        Assertions.assertTrue((boolean)response.contains("Bytes-Read: 150"));
        Assertions.assertTrue((boolean)response.contains("Read 150 bytes"));
    }

    @Test
    public void testShouldTimeoutRequestWithSmallContentLengthHeaderAndSmallerPayload() throws Exception {
        String smallerPayload = SMALL_PAYLOAD.substring(0, SMALL_PAYLOAD.length() / 2);
        String requestBody = String.format(POST_REQUEST, 150, smallerPayload);
        String response = this.localConnector.getResponse(requestBody, 500L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)response.contains("500 Server Error"));
        Assertions.assertTrue((boolean)response.contains("Timeout"));
    }

    @Test
    public void testFilterShouldAllowSiteToSiteTransfer() throws Exception {
        String siteToSitePostRequest = "POST /nifi-api/data-transfer/input-ports HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\n\r\n%s";
        String siteToSiteRequest = String.format("POST /nifi-api/data-transfer/input-ports HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\n\r\n%s", 2000, LARGE_PAYLOAD);
        String response = this.localConnector.getResponse(siteToSiteRequest);
        Assertions.assertTrue((boolean)response.contains("200 OK"));
    }

    @Test
    void testJettyMaxFormSize() throws Exception {
        this.configureAndStartServer(new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    req.getParameterMap();
                    ServletInputStream input = req.getInputStream();
                    int count = 0;
                    while (!input.isFinished()) {
                        input.read();
                        ++count;
                    }
                    int formLimitBytes = 128 + "a=\n".length();
                    if (count > formLimitBytes) {
                        resp.sendError(500, "Should not reach this code.");
                    } else {
                        resp.sendError(417, "Read Too Many Bytes");
                    }
                }
                catch (Exception e) {
                    if (StringUtils.containsIgnoreCase((CharSequence)e.getCause().toString(), (CharSequence)"Form is larger than max length 128")) {
                        resp.sendError(413, "Payload Too Large");
                    }
                    resp.sendError(403, "Should not reach this code, either.");
                }
            }
        }, 128);
        String form = "a=" + StringUtils.repeat((String)"1", (int)128);
        String formRequest = "POST / HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\nContent-Type: application/x-www-form-urlencoded\r\nAccept-Charset: UTF-8\r\n\r\n%s";
        String response = this.localConnector.getResponse(String.format("POST / HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\nContent-Type: application/x-www-form-urlencoded\r\nAccept-Charset: UTF-8\r\n\r\n%s", form.length(), form));
        Assertions.assertTrue((boolean)response.contains("413 Payload Too Large"));
        response = this.localConnector.getResponse(String.format(POST_REQUEST, form.length(), form + form));
        Assertions.assertTrue((boolean)response.contains("417 Read Too Many Bytes"));
    }

    private void createSimpleReadServer() throws Exception {
        HttpServlet mockServlet = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                byte[] byteBuffer = new byte[2048];
                int bytesRead = StreamUtils.fillBuffer((InputStream)req.getInputStream(), (byte[])byteBuffer, (boolean)false);
                resp.setHeader("Bytes-Read", Integer.toString(bytesRead));
                resp.setStatus(200);
                resp.getWriter().write("Read " + bytesRead + " bytes of request input");
            }
        };
        this.configureAndStartServer(mockServlet, -1);
    }

    private void configureAndStartServer(HttpServlet servlet, int maxFormContentSize) throws Exception {
        this.serverUnderTest = new Server();
        this.localConnector = new LocalConnector(this.serverUnderTest);
        this.localConnector.setIdleTimeout(2500L);
        this.serverUnderTest.addConnector((Connector)this.localConnector);
        ServletContextHandler contextUnderTest = new ServletContextHandler((HandlerContainer)this.serverUnderTest, "/");
        if (maxFormContentSize > 0) {
            contextUnderTest.setMaxFormContentSize(maxFormContentSize);
        }
        contextUnderTest.addServlet(new ServletHolder((Servlet)servlet), "/*");
        if (maxFormContentSize < 0) {
            FilterHolder holder = contextUnderTest.addFilter(ContentLengthFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            holder.setInitParameter("maxContentLength", String.valueOf(1000));
        }
        this.serverUnderTest.start();
    }

    void stopServer() throws Exception {
        if (this.serverUnderTest != null && this.serverUnderTest.isRunning()) {
            this.serverUnderTest.stop();
        }
    }
}

