/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.client.web.StandardOidcAuthorizedClientRepository;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClientConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

@ExtendWith(value={MockitoExtension.class})
class StandardOidcAuthorizedClientRepositoryTest {
    private static final String REGISTRATION_ID = OidcRegistrationProperty.REGISTRATION_ID.getProperty();
    private static final String IDENTITY = "user-identity";
    private static final String ENCODED_CLIENT = "encoded-client";
    private static final String CLIENT_ID = "client-id";
    private static final String REDIRECT_URI = "http://localhost:8080";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String TOKEN = "token";
    private static final int EXPIRES_OFFSET = 60;
    private static final Scope SCOPE = Scope.LOCAL;
    @Mock
    StateManager stateManager;
    @Mock
    StateMap stateMap;
    @Mock
    AuthorizedClientConverter authorizedClientConverter;
    @Mock
    OidcAuthorizedClient authorizedClient;
    @Captor
    ArgumentCaptor<Map<String, String>> stateMapCaptor;
    MockHttpServletRequest request;
    MockHttpServletResponse response;
    StandardOidcAuthorizedClientRepository repository;

    StandardOidcAuthorizedClientRepositoryTest() {
    }

    @BeforeEach
    void setRepository() {
        this.repository = new StandardOidcAuthorizedClientRepository(this.stateManager, this.authorizedClientConverter);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
    }

    @Test
    void testLoadAuthorizedClientNotFound() throws IOException {
        Authentication principal = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        OidcAuthorizedClient authorizedClient = (OidcAuthorizedClient)this.repository.loadAuthorizedClient(REGISTRATION_ID, principal, (HttpServletRequest)this.request);
        Assertions.assertNull((Object)authorizedClient);
    }

    @Test
    void testLoadAuthorizedClientFound() throws IOException {
        Authentication principal = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.stateMap.get((String)ArgumentMatchers.eq((Object)IDENTITY))).thenReturn((Object)ENCODED_CLIENT);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.authorizedClientConverter.getDecoded((String)ArgumentMatchers.eq((Object)ENCODED_CLIENT))).thenReturn((Object)this.authorizedClient);
        OidcAuthorizedClient authorizedClientFound = (OidcAuthorizedClient)this.repository.loadAuthorizedClient(REGISTRATION_ID, principal, (HttpServletRequest)this.request);
        Assertions.assertEquals((Object)this.authorizedClient, (Object)authorizedClientFound);
    }

    @Test
    void testSaveAuthorizedClient() throws IOException {
        OAuth2AuthenticationToken principal = (OAuth2AuthenticationToken)Mockito.mock(OAuth2AuthenticationToken.class);
        OidcUser oidcUser = (OidcUser)Mockito.mock(OidcUser.class);
        OidcIdToken idToken = (OidcIdToken)Mockito.mock(OidcIdToken.class);
        OAuth2AccessToken accessToken = (OAuth2AccessToken)Mockito.mock(OAuth2AccessToken.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)principal.getPrincipal()).thenReturn((Object)oidcUser);
        Mockito.when((Object)oidcUser.getIdToken()).thenReturn((Object)idToken);
        Mockito.when((Object)this.authorizedClient.getClientRegistration()).thenReturn((Object)this.getClientRegistration());
        Mockito.when((Object)this.authorizedClient.getPrincipalName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.authorizedClient.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.authorizedClientConverter.getEncoded((OidcAuthorizedClient)ArgumentMatchers.isA(OidcAuthorizedClient.class))).thenReturn((Object)ENCODED_CLIENT);
        this.repository.saveAuthorizedClient((OAuth2AuthorizedClient)this.authorizedClient, (Authentication)principal, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ((AuthorizedClientConverter)Mockito.verify((Object)this.authorizedClientConverter)).getEncoded((OidcAuthorizedClient)ArgumentMatchers.isA(OidcAuthorizedClient.class));
        ((StateManager)Mockito.verify((Object)this.stateManager)).replace((StateMap)ArgumentMatchers.eq((Object)this.stateMap), (Map)this.stateMapCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map updatedStateMap = (Map)this.stateMapCaptor.getValue();
        String encodedClient = (String)updatedStateMap.get(IDENTITY);
        Assertions.assertEquals((Object)ENCODED_CLIENT, (Object)encodedClient);
    }

    @Test
    void testRemoveAuthorizedClient() throws IOException {
        Authentication principal = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        this.repository.removeAuthorizedClient(REGISTRATION_ID, principal, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ((StateManager)Mockito.verify((Object)this.stateManager)).replace((StateMap)ArgumentMatchers.eq((Object)this.stateMap), (Map)this.stateMapCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map updatedStateMap = (Map)this.stateMapCaptor.getValue();
        Assertions.assertTrue((boolean)updatedStateMap.isEmpty());
    }

    @Test
    void testRemoveAuthorizedClientStateManagerException() throws IOException {
        Authentication principal = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertDoesNotThrow(() -> this.repository.removeAuthorizedClient(REGISTRATION_ID, principal, (HttpServletRequest)this.request, (HttpServletResponse)this.response));
    }

    @Test
    void testDeleteExpiredEmpty() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        List deletedAuthorizedClients = this.repository.deleteExpired();
        Assertions.assertTrue((boolean)deletedAuthorizedClients.isEmpty());
    }

    @Test
    void testDeleteExpired() throws IOException {
        LinkedHashMap<String, String> currentStateMap = new LinkedHashMap<String, String>();
        currentStateMap.put(IDENTITY, ENCODED_CLIENT);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(currentStateMap);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Instant issuedAt = Instant.MIN;
        Instant expiresAt = Instant.now().minusSeconds(60L);
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, TOKEN, issuedAt, expiresAt);
        Mockito.when((Object)this.authorizedClient.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)this.authorizedClientConverter.getDecoded((String)ArgumentMatchers.eq((Object)ENCODED_CLIENT))).thenReturn((Object)this.authorizedClient);
        List deletedAuthorizedClients = this.repository.deleteExpired();
        Assertions.assertFalse((boolean)deletedAuthorizedClients.isEmpty());
        OidcAuthorizedClient deletedAuthorizedClient = (OidcAuthorizedClient)deletedAuthorizedClients.iterator().next();
        Assertions.assertEquals((Object)this.authorizedClient, (Object)deletedAuthorizedClient);
    }

    ClientRegistration getClientRegistration() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI).build();
    }
}

