/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.net.URI;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.client.web.StandardOAuth2AuthorizationRequestResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

@ExtendWith(value={MockitoExtension.class})
class StandardOAuth2AuthorizationRequestResolverTest {
    private static final String REDIRECT_URI = "https://localhost:8443/nifi-api/callback";
    private static final String FORWARDED_PATH = "/forwarded";
    private static final String FORWARDED_REDIRECT_URI = String.format("https://localhost.localdomain%s/nifi-api/callback", "/forwarded");
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String CLIENT_ID = "client-id";
    private static final String REGISTRATION_ID = OidcRegistrationProperty.REGISTRATION_ID.getProperty();
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    @Mock
    ClientRegistrationRepository clientRegistrationRepository;
    StandardOAuth2AuthorizationRequestResolver resolver;

    StandardOAuth2AuthorizationRequestResolverTest() {
    }

    @BeforeEach
    void setResolver() {
        this.resolver = new StandardOAuth2AuthorizationRequestResolver(this.clientRegistrationRepository);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testResolveNotFound() {
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)authorizationRequest);
    }

    @Test
    void testResolveClientRegistrationIdNotFound() {
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve((HttpServletRequest)this.httpServletRequest, null);
        Assertions.assertNull((Object)authorizationRequest);
    }

    @Test
    void testResolveFound() {
        URI redirectUri = URI.create(REDIRECT_URI);
        this.httpServletRequest.setScheme(redirectUri.getScheme());
        this.httpServletRequest.setServerPort(redirectUri.getPort());
        ClientRegistration clientRegistration = this.getClientRegistration();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)REGISTRATION_ID))).thenReturn((Object)clientRegistration);
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve((HttpServletRequest)this.httpServletRequest, REGISTRATION_ID);
        Assertions.assertNotNull((Object)authorizationRequest);
        Assertions.assertEquals((Object)REDIRECT_URI, (Object)authorizationRequest.getRedirectUri());
        this.assertPkceParametersFound(authorizationRequest);
    }

    @Test
    void testResolveFoundRedirectUriProxyHeaders() {
        ClientRegistration clientRegistration = this.getClientRegistration();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)REGISTRATION_ID))).thenReturn((Object)clientRegistration);
        ServletContext servletContext = this.httpServletRequest.getServletContext();
        servletContext.setInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER, FORWARDED_PATH);
        URI forwardedRedirectUri = URI.create(FORWARDED_REDIRECT_URI);
        this.httpServletRequest.addHeader("X-ProxyScheme", (Object)forwardedRedirectUri.getScheme());
        this.httpServletRequest.addHeader("X-ProxyHost", (Object)forwardedRedirectUri.getHost());
        this.httpServletRequest.addHeader("X-ProxyPort", (Object)forwardedRedirectUri.getPort());
        this.httpServletRequest.addHeader("X-ProxyContextPath", (Object)FORWARDED_PATH);
        OAuth2AuthorizationRequest authorizationRequest = this.resolver.resolve((HttpServletRequest)this.httpServletRequest, REGISTRATION_ID);
        Assertions.assertNotNull((Object)authorizationRequest);
        Assertions.assertEquals((Object)FORWARDED_REDIRECT_URI, (Object)authorizationRequest.getRedirectUri());
        this.assertPkceParametersFound(authorizationRequest);
    }

    private void assertPkceParametersFound(OAuth2AuthorizationRequest authorizationRequest) {
        Assertions.assertNotNull((Object)authorizationRequest.getAttribute("code_verifier"));
        Map additionalParameters = authorizationRequest.getAdditionalParameters();
        Assertions.assertTrue((boolean)additionalParameters.containsKey("code_challenge"));
        Assertions.assertTrue((boolean)additionalParameters.containsKey("code_challenge_method"));
    }

    ClientRegistration getClientRegistration() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI).build();
    }
}

