/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.web.security.jwt.key.service.StandardVerificationKeyService;
import org.apache.nifi.web.security.jwt.key.service.VerificationKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardVerificationKeyServiceTest {
    private static final String ID = UUID.randomUUID().toString();
    private static final String ALGORITHM = "RSA";
    private static final byte[] ENCODED = "RSA".getBytes(StandardCharsets.UTF_8);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private static final Scope SCOPE = Scope.LOCAL;
    private static final Instant EXPIRED = Instant.now().minusSeconds(60L);
    @Mock
    private StateManager stateManager;
    @Mock
    private StateMap stateMap;
    @Mock
    private Key key;
    @Captor
    private ArgumentCaptor<Map<String, String>> stateCaptor;
    private StandardVerificationKeyService service;

    @BeforeEach
    public void setService() {
        this.service = new StandardVerificationKeyService(this.stateManager);
    }

    @Test
    public void testDeleteExpired() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        String serialized = this.getSerializedVerificationKey(EXPIRED);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.singletonMap(ID, serialized));
        this.service.deleteExpired();
        ((StateManager)Mockito.verify((Object)this.stateManager)).setState((Map)this.stateCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map stateSaved = (Map)this.stateCaptor.getValue();
        Assertions.assertTrue((boolean)stateSaved.isEmpty(), (String)"Expired Key not deleted");
    }

    @Test
    public void testSave() throws IOException {
        Mockito.when((Object)this.key.getAlgorithm()).thenReturn((Object)ALGORITHM);
        Mockito.when((Object)this.key.getEncoded()).thenReturn((Object)ENCODED);
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.emptyMap());
        Instant expiration = Instant.now();
        this.service.save(ID, this.key, expiration);
        ((StateManager)Mockito.verify((Object)this.stateManager)).setState((Map)this.stateCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map stateSaved = (Map)this.stateCaptor.getValue();
        String serialized = (String)stateSaved.get(ID);
        Assertions.assertNotNull((Object)serialized, (String)"Serialized Key not found");
    }

    @Test
    public void testSetExpiration() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.emptyMap());
        Instant expiration = Instant.now();
        String serialized = this.getSerializedVerificationKey(expiration);
        Mockito.when((Object)this.stateMap.get((String)ArgumentMatchers.eq((Object)ID))).thenReturn((Object)serialized);
        this.service.setExpiration(ID, expiration);
        ((StateManager)Mockito.verify((Object)this.stateManager)).setState((Map)this.stateCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map stateSaved = (Map)this.stateCaptor.getValue();
        String saved = (String)stateSaved.get(ID);
        Assertions.assertNotNull((Object)saved, (String)"Serialized Key not found");
    }

    private String getSerializedVerificationKey(Instant expiration) throws JsonProcessingException {
        VerificationKey verificationKey = new VerificationKey();
        verificationKey.setId(ID);
        verificationKey.setExpiration(expiration);
        return OBJECT_MAPPER.writeValueAsString((Object)verificationKey);
    }
}

