/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key.command;

import com.nimbusds.jose.JWSAlgorithm;
import java.security.Key;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.SignerListener;
import org.apache.nifi.web.security.jwt.key.VerificationKeyListener;
import org.apache.nifi.web.security.jwt.key.command.KeyGenerationCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class KeyGenerationCommandTest {
    private static final String KEY_ALGORITHM = "RSA";
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.PS512;
    @Mock
    private SignerListener signerListener;
    @Mock
    private VerificationKeyListener verificationKeyListener;
    @Captor
    private ArgumentCaptor<JwsSignerContainer> signerCaptor;
    @Captor
    private ArgumentCaptor<String> keyIdentifierCaptor;
    @Captor
    private ArgumentCaptor<Key> keyCaptor;
    private KeyGenerationCommand command;

    @BeforeEach
    public void setCommand() {
        this.command = new KeyGenerationCommand(this.signerListener, this.verificationKeyListener);
    }

    @Test
    public void testRun() {
        this.command.run();
        ((SignerListener)Mockito.verify((Object)this.signerListener)).onSignerUpdated((JwsSignerContainer)this.signerCaptor.capture());
        JwsSignerContainer signerContainer = (JwsSignerContainer)this.signerCaptor.getValue();
        Assertions.assertEquals((Object)JWS_ALGORITHM, (Object)signerContainer.getJwsAlgorithm());
        ((VerificationKeyListener)Mockito.verify((Object)this.verificationKeyListener)).onVerificationKeyGenerated((String)this.keyIdentifierCaptor.capture(), (Key)this.keyCaptor.capture());
        Key key = (Key)this.keyCaptor.getValue();
        Assertions.assertEquals((Object)KEY_ALGORITHM, (Object)key.getAlgorithm());
    }
}

