/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.registration;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.registration.StandardClientRegistrationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.web.client.RestOperations;

@ExtendWith(value={MockitoExtension.class})
class StandardClientRegistrationProviderTest {
    private static final String DISCOVERY_URL = "http://localhost/.well-known/openid-configuration";
    private static final String ISSUER = "http://localhost";
    private static final URI JWK_SET_URI = URI.create("http://localhost/jwks");
    private static final URI TOKEN_ENDPOINT_URI = URI.create("http://localhost/oauth2/v1/token");
    private static final URI USER_INFO_URI = URI.create("http://localhost/oauth2/v1/userinfo");
    private static final URI AUTHORIZATION_ENDPOINT_URI = URI.create("http://localhost/oauth2/v1/authorize");
    private static final String CLIENT_ID = "client-id";
    private static final String CLIENT_SECRET = "client-secret";
    private static final String USER_NAME_ATTRIBUTE_NAME = "sub";
    private static final Set<String> EXPECTED_SCOPES = new LinkedHashSet<String>(Arrays.asList("openid", "email", "profile"));
    private static final String INVALID_CONFIGURATION = "{}";
    @Mock
    RestOperations restOperations;

    StandardClientRegistrationProviderTest() {
    }

    @Test
    void testGetClientRegistration() {
        NiFiProperties properties = this.getProperties();
        StandardClientRegistrationProvider provider = new StandardClientRegistrationProvider(properties, this.restOperations);
        OIDCProviderMetadata providerMetadata = this.getProviderMetadata();
        String serializedMetadata = providerMetadata.toString();
        Mockito.when((Object)((String)this.restOperations.getForObject((String)ArgumentMatchers.eq((Object)DISCOVERY_URL), (Class)ArgumentMatchers.eq(String.class), new Object[0]))).thenReturn((Object)serializedMetadata);
        ClientRegistration clientRegistration = provider.getClientRegistration();
        Assertions.assertNotNull((Object)clientRegistration);
        Assertions.assertEquals((Object)CLIENT_ID, (Object)clientRegistration.getClientId());
        Assertions.assertEquals((Object)CLIENT_SECRET, (Object)clientRegistration.getClientSecret());
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        Assertions.assertEquals((Object)ISSUER, (Object)providerDetails.getIssuerUri());
        Assertions.assertEquals((Object)JWK_SET_URI.toString(), (Object)providerDetails.getJwkSetUri());
        Assertions.assertEquals((Object)AUTHORIZATION_ENDPOINT_URI.toString(), (Object)providerDetails.getAuthorizationUri());
        Assertions.assertEquals((Object)TOKEN_ENDPOINT_URI.toString(), (Object)providerDetails.getTokenUri());
        ClientRegistration.ProviderDetails.UserInfoEndpoint userInfoEndpoint = providerDetails.getUserInfoEndpoint();
        Assertions.assertEquals((Object)USER_INFO_URI.toString(), (Object)userInfoEndpoint.getUri());
        Assertions.assertEquals((Object)USER_NAME_ATTRIBUTE_NAME, (Object)userInfoEndpoint.getUserNameAttributeName());
        Assertions.assertEquals((Object)AuthenticationMethod.HEADER, (Object)userInfoEndpoint.getAuthenticationMethod());
        Set scopes = clientRegistration.getScopes();
        Assertions.assertEquals(EXPECTED_SCOPES, (Object)scopes);
    }

    @Test
    void testGetClientRegistrationRetrievalFailed() {
        NiFiProperties properties = this.getProperties();
        StandardClientRegistrationProvider provider = new StandardClientRegistrationProvider(properties, this.restOperations);
        Mockito.when((Object)((String)this.restOperations.getForObject((String)ArgumentMatchers.eq((Object)DISCOVERY_URL), (Class)ArgumentMatchers.eq(String.class), new Object[0]))).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(OidcConfigurationException.class, () -> ((StandardClientRegistrationProvider)provider).getClientRegistration());
    }

    @Test
    void testGetClientRegistrationParsingFailed() {
        NiFiProperties properties = this.getProperties();
        StandardClientRegistrationProvider provider = new StandardClientRegistrationProvider(properties, this.restOperations);
        Mockito.when((Object)((String)this.restOperations.getForObject((String)ArgumentMatchers.eq((Object)DISCOVERY_URL), (Class)ArgumentMatchers.eq(String.class), new Object[0]))).thenReturn((Object)INVALID_CONFIGURATION);
        Assertions.assertThrows(OidcConfigurationException.class, () -> ((StandardClientRegistrationProvider)provider).getClientRegistration());
    }

    private NiFiProperties getProperties() {
        Properties properties = new Properties();
        properties.put("nifi.security.user.oidc.discovery.url", DISCOVERY_URL);
        properties.put("nifi.security.user.oidc.client.id", CLIENT_ID);
        properties.put("nifi.security.user.oidc.client.secret", CLIENT_SECRET);
        properties.put("nifi.security.user.oidc.claim.identifying.user", USER_NAME_ATTRIBUTE_NAME);
        properties.put("nifi.security.user.oidc.additional.scopes", "profile");
        return NiFiProperties.createBasicNiFiProperties(null, (Properties)properties);
    }

    private OIDCProviderMetadata getProviderMetadata() {
        Issuer issuer = new Issuer(ISSUER);
        List<SubjectType> subjectTypes = Collections.singletonList(SubjectType.PUBLIC);
        OIDCProviderMetadata providerMetadata = new OIDCProviderMetadata(issuer, subjectTypes, JWK_SET_URI);
        providerMetadata.setTokenEndpointURI(TOKEN_ENDPOINT_URI);
        providerMetadata.setUserInfoEndpointURI(USER_INFO_URI);
        providerMetadata.setAuthorizationEndpointURI(AUTHORIZATION_ENDPOINT_URI);
        Scope scopes = new Scope();
        scopes.add("openid");
        scopes.add("email");
        scopes.add("profile");
        scopes.add("address");
        providerMetadata.setScopes(scopes);
        return providerMetadata;
    }
}

