/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.logout;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.logout.OidcLogoutSuccessHandler;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationRequest;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponse;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenTypeHint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;

@ExtendWith(value={MockitoExtension.class})
class OidcLogoutSuccessHandlerTest {
    private static final String REQUEST_IDENTIFIER = UUID.randomUUID().toString();
    private static final String CLIENT_ID = "client-id";
    private static final String REDIRECT_URI = "http://localhost:8080";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String END_SESSION_URI = "http://localhost/end_session";
    private static final String USER_IDENTITY = LogoutRequest.class.getSimpleName();
    private static final String REQUEST_URI = "/nifi-api";
    private static final int SERVER_PORT = 8080;
    private static final String REDIRECTED_URL = "http://localhost:8080/nifi/logout-complete";
    private static final String ACCESS_TOKEN = "access-token";
    private static final String REFRESH_TOKEN = "refresh-token";
    private static final String ID_TOKEN = "oidc-id-token";
    private static final String END_SESSION_REDIRECT_URL = String.format("%s?id_token_hint=%s&post_logout_redirect_uri=%s", "http://localhost/end_session", "oidc-id-token", "http://localhost:8080/nifi/logout-complete");
    @Mock
    ClientRegistrationRepository clientRegistrationRepository;
    @Mock
    OAuth2AuthorizedClientRepository authorizedClientRepository;
    @Mock
    Authentication authentication;
    @Mock
    OAuth2AccessToken accessToken;
    @Mock
    OAuth2RefreshToken refreshToken;
    @Mock
    OidcIdToken idToken;
    @Mock
    TokenRevocationResponseClient tokenRevocationResponseClient;
    @Captor
    ArgumentCaptor<TokenRevocationRequest> revocationRequestCaptor;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    LogoutRequestManager logoutRequestManager;
    OidcLogoutSuccessHandler handler;

    OidcLogoutSuccessHandlerTest() {
    }

    @BeforeEach
    void setHandler() {
        this.logoutRequestManager = new LogoutRequestManager();
        this.handler = new OidcLogoutSuccessHandler(this.logoutRequestManager, this.clientRegistrationRepository, this.authorizedClientRepository, this.tokenRevocationResponseClient);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletRequest.setServerPort(8080);
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testOnLogoutSuccessRequestNotFound() throws IOException {
        this.setRequestCookie();
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)REDIRECTED_URL, (Object)redirectedUrl);
    }

    @Test
    void testOnLogoutSuccessRequestFoundEndSessionNotSupported() throws IOException {
        this.setRequestCookie();
        this.startLogoutRequest();
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().build();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)REDIRECTED_URL, (Object)redirectedUrl);
    }

    @Test
    void testOnLogoutSuccessRequestFoundEndSessionSupportedTokenNotFound() throws IOException {
        this.setRequestCookie();
        this.startLogoutRequest();
        Map<String, String> configurationMetadata = Collections.singletonMap("end_session_endpoint", END_SESSION_URI);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().providerConfigurationMetadata(configurationMetadata).build();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)REDIRECTED_URL, (Object)redirectedUrl);
    }

    @Test
    void testOnLogoutSuccessRequestFoundEndSessionSupportedTokenFound() throws IOException {
        this.setRequestCookie();
        this.startLogoutRequest();
        Map<String, String> configurationMetadata = Collections.singletonMap("end_session_endpoint", END_SESSION_URI);
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().providerConfigurationMetadata(configurationMetadata).build();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        Mockito.when((Object)this.idToken.getTokenValue()).thenReturn((Object)ID_TOKEN);
        OidcAuthorizedClient oidcAuthorizedClient = new OidcAuthorizedClient(clientRegistration, USER_IDENTITY, this.accessToken, this.refreshToken, this.idToken);
        Mockito.when((Object)this.authorizedClientRepository.loadAuthorizedClient((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()), (Authentication)ArgumentMatchers.isA(Authentication.class), (HttpServletRequest)ArgumentMatchers.eq((Object)this.httpServletRequest))).thenReturn((Object)oidcAuthorizedClient);
        TokenRevocationResponse revocationResponse = new TokenRevocationResponse(true, HttpStatus.OK.value());
        Mockito.when((Object)this.tokenRevocationResponseClient.getRevocationResponse((TokenRevocationRequest)ArgumentMatchers.any())).thenReturn((Object)revocationResponse);
        Mockito.when((Object)this.accessToken.getTokenValue()).thenReturn((Object)ACCESS_TOKEN);
        Mockito.when((Object)this.refreshToken.getTokenValue()).thenReturn((Object)REFRESH_TOKEN);
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)END_SESSION_REDIRECT_URL, (Object)redirectedUrl);
        ((OAuth2AuthorizedClientRepository)Mockito.verify((Object)this.authorizedClientRepository)).removeAuthorizedClient((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()), (Authentication)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.eq((Object)this.httpServletRequest), (HttpServletResponse)ArgumentMatchers.eq((Object)this.httpServletResponse));
        ((TokenRevocationResponseClient)Mockito.verify((Object)this.tokenRevocationResponseClient, (VerificationMode)Mockito.times((int)2))).getRevocationResponse((TokenRevocationRequest)this.revocationRequestCaptor.capture());
        Iterator revocationRequests = this.revocationRequestCaptor.getAllValues().iterator();
        TokenRevocationRequest firstRevocationRequest = (TokenRevocationRequest)revocationRequests.next();
        Assertions.assertEquals((Object)TokenTypeHint.REFRESH_TOKEN.getHint(), (Object)firstRevocationRequest.getTokenTypeHint());
        Assertions.assertEquals((Object)REFRESH_TOKEN, (Object)firstRevocationRequest.getToken());
        TokenRevocationRequest secondRevocationRequest = (TokenRevocationRequest)revocationRequests.next();
        Assertions.assertEquals((Object)TokenTypeHint.ACCESS_TOKEN.getHint(), (Object)secondRevocationRequest.getTokenTypeHint());
        Assertions.assertEquals((Object)ACCESS_TOKEN, (Object)secondRevocationRequest.getToken());
    }

    void setRequestCookie() {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        this.httpServletRequest.setRequestURI(REQUEST_URI);
    }

    void startLogoutRequest() {
        LogoutRequest logoutRequest = new LogoutRequest(REQUEST_IDENTIFIER, USER_IDENTITY);
        this.logoutRequestManager.start(logoutRequest);
    }

    ClientRegistration.Builder getClientRegistrationBuilder() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI);
    }
}

