/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.TemporaryKeyStoreBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.saml2.SamlConfigurationException;
import org.apache.nifi.web.security.saml2.registration.StandardRegistrationBuilderProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

class StandardRegistrationBuilderProviderTest {
    private static final String LOCALHOST = "localhost";
    private static final String METADATA_PATH = "/saml/sso-circle-meta.xml";
    private static final int HTTP_NOT_FOUND = 404;
    private static final boolean PROXY_DISABLED = false;
    private MockWebServer mockWebServer;

    StandardRegistrationBuilderProviderTest() {
    }

    @BeforeEach
    void startServer() throws IOException {
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start();
    }

    @AfterEach
    void shutdownServer() throws IOException {
        this.mockWebServer.shutdown();
    }

    @Test
    void testGetRegistrationBuilderFileUrl() {
        NiFiProperties properties = this.getProperties(this.getFileMetadataUrl());
        this.assertRegistrationFound(properties);
    }

    @Test
    void testGetRegistrationBuilderHttpUrl() throws IOException {
        String metadata = this.getMetadata();
        MockResponse response = new MockResponse().setBody(metadata);
        this.mockWebServer.enqueue(response);
        String metadataUrl = this.getMetadataUrl();
        NiFiProperties properties = this.getProperties(metadataUrl);
        this.assertRegistrationFound(properties);
    }

    @Test
    void testGetRegistrationBuilderHttpUrlNotFound() {
        MockResponse response = new MockResponse().setResponseCode(404);
        this.mockWebServer.enqueue(response);
        String metadataUrl = this.getMetadataUrl();
        NiFiProperties properties = this.getProperties(metadataUrl);
        StandardRegistrationBuilderProvider provider = new StandardRegistrationBuilderProvider(properties);
        SamlConfigurationException exception = (SamlConfigurationException)Assertions.assertThrows(SamlConfigurationException.class, () -> ((StandardRegistrationBuilderProvider)provider).getRegistrationBuilder());
        Assertions.assertTrue((boolean)exception.getMessage().contains(Integer.toString(404)));
    }

    @Test
    void testGetRegistrationBuilderHttpsUrl() throws IOException, TlsException {
        TlsConfiguration tlsConfiguration = new TemporaryKeyStoreBuilder().build();
        SSLSocketFactory sslSocketFactory = Objects.requireNonNull(SslContextFactory.createSSLSocketFactory((TlsConfiguration)tlsConfiguration));
        this.mockWebServer.useHttps(sslSocketFactory, false);
        String metadata = this.getMetadata();
        MockResponse response = new MockResponse().setBody(metadata);
        this.mockWebServer.enqueue(response);
        String metadataUrl = this.getMetadataUrl();
        NiFiProperties properties = this.getProperties(metadataUrl, tlsConfiguration);
        this.assertRegistrationFound(properties);
    }

    private String getMetadataUrl() {
        HttpUrl url = this.mockWebServer.url(METADATA_PATH).newBuilder().host(LOCALHOST).build();
        return url.toString();
    }

    private void assertRegistrationFound(NiFiProperties properties) {
        StandardRegistrationBuilderProvider provider = new StandardRegistrationBuilderProvider(properties);
        RelyingPartyRegistration.Builder builder = provider.getRegistrationBuilder();
        RelyingPartyRegistration registration = builder.build();
        Assertions.assertEquals((Object)Saml2MessageBinding.POST, (Object)registration.getAssertionConsumerServiceBinding());
    }

    private NiFiProperties getProperties(String metadataUrl) {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.user.saml.idp.metadata.url", metadataUrl);
        return NiFiProperties.createBasicNiFiProperties(null, (Properties)properties);
    }

    private NiFiProperties getProperties(String metadataUrl, TlsConfiguration tlsConfiguration) {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.user.saml.idp.metadata.url", metadataUrl);
        properties.setProperty("nifi.security.user.saml.http.client.truststore.strategy", "NIFI");
        properties.setProperty("nifi.security.keystore", tlsConfiguration.getKeystorePath());
        properties.setProperty("nifi.security.keystoreType", tlsConfiguration.getKeystoreType().getType());
        properties.setProperty("nifi.security.keystorePasswd", tlsConfiguration.getKeystorePassword());
        properties.setProperty("nifi.security.keyPasswd", tlsConfiguration.getKeyPassword());
        properties.setProperty("nifi.security.truststore", tlsConfiguration.getTruststorePath());
        properties.setProperty("nifi.security.truststoreType", tlsConfiguration.getTruststoreType().getType());
        properties.setProperty("nifi.security.truststorePasswd", tlsConfiguration.getTruststorePassword());
        return NiFiProperties.createBasicNiFiProperties(null, (Properties)properties);
    }

    final String getMetadata() throws IOException {
        try (InputStream inputStream = Objects.requireNonNull(this.getClass().getResourceAsStream(METADATA_PATH));){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private String getFileMetadataUrl() {
        URL resource = Objects.requireNonNull(this.getClass().getResource(METADATA_PATH));
        return resource.toString();
    }
}

