/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxAuthenticationFilter;
import org.apache.nifi.web.security.knox.KnoxAuthenticationRequestToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class KnoxAuthenticationFilterTest {
    private static final String COOKIE_NAME = "hadoop-jwt";
    private KnoxAuthenticationFilter knoxAuthenticationFilter;

    @Before
    public void setUp() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isKnoxSsoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)nifiProperties.getKnoxCookieName()).thenReturn((Object)COOKIE_NAME);
        this.knoxAuthenticationFilter = new KnoxAuthenticationFilter();
        this.knoxAuthenticationFilter.setProperties(nifiProperties);
    }

    @Test
    public void testInsecureHttp() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
        Assert.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testNullCookies() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn(null);
        Assert.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testNoCookies() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
        Assert.assertNull((Object)this.knoxAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testWrongCookieName() throws Exception {
        String jwt = "my-jwt";
        Cookie knoxCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)knoxCookie.getName()).thenReturn((Object)"not-hadoop-jwt");
        Mockito.when((Object)knoxCookie.getValue()).thenReturn((Object)"my-jwt");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{knoxCookie});
        KnoxAuthenticationRequestToken authRequest = (KnoxAuthenticationRequestToken)this.knoxAuthenticationFilter.attemptAuthentication(request);
        Assert.assertNull((Object)authRequest);
    }

    @Test
    public void testKnoxCookie() throws Exception {
        String jwt = "my-jwt";
        Cookie knoxCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)knoxCookie.getName()).thenReturn((Object)COOKIE_NAME);
        Mockito.when((Object)knoxCookie.getValue()).thenReturn((Object)"my-jwt");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{knoxCookie});
        KnoxAuthenticationRequestToken authRequest = (KnoxAuthenticationRequestToken)this.knoxAuthenticationFilter.attemptAuthentication(request);
        Assert.assertNotNull((Object)authRequest);
        Assert.assertEquals((Object)"my-jwt", (Object)authRequest.getToken());
    }
}

