/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.GroovyTestCase;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.OidcService;
import org.apache.nifi.web.security.oidc.StandardOidcIdentityProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class OidcServiceGroovyTest
extends GroovyTestCase
implements GroovyObject {
    private static final Logger logger;
    private static final Map<String, Object> DEFAULT_NIFI_PROPERTIES;
    private static NiFiProperties mockNiFiProperties;
    private static StandardOidcIdentityProvider soip;
    private static final String MOCK_REQUEST_IDENTIFIER = "mock-request-identifier";
    private static final String MOCK_JWT = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRob3JpdHkiLCJhdWQiOiJhbGwiLCJ1c2VybmFtZSI6Im9pZGNfdGVzdCIsImVtYWlsIjoib2lkY190ZXN0QG5pZmkuYXBhY2hlLm9yZyJ9.b4NIl0RONKdVLOH0D1eObdwAEX8qX-ExqB8KuKSZFLw";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public OidcServiceGroovyTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_setUpOnce_closure1.class, OidcServiceGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{callSiteArray[1].callSafe((Object)name), callSiteArray[2].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            @Generated
            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "toUpperCase";
                stringArray[2] = "join";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(OidcServiceGroovyTest.class, OidcServiceGroovyTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[0].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @Before
    public void setUp() throws Exception {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(OidcServiceGroovyTest.class);
            mockNiFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)object, NiFiProperties.class);
        } else {
            NiFiProperties niFiProperties;
            mockNiFiProperties = niFiProperties = OidcServiceGroovyTest.buildNiFiProperties();
        }
        Object object = callSiteArray[2].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties);
        soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
    }

    @After
    public void teardown() throws Exception {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
    }

    private static NiFiProperties buildNiFiProperties(Map<String, Object> props) {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        Object combinedProps = callSiteArray[3].call(DEFAULT_NIFI_PROPERTIES, props);
        return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(NiFiProperties.class, combinedProps), NiFiProperties.class);
    }

    @Test
    public void testShouldStoreJwt() {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callStatic(OidcServiceGroovyTest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), StandardOidcIdentityProvider.class);
        OidcService service = (OidcService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(OidcService.class, (Object)soip), OidcService.class);
        callSiteArray[7].call((Object)logger, (Object)new GStringImpl(new Object[]{MOCK_JWT}, new String[]{"EXPECTED_JWT: ", ""}));
        callSiteArray[8].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER, (Object)MOCK_JWT);
        String cachedJwt = ShortTypeHandling.castToString((Object)callSiteArray[9].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER));
        callSiteArray[10].call((Object)logger, (Object)new GStringImpl(new Object[]{cachedJwt}, new String[]{"Cached JWT: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = cachedJwt;
            valueRecorder.record((Object)string, 8);
            String string2 = MOCK_JWT;
            valueRecorder.record((Object)string2, 21);
            valueRecorder.record((Object)string2, 21);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 18);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert cachedJwt == MOCK_JWT", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldGetJwt() {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callStatic(OidcServiceGroovyTest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), StandardOidcIdentityProvider.class);
        OidcService service = (OidcService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callConstructor(OidcService.class, (Object)soip), OidcService.class);
        callSiteArray[13].call((Object)logger, (Object)new GStringImpl(new Object[]{MOCK_JWT}, new String[]{"EXPECTED_JWT: ", ""}));
        callSiteArray[14].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER, (Object)MOCK_JWT);
        String retrievedJwt = ShortTypeHandling.castToString((Object)callSiteArray[15].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER));
        callSiteArray[16].call((Object)logger, (Object)new GStringImpl(new Object[]{retrievedJwt}, new String[]{"Retrieved JWT: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = retrievedJwt;
            valueRecorder.record((Object)string, 8);
            String string2 = MOCK_JWT;
            valueRecorder.record((Object)string2, 24);
            valueRecorder.record((Object)string2, 24);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 21);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert retrievedJwt == MOCK_JWT", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testGetJwtShouldReturnNullWithExpiredDuration() {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callStatic(OidcServiceGroovyTest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), StandardOidcIdentityProvider.class);
        int DURATION = 500;
        TimeUnit EXPIRATION_UNITS = (TimeUnit)ShortTypeHandling.castToEnum((Object)callSiteArray[18].callGetProperty(TimeUnit.class), TimeUnit.class);
        OidcService service = (OidcService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(OidcService.class, (Object)soip, (Object)DURATION, (Object)EXPIRATION_UNITS), OidcService.class);
        callSiteArray[20].call((Object)logger, (Object)new GStringImpl(new Object[]{MOCK_JWT}, new String[]{"EXPECTED_JWT: ", ""}));
        callSiteArray[21].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER, (Object)MOCK_JWT);
        long millis = 1000;
        callSiteArray[22].call(Thread.class, (Object)millis);
        callSiteArray[23].call((Object)logger, (Object)new GStringImpl(new Object[]{millis}, new String[]{"Thread will sleep for: ", " ms"}));
        String retrievedJwt = ShortTypeHandling.castToString((Object)callSiteArray[24].call((Object)service, (Object)MOCK_REQUEST_IDENTIFIER));
        callSiteArray[25].call((Object)logger, (Object)new GStringImpl(new Object[]{retrievedJwt}, new String[]{"Retrieved JWT: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = retrievedJwt;
            valueRecorder.record((Object)string, 8);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, null);
            valueRecorder.record((Object)bl, 21);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert retrievedJwt == null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    private static StandardOidcIdentityProvider buildIdentityProviderWithMockInitializedProvider(Map<String, String> additionalProperties) {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        NiFiProperties mockNFP = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callStatic(OidcServiceGroovyTest.class, additionalProperties), NiFiProperties.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callConstructor(Issuer.class, (Object)"mockIssuer"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        Reference metadata = new Reference((Object)((OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[30].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class)));
        GroovyObject soip = new GroovyObject(metadata, mockNFP){
            public /* synthetic */ Reference metadata;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.metadata = reference = p0;
                super((NiFiProperties)ScriptBytecodeAdapter.castToType((Object)p10, NiFiProperties.class));
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void initializeProvider() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = this.metadata.get();
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)ScriptBytecodeAdapter.getField(1.class, OidcServiceGroovyTest.class, (String)"soip"), (String)"oidcProviderMetadata");
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(ClientAuthenticationMethod.class)});
                callSiteArray[1].call(callSiteArray[2].callGetProperty(ScriptBytecodeAdapter.getField(1.class, OidcServiceGroovyTest.class, (String)"soip")), (Object)"tokenEndpointAuthMethods", (Object)list);
                Object object2 = callSiteArray[3].callConstructor(URI.class, (Object)"https://localhost/oidc/token");
                callSiteArray[4].call(callSiteArray[5].callGetProperty(ScriptBytecodeAdapter.getField(1.class, OidcServiceGroovyTest.class, (String)"soip")), (Object)"userInfoEndpointURI", object2);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, OidcServiceGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ void super$2$initializeProvider() {
                super.initializeProvider();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "CLIENT_SECRET_BASIC";
                stringArray[1] = "putAt";
                stringArray[2] = "oidcProviderMetadata";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "putAt";
                stringArray[5] = "oidcProviderMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        return soip;
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OidcServiceGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OidcServiceGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OidcServiceGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    private static NiFiProperties buildNiFiProperties() {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        return OidcServiceGroovyTest.buildNiFiProperties(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    private static StandardOidcIdentityProvider buildIdentityProviderWithMockInitializedProvider() {
        CallSite[] callSiteArray = OidcServiceGroovyTest.$getCallSiteArray();
        return OidcServiceGroovyTest.buildIdentityProviderWithMockInitializedProvider(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != OidcServiceGroovyTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Map map;
        Object object = OidcServiceGroovyTest.$getCallSiteArray()[31].call(LoggerFactory.class, OidcServiceGroovyTest.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        DEFAULT_NIFI_PROPERTIES = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"nifi.security.user.oidc.discovery.url", "https://localhost/oidc", "nifi.security.user.login.identity.provider", "provider", "nifi.security.user.knox.url", "url", "nifi.security.user.oidc.connect.timeout", "1000", "nifi.security.user.oidc.read.timeout", "1000", "nifi.security.user.oidc.client.id", "expected_client_id", "nifi.security.user.oidc.client.secret", "expected_client_secret", "nifi.security.user.oidc.claim.identifying.user", "username", "nifi.security.user.oidc.preferred.jwsalgorithm", ""});
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "metaClass";
        stringArray[1] = "buildNiFiProperties";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "plus";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "buildIdentityProviderWithMockInitializedProvider";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "info";
        stringArray[8] = "storeJwt";
        stringArray[9] = "getJwt";
        stringArray[10] = "info";
        stringArray[11] = "buildIdentityProviderWithMockInitializedProvider";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "info";
        stringArray[14] = "storeJwt";
        stringArray[15] = "getJwt";
        stringArray[16] = "info";
        stringArray[17] = "buildIdentityProviderWithMockInitializedProvider";
        stringArray[18] = "MILLISECONDS";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "info";
        stringArray[21] = "storeJwt";
        stringArray[22] = "sleep";
        stringArray[23] = "info";
        stringArray[24] = "getJwt";
        stringArray[25] = "info";
        stringArray[26] = "buildNiFiProperties";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "PUBLIC";
        stringArray[31] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[32];
        OidcServiceGroovyTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OidcServiceGroovyTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OidcServiceGroovyTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

