/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.JWTID;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.knox.KnoxConfiguration;
import org.apache.nifi.web.security.knox.KnoxService;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class KnoxServiceTest {
    private static final String AUDIENCE = "https://apache-knox/token";
    private static final String AUDIENCE_2 = "https://apache-knox-2/token";

    @BeforeClass
    public static void setupClass() {
        Assume.assumeTrue((String)"Test only runs on *nix", (!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
    }

    @Test(expected=IllegalStateException.class)
    public void testKnoxSsoNotEnabledGetKnoxUrl() throws Exception {
        KnoxConfiguration configuration = (KnoxConfiguration)Mockito.mock(KnoxConfiguration.class);
        Mockito.when((Object)configuration.isKnoxEnabled()).thenReturn((Object)false);
        KnoxService service = new KnoxService(configuration);
        Assert.assertFalse((boolean)service.isKnoxEnabled());
        service.getKnoxUrl();
    }

    @Test(expected=IllegalStateException.class)
    public void testKnoxSsoNotEnabledGetAuthenticatedFromToken() throws Exception {
        KnoxConfiguration configuration = (KnoxConfiguration)Mockito.mock(KnoxConfiguration.class);
        Mockito.when((Object)configuration.isKnoxEnabled()).thenReturn((Object)false);
        KnoxService service = new KnoxService(configuration);
        Assert.assertFalse((boolean)service.isKnoxEnabled());
        service.getAuthenticationFromToken("jwt-token-value");
    }

    private JWTAuthenticationClaimsSet getAuthenticationClaimsSet(String subject, String audience, Date expiration) {
        return new JWTAuthenticationClaimsSet(new ClientID(subject), new Audience(audience).toSingleAudienceList(), expiration, null, null, new JWTID());
    }

    @Test
    public void testSignedJwt() throws Exception {
        String subject = "user-1";
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
        JWTAuthenticationClaimsSet claimsSet = this.getAuthenticationClaimsSet("user-1", AUDIENCE, expiration);
        PrivateKeyJWT privateKeyJWT = new PrivateKeyJWT(claimsSet, JWSAlgorithm.RS256, privateKey, null, null);
        KnoxConfiguration configuration = this.getConfiguration(publicKey);
        KnoxService service = new KnoxService(configuration);
        Assert.assertEquals((Object)"user-1", (Object)service.getAuthenticationFromToken(privateKeyJWT.getClientAssertion().serialize()));
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testBadSignedJwt() throws Exception {
        String subject = "user-1";
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair1 = keyGen.generateKeyPair();
        RSAPrivateKey privateKey1 = (RSAPrivateKey)pair1.getPrivate();
        KeyPair pair2 = keyGen.generateKeyPair();
        RSAPublicKey publicKey2 = (RSAPublicKey)pair2.getPublic();
        JWTAuthenticationClaimsSet claimsSet = this.getAuthenticationClaimsSet("user-1", AUDIENCE, expiration);
        PrivateKeyJWT privateKeyJWT = new PrivateKeyJWT(claimsSet, JWSAlgorithm.RS256, privateKey1, null, null);
        KnoxConfiguration configuration = this.getConfiguration(publicKey2);
        KnoxService service = new KnoxService(configuration);
        service.getAuthenticationFromToken(privateKeyJWT.getClientAssertion().serialize());
    }

    @Test(expected=ParseException.class)
    public void testPlainJwt() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject("user-1").expirationTime(expiration).build();
        PlainJWT plainJWT = new PlainJWT(claimsSet);
        KnoxConfiguration configuration = this.getConfiguration(publicKey);
        KnoxService service = new KnoxService(configuration);
        service.getAuthenticationFromToken(plainJWT.serialize());
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testExpiredJwt() throws Exception {
        String subject = "user-1";
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS));
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
        Thread.sleep(TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS));
        JWTAuthenticationClaimsSet claimsSet = this.getAuthenticationClaimsSet("user-1", AUDIENCE, expiration);
        PrivateKeyJWT privateKeyJWT = new PrivateKeyJWT(claimsSet, JWSAlgorithm.RS256, privateKey, null, null);
        KnoxConfiguration configuration = this.getConfiguration(publicKey);
        KnoxService service = new KnoxService(configuration);
        service.getAuthenticationFromToken(privateKeyJWT.getClientAssertion().serialize());
    }

    @Test
    public void testRequiredAudience() throws Exception {
        String subject = "user-1";
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
        JWTAuthenticationClaimsSet claimsSet = this.getAuthenticationClaimsSet("user-1", AUDIENCE, expiration);
        PrivateKeyJWT privateKeyJWT = new PrivateKeyJWT(claimsSet, JWSAlgorithm.RS256, privateKey, null, null);
        KnoxConfiguration configuration = this.getConfiguration(publicKey);
        Mockito.when((Object)configuration.getAudiences()).thenReturn(null);
        KnoxService service = new KnoxService(configuration);
        Assert.assertEquals((Object)"user-1", (Object)service.getAuthenticationFromToken(privateKeyJWT.getClientAssertion().serialize()));
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testInvalidAudience() throws Exception {
        String subject = "user-1";
        Date expiration = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
        JWTAuthenticationClaimsSet claimsSet = this.getAuthenticationClaimsSet("user-1", "incorrect-audience", expiration);
        PrivateKeyJWT privateKeyJWT = new PrivateKeyJWT(claimsSet, JWSAlgorithm.RS256, privateKey, null, null);
        KnoxConfiguration configuration = this.getConfiguration(publicKey);
        KnoxService service = new KnoxService(configuration);
        Assert.assertEquals((Object)"user-1", (Object)service.getAuthenticationFromToken(privateKeyJWT.getClientAssertion().serialize()));
    }

    private KnoxConfiguration getConfiguration(RSAPublicKey publicKey) throws Exception {
        KnoxConfiguration configuration = (KnoxConfiguration)Mockito.mock(KnoxConfiguration.class);
        Mockito.when((Object)configuration.isKnoxEnabled()).thenReturn((Object)true);
        Mockito.when((Object)configuration.getKnoxUrl()).thenReturn((Object)"knox-sso-url");
        Mockito.when((Object)configuration.getKnoxCookieName()).thenReturn((Object)"knox-cookie-name");
        Mockito.when((Object)configuration.getAudiences()).thenReturn(Stream.of(AUDIENCE, AUDIENCE_2).collect(Collectors.toSet()));
        Mockito.when((Object)configuration.getKnoxPublicKey()).thenReturn((Object)publicKey);
        return configuration;
    }
}

