/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import java.net.URI;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.apache.nifi.web.security.http.SecurityHeader;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class StandardCookieCsrfTokenRepository
implements CsrfTokenRepository {
    private static final String REQUEST_PARAMETER = "requestToken";
    private static final String ROOT_PATH = "/";
    private static final String EMPTY = "";
    private static final boolean SECURE_ENABLED = true;
    private static final int MAX_AGE_EXPIRED = 0;
    private static final int MAX_AGE_SESSION = -1;

    public CsrfToken generateToken(HttpServletRequest httpServletRequest) {
        CsrfToken csrfToken = this.loadToken(httpServletRequest);
        if (csrfToken == null) {
            csrfToken = this.getCsrfToken(this.generateRandomToken());
        }
        return csrfToken;
    }

    public void saveToken(CsrfToken csrfToken, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String token = csrfToken == null ? EMPTY : csrfToken.getToken();
        int maxAge = csrfToken == null ? 0 : -1;
        Cookie cookie = new Cookie(SecurityCookieName.REQUEST_TOKEN.getName(), token);
        cookie.setSecure(true);
        cookie.setMaxAge(maxAge);
        String cookiePath = this.getCookiePath(httpServletRequest);
        cookie.setPath(cookiePath);
        httpServletResponse.addCookie(cookie);
    }

    public CsrfToken loadToken(HttpServletRequest httpServletRequest) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)SecurityCookieName.REQUEST_TOKEN.getName());
        String token = cookie == null ? null : cookie.getValue();
        return StringUtils.hasLength((String)token) ? this.getCsrfToken(token) : null;
    }

    private CsrfToken getCsrfToken(String token) {
        return new DefaultCsrfToken(SecurityHeader.REQUEST_TOKEN.getHeader(), REQUEST_PARAMETER, token);
    }

    private String generateRandomToken() {
        return UUID.randomUUID().toString();
    }

    private String getCookiePath(HttpServletRequest httpServletRequest) {
        RequestUriBuilder requestUriBuilder = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)httpServletRequest);
        requestUriBuilder.path(ROOT_PATH);
        URI uri = requestUriBuilder.build();
        return uri.getPath();
    }
}

