/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.anonymous;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationProvider;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationRequestToken;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class NiFiAnonymousAuthenticationProviderTest {
    private static final Logger logger = LoggerFactory.getLogger(NiFiAnonymousAuthenticationProviderTest.class);

    @Test
    public void testAnonymousDisabledNotSecure() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)false);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(false, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assert.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }

    @Test
    public void testAnonymousEnabledNotSecure() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)true);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(false, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assert.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }

    @Test(expected=InvalidAuthenticationException.class)
    public void testAnonymousDisabledSecure() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)false);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(true, "");
        anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
    }

    @Test
    public void testAnonymousEnabledSecure() throws Exception {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.isAnonymousAuthenticationAllowed()).thenReturn((Object)true);
        NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider = new NiFiAnonymousAuthenticationProvider(nifiProperties, (Authorizer)Mockito.mock(Authorizer.class));
        NiFiAnonymousAuthenticationRequestToken authenticationRequest = new NiFiAnonymousAuthenticationRequestToken(true, "");
        NiFiAuthenticationToken authentication = (NiFiAuthenticationToken)anonymousAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getDetails();
        Assert.assertTrue((boolean)userDetails.getNiFiUser().isAnonymous());
    }
}

