/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.csrf.StandardCookieCsrfTokenRepository;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.web.csrf.CsrfToken;

@ExtendWith(value={MockitoExtension.class})
public class StandardCookieCsrfTokenRepositoryTest {
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final int MAX_AGE_SESSION = -1;
    private static final int MAX_AGE_EXPIRED = 0;
    private static final String ROOT_PATH = "/";
    private static final String CONTEXT_PATH = "/context-path";
    private static final String COOKIE_CONTEXT_PATH = "/context-path/";
    private static final String HTTPS = "https";
    private static final String HOST = "localhost";
    private static final String PORT = "443";
    private static final String EMPTY = "";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private ServletContext servletContext;
    @Captor
    private ArgumentCaptor<Cookie> cookieArgumentCaptor;
    private StandardCookieCsrfTokenRepository repository;

    @BeforeEach
    public void setRepository() {
        this.repository = new StandardCookieCsrfTokenRepository();
    }

    @Test
    public void testGenerateToken() {
        CsrfToken csrfToken = this.repository.generateToken(this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertNotNull((Object)csrfToken.getToken());
    }

    @Test
    public void testGenerateTokenCookieFound() {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(SecurityCookieName.REQUEST_TOKEN.getName(), token);
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        CsrfToken csrfToken = this.repository.generateToken(this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertEquals((Object)token, (Object)csrfToken.getToken());
    }

    @Test
    public void testLoadToken() {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(SecurityCookieName.REQUEST_TOKEN.getName(), token);
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        CsrfToken csrfToken = this.repository.loadToken(this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertEquals((Object)token, (Object)csrfToken.getToken());
    }

    @Test
    public void testSaveToken() {
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)this.servletContext);
        CsrfToken csrfToken = this.repository.generateToken(this.request);
        this.repository.saveToken(csrfToken, this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieArgumentCaptor.capture());
        Cookie cookie = (Cookie)this.cookieArgumentCaptor.getValue();
        this.assertCookieEquals(csrfToken, cookie);
        Assertions.assertEquals((Object)ROOT_PATH, (Object)cookie.getPath());
    }

    @Test
    public void testSaveTokenNullCsrfToken() {
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)this.servletContext);
        this.repository.saveToken(null, this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieArgumentCaptor.capture());
        Cookie cookie = (Cookie)this.cookieArgumentCaptor.getValue();
        Assertions.assertEquals((Object)ROOT_PATH, (Object)cookie.getPath());
        Assertions.assertEquals((Object)EMPTY, (Object)cookie.getValue());
        Assertions.assertEquals((int)0, (int)cookie.getMaxAge());
        Assertions.assertTrue((boolean)cookie.getSecure());
        Assertions.assertFalse((boolean)cookie.isHttpOnly());
        Assertions.assertNull((Object)cookie.getDomain());
    }

    @Test
    public void testSaveTokenProxyContextPath() {
        this.repository = new StandardCookieCsrfTokenRepository();
        CsrfToken csrfToken = this.repository.generateToken(this.request);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"X-ProxyScheme"))).thenReturn((Object)HTTPS);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"X-ProxyHost"))).thenReturn((Object)HOST);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"X-ProxyPort"))).thenReturn((Object)PORT);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"X-ProxyContextPath"))).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.servletContext.getInitParameter((String)ArgumentMatchers.eq((Object)ALLOWED_CONTEXT_PATHS_PARAMETER))).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)this.servletContext);
        this.repository.saveToken(csrfToken, this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieArgumentCaptor.capture());
        Cookie cookie = (Cookie)this.cookieArgumentCaptor.getValue();
        this.assertCookieEquals(csrfToken, cookie);
        Assertions.assertEquals((Object)COOKIE_CONTEXT_PATH, (Object)cookie.getPath());
    }

    private void assertCookieEquals(CsrfToken csrfToken, Cookie cookie) {
        Assertions.assertEquals((Object)csrfToken.getToken(), (Object)cookie.getValue());
        Assertions.assertEquals((int)-1, (int)cookie.getMaxAge());
        Assertions.assertTrue((boolean)cookie.getSecure());
        Assertions.assertFalse((boolean)cookie.isHttpOnly());
        Assertions.assertNull((Object)cookie.getDomain());
    }
}

