/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509.ocsp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import org.bouncycastle.shaded.asn1.ASN1Encodable;
import org.bouncycastle.shaded.asn1.x500.X500Name;
import org.bouncycastle.shaded.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.shaded.asn1.x509.KeyPurposeId;
import org.bouncycastle.shaded.asn1.x509.KeyUsage;
import org.bouncycastle.shaded.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.shaded.asn1.x509.X509Extension;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.X509v3CertificateBuilder;
import org.bouncycastle.shaded.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.bouncycastle.shaded.operator.ContentSigner;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.operator.jcajce.JcaContentSignerBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspCertificateValidatorTest {
    private static final Logger logger = LoggerFactory.getLogger(OcspCertificateValidatorTest.class);
    private static final int KEY_SIZE = 2048;
    private static final long YESTERDAY = System.currentTimeMillis() - 86400000L;
    private static final long ONE_YEAR_FROM_NOW = System.currentTimeMillis() + 1471228928L;
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String PROVIDER = "BC";

    @BeforeClass
    public static void setUpOnce() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    private static X509Certificate generateCertificate(String dn) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        KeyPair keyPair = OcspCertificateValidatorTest.generateKeyPair();
        return OcspCertificateValidatorTest.generateCertificate(dn, keyPair);
    }

    private static X509Certificate generateCertificate(String dn, KeyPair keyPair) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        PrivateKey privateKey = keyPair.getPrivate();
        ContentSigner sigGen = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER).build(privateKey);
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        Date startDate = new Date(YESTERDAY);
        Date endDate = new Date(ONE_YEAR_FROM_NOW);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new X500Name(dn), BigInteger.valueOf(System.currentTimeMillis()), startDate, endDate, new X500Name(dn), subPubKeyInfo);
        certBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(184));
        Vector<KeyPurposeId> ekUsages = new Vector<KeyPurposeId>();
        ekUsages.add(KeyPurposeId.id_kp_clientAuth);
        ekUsages.add(KeyPurposeId.id_kp_serverAuth);
        certBuilder.addExtension(X509Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(ekUsages));
        X509CertificateHolder certificateHolder = certBuilder.build(sigGen);
        return new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certificateHolder);
    }

    private static X509Certificate generateIssuedCertificate(String dn, String issuerDn, PrivateKey issuerKey) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        KeyPair keyPair = OcspCertificateValidatorTest.generateKeyPair();
        return OcspCertificateValidatorTest.generateIssuedCertificate(dn, keyPair.getPublic(), issuerDn, issuerKey);
    }

    private static X509Certificate generateIssuedCertificate(String dn, PublicKey publicKey, String issuerDn, PrivateKey issuerKey) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        ContentSigner sigGen = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER).build(issuerKey);
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Date startDate = new Date(YESTERDAY);
        Date endDate = new Date(ONE_YEAR_FROM_NOW);
        X509v3CertificateBuilder v3CertGen = new X509v3CertificateBuilder(new X500Name(issuerDn), BigInteger.valueOf(System.currentTimeMillis()), startDate, endDate, new X500Name(dn), subPubKeyInfo);
        X509CertificateHolder certificateHolder = v3CertGen.build(sigGen);
        return new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certificateHolder);
    }

    @Test
    public void testShouldGenerateCertificate() throws Exception {
        String testDn = "CN=This is a test";
        X509Certificate certificate = OcspCertificateValidatorTest.generateCertificate("CN=This is a test");
        logger.info("Generated certificate: \n{}", (Object)certificate);
        assert (certificate.getSubjectDN().getName().equals("CN=This is a test"));
        assert (certificate.getIssuerDN().getName().equals("CN=This is a test"));
        certificate.verify(certificate.getPublicKey());
    }

    @Test
    public void testShouldGenerateCertificateFromKeyPair() throws Exception {
        String testDn = "CN=This is a test";
        KeyPair keyPair = OcspCertificateValidatorTest.generateKeyPair();
        X509Certificate certificate = OcspCertificateValidatorTest.generateCertificate("CN=This is a test", keyPair);
        logger.info("Generated certificate: \n{}", (Object)certificate);
        assert (certificate.getPublicKey().equals(keyPair.getPublic()));
        assert (certificate.getSubjectDN().getName().equals("CN=This is a test"));
        assert (certificate.getIssuerDN().getName().equals("CN=This is a test"));
        certificate.verify(certificate.getPublicKey());
    }

    @Test
    public void testShouldGenerateIssuedCertificate() throws Exception {
        block6: {
            String testDn = "CN=This is a signed test";
            String issuerDn = "CN=Issuer CA";
            KeyPair issuerKeyPair = OcspCertificateValidatorTest.generateKeyPair();
            PrivateKey issuerPrivateKey = issuerKeyPair.getPrivate();
            X509Certificate issuerCertificate = OcspCertificateValidatorTest.generateCertificate("CN=Issuer CA", issuerKeyPair);
            logger.info("Generated issuer certificate: \n{}", (Object)issuerCertificate);
            X509Certificate certificate = OcspCertificateValidatorTest.generateIssuedCertificate("CN=This is a signed test", "CN=Issuer CA", issuerPrivateKey);
            logger.info("Generated signed certificate: \n{}", (Object)certificate);
            assert (issuerCertificate.getPublicKey().equals(issuerKeyPair.getPublic()));
            assert (certificate.getSubjectX500Principal().getName().equals("CN=This is a signed test"));
            assert (certificate.getIssuerX500Principal().getName().equals("CN=Issuer CA"));
            certificate.verify(issuerCertificate.getPublicKey());
            try {
                certificate.verify(certificate.getPublicKey());
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Exception e) {
                assert (e instanceof SignatureException);
                if ($assertionsDisabled || e.getMessage().contains("certificate does not verify with supplied key")) break block6;
                throw new AssertionError();
            }
        }
    }
}

