/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.requests;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.GroovyTestCase;
import java.beans.Transient;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.security.requests.ContentLengthFilter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ContentLengthFilterTest
extends GroovyTestCase
implements GroovyObject {
    private static final Logger logger;
    private static final int MAX_CONTENT_LENGTH = 1000;
    private static final int SERVER_IDLE_TIMEOUT = 2500;
    private static final String POST_REQUEST = "POST / HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\n\r\n%s";
    private static final String FORM_REQUEST = "POST / HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\nContent-Type: application/x-www-form-urlencoded\r\nAccept-Charset: UTF-8\r\n\r\n%s";
    public static final int FORM_CONTENT_SIZE = 128;
    private static final int SMALL_CLAIM_SIZE_BYTES = 150;
    private static final String SMALL_PAYLOAD;
    private static final int LARGE_CLAIM_SIZE_BYTES = 2000;
    private static final String LARGE_PAYLOAD;
    private Server serverUnderTest;
    private LocalConnector localConnector;
    private ServletContextHandler contextUnderTest;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ContentLengthFilterTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_setUpOnce_closure1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{callSiteArray[1].callSafe((Object)name), callSiteArray[2].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            @Generated
            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "toUpperCase";
                stringArray[2] = "join";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(ContentLengthFilterTest.class, ContentLengthFilterTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[0].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @Before
    public void setUp() {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
    }

    @After
    public void tearDown() {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.stopServer();
        }
    }

    public void stopServer() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.serverUnderTest) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)this.serverUnderTest))) {
            callSiteArray[3].call((Object)this.serverUnderTest);
        }
    }

    private void configureAndStartServer(HttpServlet servlet, int maxFormContentSize) throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        Object object = callSiteArray[4].callConstructor(Server.class);
        this.serverUnderTest = (Server)ScriptBytecodeAdapter.castToType((Object)object, Server.class);
        Object object2 = callSiteArray[5].callConstructor(LocalConnector.class, (Object)this.serverUnderTest);
        this.localConnector = (LocalConnector)ScriptBytecodeAdapter.castToType((Object)object2, LocalConnector.class);
        callSiteArray[6].call((Object)this.localConnector, (Object)SERVER_IDLE_TIMEOUT);
        callSiteArray[7].call((Object)this.serverUnderTest, (Object)this.localConnector);
        Object object3 = callSiteArray[8].callConstructor(ServletContextHandler.class, (Object)this.serverUnderTest, (Object)"/");
        this.contextUnderTest = (ServletContextHandler)ScriptBytecodeAdapter.castToType((Object)object3, ServletContextHandler.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (maxFormContentSize > 0) {
                callSiteArray[9].call((Object)this.contextUnderTest, (Object)maxFormContentSize);
            }
        } else if (maxFormContentSize > 0) {
            callSiteArray[10].call((Object)this.contextUnderTest, (Object)maxFormContentSize);
        }
        callSiteArray[11].call((Object)this.contextUnderTest, callSiteArray[12].callConstructor(ServletHolder.class, (Object)servlet), (Object)"/*");
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (maxFormContentSize < 0) {
                FilterHolder holder = (FilterHolder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call((Object)this.contextUnderTest, ContentLengthFilter.class, (Object)"/*", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((EnumSet)ScriptBytecodeAdapter.asType((Object)callSiteArray[14].call(EnumSet.class, callSiteArray[15].callGetProperty(DispatcherType.class)), EnumSet.class)), EnumSet.class)), FilterHolder.class);
                callSiteArray[16].call((Object)holder, callSiteArray[17].callGetProperty(ContentLengthFilter.class), callSiteArray[18].call(String.class, (Object)MAX_CONTENT_LENGTH));
            }
        } else if (maxFormContentSize < 0) {
            FilterHolder holder = (FilterHolder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call((Object)this.contextUnderTest, ContentLengthFilter.class, (Object)"/*", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((EnumSet)ScriptBytecodeAdapter.asType((Object)callSiteArray[20].call(EnumSet.class, callSiteArray[21].callGetProperty(DispatcherType.class)), EnumSet.class)), EnumSet.class)), FilterHolder.class);
            callSiteArray[22].call((Object)holder, callSiteArray[23].callGetProperty(ContentLengthFilter.class), callSiteArray[24].call(String.class, (Object)MAX_CONTENT_LENGTH));
        }
        callSiteArray[25].call((Object)this.serverUnderTest);
    }

    private void createSimpleReadServer() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        public final class _createSimpleReadServer_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createSimpleReadServer_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createSimpleReadServer_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(HttpServletRequest req, HttpServletResponse resp) {
                CallSite[] callSiteArray = _createSimpleReadServer_closure2.$getCallSiteArray();
                byte[] byteBuffer = new byte[2048];
                int bytesRead = DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].call(StreamUtils.class, callSiteArray[1].call((Object)req), (Object)byteBuffer, (Object)false));
                callSiteArray[2].call((Object)resp, (Object)"Bytes-Read", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)bytesRead, String.class)), String.class));
                callSiteArray[3].call((Object)resp, callSiteArray[4].callGetProperty(HttpServletResponse.class));
                return callSiteArray[5].call(callSiteArray[6].call((Object)resp), (Object)new GStringImpl(new Object[]{bytesRead}, new String[]{"Read ", " bytes of request input"}));
            }

            @Generated
            public Object call(HttpServletRequest req, HttpServletResponse resp) {
                CallSite[] callSiteArray = _createSimpleReadServer_closure2.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)req, (Object)resp);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSimpleReadServer_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fillBuffer";
                stringArray[1] = "getInputStream";
                stringArray[2] = "setHeader";
                stringArray[3] = "setStatus";
                stringArray[4] = "SC_OK";
                stringArray[5] = "write";
                stringArray[6] = "getWriter";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _createSimpleReadServer_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createSimpleReadServer_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createSimpleReadServer_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        HttpServlet mockServlet = (HttpServlet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"doPost", new _createSimpleReadServer_closure2((Object)this, (Object)this)}), HttpServlet.class);
        callSiteArray[26].callCurrent((GroovyObject)this, (Object)mockServlet, (Object)-1);
    }

    private static void logResponse(String response, String s) {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        String responseId = ShortTypeHandling.castToString((Object)callSiteArray[27].call(String.class, callSiteArray[28].call(callSiteArray[29].call(System.class), (Object)100)));
        String delimiterLine = ShortTypeHandling.castToString((Object)callSiteArray[30].call(callSiteArray[31].call((Object)"\n-----", (Object)responseId), (Object)"-----\n"));
        String formattedResponse = ShortTypeHandling.castToString((Object)callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call((Object)s, (Object)delimiterLine), (Object)response), (Object)delimiterLine));
        callSiteArray[35].call((Object)logger, (Object)formattedResponse);
    }

    @Test
    public void testRequestsWithMissingContentLengthHeader() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[36].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String response = ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)this.localConnector, (Object)"POST / HTTP/1.0\r\n\r\n"));
        callSiteArray[38].call(Assert.class, callSiteArray[39].call(StringUtils.class, (Object)response, (Object)"411 Length Required"));
    }

    @Test
    public void testShouldRejectRequestWithLongContentLengthHeader() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[40].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String requestBody = ShortTypeHandling.castToString((Object)callSiteArray[41].call(String.class, (Object)POST_REQUEST, (Object)LARGE_CLAIM_SIZE_BYTES, (Object)LARGE_PAYLOAD));
        callSiteArray[42].call((Object)logger, (Object)new GStringImpl(new Object[]{LARGE_CLAIM_SIZE_BYTES, callSiteArray[43].call((Object)LARGE_PAYLOAD)}, new String[]{"Making request with CL: ", " and actual length: ", ""}));
        String response = ShortTypeHandling.castToString((Object)callSiteArray[44].call((Object)this.localConnector, (Object)requestBody));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[45].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"413 Payload Too Large");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"413 Payload Too Large\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldRejectRequestWithLongContentLengthHeaderAndSmallPayload() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[46].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String incompletePayload = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[47].call((Object)"1", callSiteArray[48].call((Object)SMALL_CLAIM_SIZE_BYTES, (Object)2));
            incompletePayload = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[49].call((Object)"1", callSiteArray[50].call((Object)SMALL_CLAIM_SIZE_BYTES, (Object)2));
            incompletePayload = ShortTypeHandling.castToString((Object)object);
        }
        String requestBody = ShortTypeHandling.castToString((Object)callSiteArray[51].call(String.class, (Object)POST_REQUEST, (Object)LARGE_CLAIM_SIZE_BYTES, (Object)incompletePayload));
        callSiteArray[52].call((Object)logger, (Object)new GStringImpl(new Object[]{LARGE_CLAIM_SIZE_BYTES, callSiteArray[53].call((Object)incompletePayload)}, new String[]{"Making request with CL: ", " and actual length: ", ""}));
        String response = ShortTypeHandling.castToString((Object)callSiteArray[54].call((Object)this.localConnector, (Object)requestBody));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[55].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"413 Payload Too Large");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"413 Payload Too Large\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldRejectRequestWithSmallContentLengthHeaderAndLargePayload() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[56].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String requestBody = ShortTypeHandling.castToString((Object)callSiteArray[57].call(String.class, (Object)POST_REQUEST, (Object)SMALL_CLAIM_SIZE_BYTES, (Object)LARGE_PAYLOAD));
        callSiteArray[58].call((Object)logger, (Object)new GStringImpl(new Object[]{SMALL_CLAIM_SIZE_BYTES, callSiteArray[59].call((Object)LARGE_PAYLOAD)}, new String[]{"Making request with CL: ", " and actual length: ", ""}));
        String response = ShortTypeHandling.castToString((Object)callSiteArray[60].call((Object)this.localConnector, (Object)requestBody));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[61].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"200");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"200\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = response;
            valueRecorder2.record((Object)string, 8);
            Object[] objectArray = new Object[1];
            int n = SMALL_CLAIM_SIZE_BYTES;
            valueRecorder2.record((Object)n, 35);
            valueRecorder2.record((Object)n, 35);
            objectArray[0] = n;
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)new GStringImpl(objectArray, new String[]{"Bytes-Read: ", ""}));
            valueRecorder2.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"Bytes-Read: ${SMALL_CLAIM_SIZE_BYTES}\"", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            String string = response;
            valueRecorder3.record((Object)string, 8);
            Object[] objectArray = new Object[1];
            int n = SMALL_CLAIM_SIZE_BYTES;
            valueRecorder3.record((Object)n, 28);
            valueRecorder3.record((Object)n, 28);
            objectArray[0] = n;
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)new GStringImpl(objectArray, new String[]{"Read ", " bytes"}));
            valueRecorder3.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"Read ${SMALL_CLAIM_SIZE_BYTES} bytes\"", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTimeoutRequestWithSmallContentLengthHeaderAndSmallerPayload() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[62].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String smallerPayload = ShortTypeHandling.castToString((Object)callSiteArray[63].call((Object)SMALL_PAYLOAD, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)callSiteArray[64].call(callSiteArray[65].call((Object)SMALL_PAYLOAD), (Object)2), (boolean)true)));
        String requestBody = ShortTypeHandling.castToString((Object)callSiteArray[66].call(String.class, (Object)POST_REQUEST, (Object)SMALL_CLAIM_SIZE_BYTES, (Object)smallerPayload));
        callSiteArray[67].call((Object)logger, (Object)new GStringImpl(new Object[]{SMALL_CLAIM_SIZE_BYTES, callSiteArray[68].call((Object)smallerPayload)}, new String[]{"Making request with CL: ", " and actual length: ", ""}));
        String response = ShortTypeHandling.castToString((Object)callSiteArray[69].call((Object)this.localConnector, (Object)requestBody, (Object)500, callSiteArray[70].callGetProperty(TimeUnit.class)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[71].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"500 Server Error");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"500 Server Error\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = response;
            valueRecorder2.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"Timeout");
            valueRecorder2.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"Timeout\"", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Test
    public void testFilterShouldAllowSiteToSiteTransfer() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[72].callCurrent((GroovyObject)this);
        } else {
            this.createSimpleReadServer();
        }
        String SITE_TO_SITE_POST_REQUEST = "POST /nifi-api/data-transfer/input-ports HTTP/1.1\r\nContent-Length: %d\r\nHost: h\r\n\r\n%s";
        String siteToSiteRequest = ShortTypeHandling.castToString((Object)callSiteArray[73].call(String.class, (Object)SITE_TO_SITE_POST_REQUEST, (Object)LARGE_CLAIM_SIZE_BYTES, (Object)LARGE_PAYLOAD));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[74].callStatic(ContentLengthFilterTest.class, (Object)siteToSiteRequest, (Object)"Request: ");
        } else {
            ContentLengthFilterTest.logResponse(siteToSiteRequest, "Request: ");
        }
        String response = ShortTypeHandling.castToString((Object)callSiteArray[75].call((Object)this.localConnector, (Object)siteToSiteRequest));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[76].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"200 OK");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"200 OK\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testJettyMaxFormSize() throws Exception {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        callSiteArray[77].callCurrent((GroovyObject)this, (Object)new GroovyObject(this){
            final /* synthetic */ ContentLengthFilterTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                ContentLengthFilterTest contentLengthFilterTest;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = contentLengthFilterTest = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                block10: {
                    CallSite[] callSiteArray = 1.$getCallSiteArray();
                    try {
                        callSiteArray[0].call((Object)req);
                        ServletInputStream input = (ServletInputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call((Object)req), ServletInputStream.class);
                        int count = 0;
                        while (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)input))) {
                            callSiteArray[3].call((Object)input);
                            count = DefaultTypeTransformation.intUnbox((Object)callSiteArray[4].call((Object)count, (Object)1));
                        }
                        int FORM_LIMIT_BYTES = DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"FORM_CONTENT_SIZE"), callSiteArray[6].call((Object)"a=\n")));
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (count > FORM_LIMIT_BYTES) {
                                callSiteArray[7].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Bytes read ({}) is larger than the limit ({})", (Object)count, (Object)FORM_LIMIT_BYTES);
                                callSiteArray[8].call((Object)resp, callSiteArray[9].callGetProperty(HttpServletResponse.class), (Object)"Should not reach this code.");
                            } else {
                                callSiteArray[10].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Bytes read ({}) is less than or equal to the limit ({})", (Object)count, (Object)FORM_LIMIT_BYTES);
                                callSiteArray[11].call((Object)resp, callSiteArray[12].callGetProperty(HttpServletResponse.class), (Object)"Read Too Many Bytes");
                            }
                            break block10;
                        }
                        if (count > FORM_LIMIT_BYTES) {
                            callSiteArray[13].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Bytes read ({}) is larger than the limit ({})", (Object)count, (Object)FORM_LIMIT_BYTES);
                            callSiteArray[14].call((Object)resp, callSiteArray[15].callGetProperty(HttpServletResponse.class), (Object)"Should not reach this code.");
                            break block10;
                        }
                        callSiteArray[16].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Bytes read ({}) is less than or equal to the limit ({})", (Object)count, (Object)FORM_LIMIT_BYTES);
                        callSiteArray[17].call((Object)resp, callSiteArray[18].callGetProperty(HttpServletResponse.class), (Object)"Read Too Many Bytes");
                    }
                    catch (Exception e) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call(StringUtils.class, callSiteArray[20].call(callSiteArray[21].call((Object)e)), callSiteArray[22].call((Object)"Form is larger than max length ", ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"FORM_CONTENT_SIZE"))))) {
                            callSiteArray[23].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Exception thrown by input stream: ", (Object)e);
                            callSiteArray[24].call((Object)resp, callSiteArray[25].callGetProperty(HttpServletResponse.class), (Object)"Payload Too Large");
                            break block10;
                        }
                        callSiteArray[26].call(ScriptBytecodeAdapter.getField(1.class, ContentLengthFilterTest.class, (String)"logger"), (Object)"Exception thrown by input stream: ", (Object)e);
                        callSiteArray[27].call((Object)resp, callSiteArray[28].callGetProperty(HttpServletResponse.class), (Object)"Should not reach this code, either.");
                    }
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$4(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ContentLengthFilterTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$4(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ContentLengthFilterTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$4(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ContentLengthFilterTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ void super$3$doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
                super.doPost(httpServletRequest, httpServletResponse);
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getParameterMap";
                stringArray[1] = "getInputStream";
                stringArray[2] = "isFinished";
                stringArray[3] = "read";
                stringArray[4] = "plus";
                stringArray[5] = "plus";
                stringArray[6] = "length";
                stringArray[7] = "warn";
                stringArray[8] = "sendError";
                stringArray[9] = "SC_INTERNAL_SERVER_ERROR";
                stringArray[10] = "warn";
                stringArray[11] = "sendError";
                stringArray[12] = "SC_EXPECTATION_FAILED";
                stringArray[13] = "warn";
                stringArray[14] = "sendError";
                stringArray[15] = "SC_INTERNAL_SERVER_ERROR";
                stringArray[16] = "warn";
                stringArray[17] = "sendError";
                stringArray[18] = "SC_EXPECTATION_FAILED";
                stringArray[19] = "containsIgnoreCase";
                stringArray[20] = "toString";
                stringArray[21] = "getCause";
                stringArray[22] = "plus";
                stringArray[23] = "warn";
                stringArray[24] = "sendError";
                stringArray[25] = "SC_REQUEST_ENTITY_TOO_LARGE";
                stringArray[26] = "warn";
                stringArray[27] = "sendError";
                stringArray[28] = "SC_FORBIDDEN";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[29];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }, (Object)FORM_CONTENT_SIZE);
        String form = ShortTypeHandling.castToString((Object)callSiteArray[78].call((Object)"a=", callSiteArray[79].call((Object)"1", (Object)FORM_CONTENT_SIZE)));
        String response = ShortTypeHandling.castToString((Object)callSiteArray[80].call((Object)this.localConnector, callSiteArray[81].call(String.class, (Object)FORM_REQUEST, callSiteArray[82].call((Object)form), (Object)form)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[83].callStatic(ContentLengthFilterTest.class, (Object)response);
        } else {
            ContentLengthFilterTest.logResponse(response);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = response;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"413 Payload Too Large");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"413 Payload Too Large\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Object object = callSiteArray[84].call((Object)this.localConnector, callSiteArray[85].call(String.class, (Object)POST_REQUEST, callSiteArray[86].call((Object)form), callSiteArray[87].call((Object)form, (Object)form)));
        response = ShortTypeHandling.castToString((Object)object);
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = response;
            valueRecorder2.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"417 Read Too Many Bytes");
            valueRecorder2.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert response =~ \"417 Read Too Many Bytes\"", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContentLengthFilterTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContentLengthFilterTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContentLengthFilterTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    private static void logResponse(String response) {
        CallSite[] callSiteArray = ContentLengthFilterTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            ContentLengthFilterTest.logResponse(response, "Response: ");
        } else {
            ContentLengthFilterTest.logResponse(response, "Response: ");
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ContentLengthFilterTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ContentLengthFilterTest.$getCallSiteArray()[88].call(LoggerFactory.class, ContentLengthFilterTest.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ContentLengthFilterTest.$getCallSiteArray()[89].call((Object)"1", (Object)SMALL_CLAIM_SIZE_BYTES);
        SMALL_PAYLOAD = ShortTypeHandling.castToString((Object)object2);
        Object object3 = ContentLengthFilterTest.$getCallSiteArray()[90].call((Object)"1", (Object)LARGE_CLAIM_SIZE_BYTES);
        LARGE_PAYLOAD = ShortTypeHandling.castToString((Object)object3);
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    public /* synthetic */ void super$3$tearDown() {
        super.tearDown();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "metaClass";
        stringArray[1] = "stopServer";
        stringArray[2] = "isRunning";
        stringArray[3] = "stop";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "setIdleTimeout";
        stringArray[7] = "addConnector";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "setMaxFormContentSize";
        stringArray[10] = "setMaxFormContentSize";
        stringArray[11] = "addServlet";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "addFilter";
        stringArray[14] = "of";
        stringArray[15] = "REQUEST";
        stringArray[16] = "setInitParameter";
        stringArray[17] = "MAX_LENGTH_INIT_PARAM";
        stringArray[18] = "valueOf";
        stringArray[19] = "addFilter";
        stringArray[20] = "of";
        stringArray[21] = "REQUEST";
        stringArray[22] = "setInitParameter";
        stringArray[23] = "MAX_LENGTH_INIT_PARAM";
        stringArray[24] = "valueOf";
        stringArray[25] = "start";
        stringArray[26] = "configureAndStartServer";
        stringArray[27] = "valueOf";
        stringArray[28] = "mod";
        stringArray[29] = "currentTimeMillis";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "info";
        stringArray[36] = "createSimpleReadServer";
        stringArray[37] = "getResponse";
        stringArray[38] = "assertFalse";
        stringArray[39] = "containsIgnoreCase";
        stringArray[40] = "createSimpleReadServer";
        stringArray[41] = "format";
        stringArray[42] = "info";
        stringArray[43] = "length";
        stringArray[44] = "getResponse";
        stringArray[45] = "logResponse";
        stringArray[46] = "createSimpleReadServer";
        stringArray[47] = "multiply";
        stringArray[48] = "div";
        stringArray[49] = "multiply";
        stringArray[50] = "div";
        stringArray[51] = "format";
        stringArray[52] = "info";
        stringArray[53] = "length";
        stringArray[54] = "getResponse";
        stringArray[55] = "logResponse";
        stringArray[56] = "createSimpleReadServer";
        stringArray[57] = "format";
        stringArray[58] = "info";
        stringArray[59] = "length";
        stringArray[60] = "getResponse";
        stringArray[61] = "logResponse";
        stringArray[62] = "createSimpleReadServer";
        stringArray[63] = "getAt";
        stringArray[64] = "div";
        stringArray[65] = "length";
        stringArray[66] = "format";
        stringArray[67] = "info";
        stringArray[68] = "length";
        stringArray[69] = "getResponse";
        stringArray[70] = "MILLISECONDS";
        stringArray[71] = "logResponse";
        stringArray[72] = "createSimpleReadServer";
        stringArray[73] = "format";
        stringArray[74] = "logResponse";
        stringArray[75] = "getResponse";
        stringArray[76] = "logResponse";
        stringArray[77] = "configureAndStartServer";
        stringArray[78] = "plus";
        stringArray[79] = "multiply";
        stringArray[80] = "getResponse";
        stringArray[81] = "format";
        stringArray[82] = "length";
        stringArray[83] = "logResponse";
        stringArray[84] = "getResponse";
        stringArray[85] = "format";
        stringArray[86] = "length";
        stringArray[87] = "plus";
        stringArray[88] = "getLogger";
        stringArray[89] = "multiply";
        stringArray[90] = "multiply";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[91];
        ContentLengthFilterTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ContentLengthFilterTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ContentLengthFilterTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

