/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.GroovyTestCase;
import java.beans.Transient;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minidev.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.oidc.StandardOidcIdentityProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class StandardOidcIdentityProviderGroovyTest
extends GroovyTestCase
implements GroovyObject {
    private static final Logger logger;
    private static final Map<String, Object> DEFAULT_NIFI_PROPERTIES;
    private static NiFiProperties mockNiFiProperties;
    private static final String MOCK_JWT = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6Ik5pRmkgT0lEQyBVbml0IFRlc3RlciIsImlhdCI6MTUxNjIzOTAyMiwiZXhwIjoxNTE2MzM5MDIyLCJpc3MiOiJuaWZpX3VuaXRfdGVzdF9hdXRob3JpdHkiLCJhdWQiOiJhbGwiLCJ1c2VybmFtZSI6Im9pZGNfdGVzdCIsImVtYWlsIjoib2lkY190ZXN0QG5pZmkuYXBhY2hlLm9yZyJ9.b4NIl0RONKdVLOH0D1eObdwAEX8qX-ExqB8KuKSZFLw";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public StandardOidcIdentityProviderGroovyTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_setUpOnce_closure1.class, StandardOidcIdentityProviderGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{callSiteArray[1].callSafe((Object)name), callSiteArray[2].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            @Generated
            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "toUpperCase";
                stringArray[2] = "join";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(StandardOidcIdentityProviderGroovyTest.class, StandardOidcIdentityProviderGroovyTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[0].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @Before
    public void setUp() throws Exception {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(StandardOidcIdentityProviderGroovyTest.class);
            mockNiFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)object, NiFiProperties.class);
        } else {
            NiFiProperties niFiProperties;
            mockNiFiProperties = niFiProperties = StandardOidcIdentityProviderGroovyTest.buildNiFiProperties();
        }
    }

    @After
    public void teardown() throws Exception {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
    }

    private static NiFiProperties buildNiFiProperties(Map<String, Object> props) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Object combinedProps = callSiteArray[2].call(DEFAULT_NIFI_PROPERTIES, props);
        return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(NiFiProperties.class, combinedProps), NiFiProperties.class);
    }

    @Test
    public void testShouldGetAvailableClaims() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Map EXPECTED_CLAIMS = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"iss", "https://accounts.issuer.com", "azp", "1013352044499-05pb1ssdfuihsdfsdsdfdi8r2vike88m.apps.usercontent.com", "aud", "1013352044499-05pb1ssdfuihsdfsdsdfdi8r2vike88m.apps.usercontent.com", "sub", "10703475345439756345540", "email", "person@nifi.apache.org", "email_verified", "true", "at_hash", "JOGISUDHFiyGHDSFwV5Fah2A", "iat", "1590022674", "exp", "1590026274", "empty_claim", ""});
        public final class _testShouldGetAvailableClaims_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldGetAvailableClaims_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldGetAvailableClaims_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _testShouldGetAvailableClaims_closure2.$getCallSiteArray();
                return callSiteArray[0].call(StringUtils.class, v);
            }

            @Generated
            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _testShouldGetAvailableClaims_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldGetAvailableClaims_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isNotBlank";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testShouldGetAvailableClaims_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testShouldGetAvailableClaims_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldGetAvailableClaims_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List POPULATED_CLAIM_NAMES = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call((Object)EXPECTED_CLAIMS, (Object)new _testShouldGetAvailableClaims_closure2((Object)this, (Object)this)))), List.class);
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callConstructor(JWTClaimsSet.class, (Object)EXPECTED_CLAIMS), JWTClaimsSet.class);
        Object definedClaims = callSiteArray[8].call(StandardOidcIdentityProvider.class, (Object)mockJWTClaimsSet);
        callSiteArray[9].call((Object)logger, (Object)new GStringImpl(new Object[]{definedClaims}, new String[]{"Defined claims: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = definedClaims;
            valueRecorder.record(object, 8);
            List list = POPULATED_CLAIM_NAMES;
            valueRecorder.record((Object)list, 25);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 22);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert definedClaims == POPULATED_CLAIM_NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldCreateClientAuthenticationFromPost() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[14].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)soip, (String)"oidcProviderMetadata");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[15].callGetProperty(ClientAuthenticationMethod.class)});
        callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods", (Object)list);
        List mockAuthMethod = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods"), List.class);
        callSiteArray[20].call((Object)logger, (Object)new GStringImpl(new Object[]{mockAuthMethod}, new String[]{"Provided Auth Method: ", ""}));
        ClientID CLIENT_ID = (ClientID)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(ClientID.class, (Object)"expected_client_id"), ClientID.class);
        Secret CLIENT_SECRET = (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(Secret.class, (Object)"expected_client_secret"), Secret.class);
        ClientID clientID = CLIENT_ID;
        ScriptBytecodeAdapter.setProperty((Object)clientID, null, (Object)soip, (String)"clientId");
        Secret secret = CLIENT_SECRET;
        ScriptBytecodeAdapter.setProperty((Object)secret, null, (Object)soip, (String)"clientSecret");
        ClientAuthentication EXPECTED_CLIENT_AUTHENTICATION = (ClientAuthentication)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(ClientSecretPost.class, (Object)CLIENT_ID, (Object)CLIENT_SECRET), ClientAuthentication.class);
        Object clientAuthentication = callSiteArray[24].call((Object)soip);
        callSiteArray[25].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[26].call(clientAuthentication)}, new String[]{"Client Auth properties: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[27];
            Object object = clientAuthentication;
            valueRecorder.record(object, 8);
            Object object2 = callSite.call(object);
            valueRecorder.record(object2, 29);
            CallSite callSite2 = callSiteArray[28];
            ClientAuthentication clientAuthentication2 = EXPECTED_CLIENT_AUTHENTICATION;
            valueRecorder.record((Object)clientAuthentication2, 46);
            Object object3 = callSite2.call((Object)clientAuthentication2);
            valueRecorder.record(object3, 77);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)object3);
            valueRecorder.record((Object)bl, 43);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert clientAuthentication.getClientID() == EXPECTED_CLIENT_AUTHENTICATION.getClientID()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        callSiteArray[29].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty((Object)((ClientSecretPost)ScriptBytecodeAdapter.asType((Object)clientAuthentication, ClientSecretPost.class))))}, new String[]{"Client secret: ", ""}));
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[32];
            Object object = clientAuthentication;
            valueRecorder2.record(object, 28);
            Object object4 = callSite.call((Object)((ClientSecretPost)ScriptBytecodeAdapter.castToType((Object)object, ClientSecretPost.class)));
            valueRecorder2.record(object4, 50);
            CallSite callSite3 = callSiteArray[33];
            ClientAuthentication clientAuthentication3 = EXPECTED_CLIENT_AUTHENTICATION;
            valueRecorder2.record((Object)clientAuthentication3, 91);
            Object object5 = callSite3.call((Object)((ClientSecretPost)ScriptBytecodeAdapter.castToType((Object)clientAuthentication3, ClientSecretPost.class)));
            valueRecorder2.record(object5, 123);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object4, (Object)object5);
            valueRecorder2.record((Object)bl, 68);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert ((ClientSecretPost) clientAuthentication).getClientSecret() == ((ClientSecretPost) EXPECTED_CLIENT_AUTHENTICATION).getClientSecret()", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldCreateClientAuthenticationFromBasic() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[38].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)soip, (String)"oidcProviderMetadata");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[39].callGetProperty(ClientAuthenticationMethod.class)});
        callSiteArray[40].call(callSiteArray[41].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods", (Object)list);
        List mockAuthMethod = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(callSiteArray[43].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods"), List.class);
        callSiteArray[44].call((Object)logger, (Object)new GStringImpl(new Object[]{mockAuthMethod}, new String[]{"Provided Auth Method: ", ""}));
        ClientID CLIENT_ID = (ClientID)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callConstructor(ClientID.class, (Object)"expected_client_id"), ClientID.class);
        Secret CLIENT_SECRET = (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callConstructor(Secret.class, (Object)"expected_client_secret"), Secret.class);
        ClientID clientID = CLIENT_ID;
        ScriptBytecodeAdapter.setProperty((Object)clientID, null, (Object)soip, (String)"clientId");
        Secret secret = CLIENT_SECRET;
        ScriptBytecodeAdapter.setProperty((Object)secret, null, (Object)soip, (String)"clientSecret");
        ClientAuthentication EXPECTED_CLIENT_AUTHENTICATION = (ClientAuthentication)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callConstructor(ClientSecretBasic.class, (Object)CLIENT_ID, (Object)CLIENT_SECRET), ClientAuthentication.class);
        Object clientAuthentication = callSiteArray[48].call((Object)soip);
        callSiteArray[49].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[50].callGetProperty(clientAuthentication)}, new String[]{"Client authentication properties: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[51];
            Object object = clientAuthentication;
            valueRecorder.record(object, 8);
            Object object2 = callSite.call(object);
            valueRecorder.record(object2, 29);
            CallSite callSite2 = callSiteArray[52];
            ClientAuthentication clientAuthentication2 = EXPECTED_CLIENT_AUTHENTICATION;
            valueRecorder.record((Object)clientAuthentication2, 46);
            Object object3 = callSite2.call((Object)clientAuthentication2);
            valueRecorder.record(object3, 77);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)object3);
            valueRecorder.record((Object)bl, 43);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert clientAuthentication.getClientID() == EXPECTED_CLIENT_AUTHENTICATION.getClientID()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[53];
            Object object = clientAuthentication;
            valueRecorder2.record(object, 8);
            Object object4 = callSite.call(object);
            valueRecorder2.record(object4, 29);
            CallSite callSite3 = callSiteArray[54];
            ClientAuthentication clientAuthentication3 = EXPECTED_CLIENT_AUTHENTICATION;
            valueRecorder2.record((Object)clientAuthentication3, 44);
            Object object5 = callSite3.call((Object)clientAuthentication3);
            valueRecorder2.record(object5, 75);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object4, (Object)object5);
            valueRecorder2.record((Object)bl, 41);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert clientAuthentication.getMethod() == EXPECTED_CLIENT_AUTHENTICATION.getMethod()", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        callSiteArray[55].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[56].callGetProperty(callSiteArray[57].callGetProperty((Object)((ClientSecretBasic)ScriptBytecodeAdapter.asType((Object)clientAuthentication, ClientSecretBasic.class))))}, new String[]{"Client secret: ", ""}));
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[58];
            Object object = clientAuthentication;
            valueRecorder3.record(object, 9);
            Object object6 = callSite.call((Object)((ClientSecretBasic)ScriptBytecodeAdapter.asType((Object)object, ClientSecretBasic.class)));
            valueRecorder3.record(object6, 52);
            CallSite callSite4 = callSiteArray[59];
            ClientAuthentication clientAuthentication4 = EXPECTED_CLIENT_AUTHENTICATION;
            valueRecorder3.record((Object)clientAuthentication4, 73);
            Object object7 = callSite4.callGetProperty((Object)clientAuthentication4);
            valueRecorder3.record(object7, 104);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object6, (Object)object7);
            valueRecorder3.record((Object)bl, 70);
            if (bl) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert (clientAuthentication as ClientSecretBasic).getClientSecret() == EXPECTED_CLIENT_AUTHENTICATION.clientSecret", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldCreateTokenHTTPRequest() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        AuthorizationCode mockCode = (AuthorizationCode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callConstructor(AuthorizationCode.class, (Object)"ABCDE"), AuthorizationCode.class);
        Object mockAuthGrant = callSiteArray[64].callConstructor(AuthorizationCodeGrant.class, (Object)mockCode, (Object)mockURI);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[66].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)soip, (String)"oidcProviderMetadata");
        ClientID CLIENT_ID = (ClientID)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].callConstructor(ClientID.class, (Object)"expected_client_id"), ClientID.class);
        Secret CLIENT_SECRET = (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(Secret.class, (Object)"expected_client_secret"), Secret.class);
        ClientID clientID = CLIENT_ID;
        ScriptBytecodeAdapter.setProperty((Object)clientID, null, (Object)soip, (String)"clientId");
        Secret secret = CLIENT_SECRET;
        ScriptBytecodeAdapter.setProperty((Object)secret, null, (Object)soip, (String)"clientSecret");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[69].callGetProperty(ClientAuthenticationMethod.class)});
        callSiteArray[70].call(callSiteArray[71].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods", (Object)list);
        Object object = callSiteArray[72].callConstructor(URI.class, (Object)"https://localhost/token");
        callSiteArray[73].call(callSiteArray[74].callGetProperty((Object)soip), (Object)"tokenEndpointURI", object);
        Object clientAuthentication = callSiteArray[75].call((Object)soip);
        Object httpRequest = callSiteArray[76].call((Object)soip, mockAuthGrant, clientAuthentication);
        callSiteArray[77].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[78].call(httpRequest)}, new String[]{"HTTP Request: ", ""}));
        callSiteArray[79].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[80].call(URLDecoder.class, callSiteArray[81].callGetProperty(httpRequest), (Object)"UTF-8")}, new String[]{"Query: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[82];
            CallSite callSite2 = callSiteArray[83];
            Object object2 = httpRequest;
            valueRecorder.record(object2, 8);
            Object object3 = callSite2.call(object2);
            valueRecorder.record(object3, 20);
            Object object4 = callSite.call(object3);
            valueRecorder.record(object4, 32);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object4, (Object)"POST");
            valueRecorder.record((Object)bl, 39);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert httpRequest.getMethod().name() == \"POST\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[84];
            Object object5 = httpRequest;
            valueRecorder2.record(object5, 8);
            Object object6 = callSite.callGetProperty(object5);
            valueRecorder2.record(object6, 20);
            Object[] objectArray = new Object[1];
            CallSite callSite3 = callSiteArray[85];
            AuthorizationCode authorizationCode = mockCode;
            valueRecorder2.record((Object)authorizationCode, 37);
            Object object7 = callSite3.callGetProperty((Object)authorizationCode);
            valueRecorder2.record(object7, 46);
            objectArray[0] = object7;
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object6, (Object)new GStringImpl(objectArray, new String[]{"code=", ""}));
            valueRecorder2.record((Object)matcher, 26);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert httpRequest.query =~ \"code=${mockCode.value}\"", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        String encodedUri = ShortTypeHandling.castToString((Object)callSiteArray[86].call(URLEncoder.class, (Object)"https://localhost/oidc", (Object)"UTF-8"));
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[87];
            Object object8 = httpRequest;
            valueRecorder3.record(object8, 8);
            Object object9 = callSite.callGetProperty(object8);
            valueRecorder3.record(object9, 20);
            Object[] objectArray = new Object[1];
            String string = encodedUri;
            valueRecorder3.record((Object)string, 45);
            objectArray[0] = string;
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object9, (Object)new GStringImpl(objectArray, new String[]{"redirect_uri=", "&grant_type=authorization_code"}));
            valueRecorder3.record((Object)matcher, 26);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert httpRequest.query =~ \"redirect_uri=${encodedUri}&grant_type=authorization_code\"", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldLookupIdentityInUserInfo() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[92].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)soip, (String)"oidcProviderMetadata");
        String EXPECTED_IDENTITY = "my_username";
        Map responseBody = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"username", EXPECTED_IDENTITY, "sub", "testSub"});
        HTTPRequest mockUserInfoRequest = (HTTPRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)responseBody, (Object)200, (Object)"HTTP OK"), HTTPRequest.class);
        String identity = ShortTypeHandling.castToString((Object)callSiteArray[94].call((Object)soip, (Object)mockUserInfoRequest));
        callSiteArray[95].call((Object)logger, (Object)new GStringImpl(new Object[]{identity}, new String[]{"Identity: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = identity;
            valueRecorder.record((Object)string, 8);
            String string2 = EXPECTED_IDENTITY;
            valueRecorder.record((Object)string2, 20);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 17);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert identity == EXPECTED_IDENTITY", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testLookupIdentityUserInfoShouldHandleMissingIdentity() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Reference soip = new Reference((Object)((StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class)));
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[100].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)((StandardOidcIdentityProvider)soip.get()), (String)"oidcProviderMetadata");
        Map responseBody = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"username", "", "sub", "testSub"});
        Reference mockUserInfoRequest = new Reference((Object)((HTTPRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)responseBody, (Object)200, (Object)"HTTP NO USER"), HTTPRequest.class)));
        public final class _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soip;
            private /* synthetic */ Reference mockUserInfoRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3(Object _outerInstance, Object _thisObject, Reference soip, Reference mockUserInfoRequest) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soip = reference2 = soip;
                this.mockUserInfoRequest = reference = mockUserInfoRequest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$getCallSiteArray();
                String identity = ShortTypeHandling.castToString((Object)callSiteArray[0].call(this.soip.get(), this.mockUserInfoRequest.get()));
                return callSiteArray[1].call(ScriptBytecodeAdapter.getField(_testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.class, StandardOidcIdentityProviderGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{identity}, new String[]{"Identity: ", ""}));
            }

            @Generated
            public StandardOidcIdentityProvider getSoip() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$getCallSiteArray();
                return (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)this.soip.get(), StandardOidcIdentityProvider.class);
            }

            @Generated
            public HTTPRequest getMockUserInfoRequest() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$getCallSiteArray();
                return (HTTPRequest)ScriptBytecodeAdapter.castToType((Object)this.mockUserInfoRequest.get(), HTTPRequest.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "lookupIdentityInUserInfo";
                stringArray[1] = "info";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[102].callCurrent((GroovyObject)this, IllegalStateException.class, (Object)new _testLookupIdentityUserInfoShouldHandleMissingIdentity_closure3((Object)this, (Object)this, soip, mockUserInfoRequest));
        callSiteArray[103].call((Object)logger, msg);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = msg;
            valueRecorder.record(object, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object, (Object)"Unable to extract identity from the UserInfo token using the claim 'username'.");
            valueRecorder.record((Object)matcher, 12);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert msg =~ \"Unable to extract identity from the UserInfo token using the claim 'username'.\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testLookupIdentityUserInfoShouldHandle500() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Reference soip = new Reference((Object)((StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNiFiProperties), StandardOidcIdentityProvider.class)));
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callConstructor(Issuer.class, (Object)"https://localhost/oidc"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[108].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)((StandardOidcIdentityProvider)soip.get()), (String)"oidcProviderMetadata");
        Map errorBody = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"error", "Failure to authenticate", "error_description", "The provided username and password were not correct", "error_uri", "https://localhost/oidc/error"});
        Reference mockUserInfoRequest = new Reference((Object)((HTTPRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)errorBody, (Object)500, (Object)"HTTP ERROR"), HTTPRequest.class)));
        public final class _testLookupIdentityUserInfoShouldHandle500_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soip;
            private /* synthetic */ Reference mockUserInfoRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testLookupIdentityUserInfoShouldHandle500_closure4(Object _outerInstance, Object _thisObject, Reference soip, Reference mockUserInfoRequest) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soip = reference2 = soip;
                this.mockUserInfoRequest = reference = mockUserInfoRequest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$getCallSiteArray();
                String identity = ShortTypeHandling.castToString((Object)callSiteArray[0].call(this.soip.get(), this.mockUserInfoRequest.get()));
                return callSiteArray[1].call(ScriptBytecodeAdapter.getField(_testLookupIdentityUserInfoShouldHandle500_closure4.class, StandardOidcIdentityProviderGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{identity}, new String[]{"Identity: ", ""}));
            }

            @Generated
            public StandardOidcIdentityProvider getSoip() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$getCallSiteArray();
                return (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)this.soip.get(), StandardOidcIdentityProvider.class);
            }

            @Generated
            public HTTPRequest getMockUserInfoRequest() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$getCallSiteArray();
                return (HTTPRequest)ScriptBytecodeAdapter.castToType((Object)this.mockUserInfoRequest.get(), HTTPRequest.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testLookupIdentityUserInfoShouldHandle500_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "lookupIdentityInUserInfo";
                stringArray[1] = "info";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testLookupIdentityUserInfoShouldHandle500_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testLookupIdentityUserInfoShouldHandle500_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testLookupIdentityUserInfoShouldHandle500_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[110].callCurrent((GroovyObject)this, RuntimeException.class, (Object)new _testLookupIdentityUserInfoShouldHandle500_closure4((Object)this, (Object)this, soip, mockUserInfoRequest));
        callSiteArray[111].call((Object)logger, msg);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = msg;
            valueRecorder.record(object, 8);
            Object object2 = callSiteArray[112].call((Object)"An error occurred while invoking the UserInfo endpoint: The provided username and password ", (Object)"were not correct");
            valueRecorder.record(object2, 109);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object, (Object)object2);
            valueRecorder.record((Object)matcher, 12);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert msg =~ \"An error occurred while invoking the UserInfo endpoint: The provided username and password \" + \"were not correct\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldConvertOIDCTokenToLoginAuthenticationToken() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getOidcClaimIdentifyingUser", "email"})), StandardOidcIdentityProvider.class);
        OIDCTokenResponse mockResponse = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[114].callCurrent((GroovyObject)this);
            mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)object, OIDCTokenResponse.class);
        } else {
            OIDCTokenResponse oIDCTokenResponse;
            mockResponse = oIDCTokenResponse = this.mockOIDCTokenResponse();
        }
        callSiteArray[115].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[116].call((Object)mockResponse)}, new String[]{"OIDC Token Response: ", ""}));
        String loginToken = ShortTypeHandling.castToString((Object)callSiteArray[117].call((Object)soip, (Object)mockResponse));
        callSiteArray[118].call((Object)logger, (Object)new GStringImpl(new Object[]{loginToken}, new String[]{"Login Authentication token: ", ""}));
        Object object = callSiteArray[119].call((Object)loginToken, (Object)"\\[\\]");
        String contents = ShortTypeHandling.castToString((Object)callSiteArray[120].call(object, (Object)0));
        String expiration = ShortTypeHandling.castToString((Object)callSiteArray[121].call(object, (Object)1));
        callSiteArray[122].call((Object)logger, (Object)new GStringImpl(new Object[]{contents, expiration}, new String[]{"Token contents: ", " | Expiration: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = contents;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"LoginAuthenticationToken for person@nifi\\.apache\\.org issued by https://accounts\\.issuer\\.com expiring at");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert contents =~ \"LoginAuthenticationToken for person@nifi\\\\.apache\\\\.org issued by https://accounts\\\\.issuer\\\\.com expiring at\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Object[] expList = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)expiration, (Object)"\\s"), String[].class);
        Long expLong = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[124].call(Long.class, callSiteArray[125].call((Object)expList, (Object)0));
            expLong = (Long)ScriptBytecodeAdapter.castToType((Object)object2, Long.class);
        } else {
            Object object3 = callSiteArray[126].call(Long.class, BytecodeInterface8.objectArrayGet((Object[])expList, (int)0));
            expLong = (Long)ScriptBytecodeAdapter.castToType((Object)object3, Long.class);
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Long l = expLong;
            valueRecorder2.record((Object)l, 8);
            CallSite callSite = callSiteArray[127];
            Object object4 = callSiteArray[128].call(System.class);
            valueRecorder2.record(object4, 26);
            Object object5 = callSite.call(object4, (Object)10000);
            valueRecorder2.record(object5, 46);
            boolean bl = ScriptBytecodeAdapter.compareLessThanEqual((Object)l, (Object)object5);
            valueRecorder2.record((Object)bl, 16);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert expLong <= System.currentTimeMillis() + 10_000", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Test
    public void testConvertOIDCTokenToLoginAuthenticationTokenShouldHandleBlankIdentity() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getOidcClaimIdentifyingUser", "non-existent-claim"})), StandardOidcIdentityProvider.class);
        OIDCTokenResponse mockResponse = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[130].callCurrent((GroovyObject)this);
            mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)object, OIDCTokenResponse.class);
        } else {
            OIDCTokenResponse oIDCTokenResponse;
            mockResponse = oIDCTokenResponse = this.mockOIDCTokenResponse();
        }
        callSiteArray[131].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[132].call((Object)mockResponse)}, new String[]{"OIDC Token Response: ", ""}));
        String loginToken = ShortTypeHandling.castToString((Object)callSiteArray[133].call((Object)soip, (Object)mockResponse));
        callSiteArray[134].call((Object)logger, (Object)new GStringImpl(new Object[]{loginToken}, new String[]{"Login Authentication token: ", ""}));
        Object object = callSiteArray[135].call((Object)loginToken, (Object)"\\[\\]");
        String contents = ShortTypeHandling.castToString((Object)callSiteArray[136].call(object, (Object)0));
        String expiration = ShortTypeHandling.castToString((Object)callSiteArray[137].call(object, (Object)1));
        callSiteArray[138].call((Object)logger, (Object)new GStringImpl(new Object[]{contents, expiration}, new String[]{"Token contents: ", " | Expiration: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = contents;
            valueRecorder.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"LoginAuthenticationToken for person@nifi\\.apache\\.org issued by https://accounts\\.issuer\\.com expiring at");
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert contents =~ \"LoginAuthenticationToken for person@nifi\\\\.apache\\\\.org issued by https://accounts\\\\.issuer\\\\.com expiring at\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ArrayList expires = (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].call((Object)expiration, (Object)"[\\D*]"), ArrayList.class);
        long exp = DefaultTypeTransformation.longUnbox((Object)callSiteArray[140].call(Long.class, callSiteArray[141].call((Object)expires, (Object)0)));
        callSiteArray[142].call((Object)logger, (Object)new GStringImpl(new Object[]{exp}, new String[]{"exp: ", " ms"}));
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            long l = exp;
            valueRecorder2.record((Object)l, 8);
            Long l2 = l;
            CallSite callSite = callSiteArray[143];
            Object object2 = callSiteArray[144].call(System.class);
            valueRecorder2.record(object2, 22);
            Object object3 = callSite.call(object2, (Object)10000);
            valueRecorder2.record(object3, 42);
            boolean bl = ScriptBytecodeAdapter.compareLessThanEqual((Object)l2, (Object)object3);
            valueRecorder2.record((Object)bl, 12);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert exp <= System.currentTimeMillis() + 10_000", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Test
    public void testConvertOIDCTokenToLoginAuthenticationTokenShouldHandleNoEmailClaimHasFallbackClaims() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"nifi.security.user.oidc.claim.identifying.user", "email", "nifi.security.user.oidc.fallback.claims.identifying.user", "upn"})), StandardOidcIdentityProvider.class);
        String expectedUpn = "xxx@aaddomain";
        OIDCTokenResponse mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"email", null, "upn", expectedUpn})), OIDCTokenResponse.class);
        callSiteArray[147].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[148].call((Object)mockResponse)}, new String[]{"OIDC Token Response with no email and upn: ", ""}));
        String loginToken = ShortTypeHandling.castToString((Object)callSiteArray[149].call((Object)soip, (Object)mockResponse));
        callSiteArray[150].call((Object)logger, (Object)new GStringImpl(new Object[]{loginToken}, new String[]{"NiFi token create with upn: ", ""}));
        Object object = callSiteArray[151].call((Object)loginToken, (Object)"\\[\\]");
        String contents = ShortTypeHandling.castToString((Object)callSiteArray[152].call(object, (Object)0));
        String expiration = ShortTypeHandling.castToString((Object)callSiteArray[153].call(object, (Object)1));
        callSiteArray[154].call((Object)logger, (Object)new GStringImpl(new Object[]{contents, expiration}, new String[]{"Token contents: ", " | Expiration: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = contents;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[1];
            String string2 = expectedUpn;
            valueRecorder.record((Object)string2, 52);
            objectArray[0] = string2;
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)new GStringImpl(objectArray, new String[]{"LoginAuthenticationToken for ", " issued by https://accounts\\.issuer\\.com expiring at"}));
            valueRecorder.record((Object)matcher, 17);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert contents =~ \"LoginAuthenticationToken for ${expectedUpn} issued by https://accounts\\\\.issuer\\\\.com expiring at\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Reference soip = new Reference((Object)((StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getOidcClaimIdentifyingUser", "non-existent-claim", "getOidcFallbackClaimsIdentifyingUser", ScriptBytecodeAdapter.createList((Object[])new Object[0])})), StandardOidcIdentityProvider.class)));
        Reference mockResponse = new Reference((Object)((OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[156].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"email", null})), OIDCTokenResponse.class)));
        callSiteArray[157].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[158].call((Object)((OIDCTokenResponse)mockResponse.get()))}, new String[]{"OIDC Token Response: ", ""}));
        public final class _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soip;
            private /* synthetic */ Reference mockResponse;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5(Object _outerInstance, Object _thisObject, Reference soip, Reference mockResponse) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soip = reference2 = soip;
                this.mockResponse = reference = mockResponse;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$getCallSiteArray();
                String loginAuthenticationToken = ShortTypeHandling.castToString((Object)callSiteArray[0].call(this.soip.get(), this.mockResponse.get()));
                return callSiteArray[1].call(ScriptBytecodeAdapter.getField(_testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.class, StandardOidcIdentityProviderGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{loginAuthenticationToken}, new String[]{"Login authentication token: ", ""}));
            }

            @Generated
            public StandardOidcIdentityProvider getSoip() {
                CallSite[] callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$getCallSiteArray();
                return (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)this.soip.get(), StandardOidcIdentityProvider.class);
            }

            @Generated
            public OIDCTokenResponse getMockResponse() {
                CallSite[] callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$getCallSiteArray();
                return (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)this.mockResponse.get(), OIDCTokenResponse.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "convertOIDCTokenToLoginAuthenticationToken";
                stringArray[1] = "info";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[159].callCurrent((GroovyObject)this, IOException.class, (Object)new _testConvertOIDCTokenToLoginAuthNTokenShouldHandleBlankIdentityAndNoEmailClaim_closure5((Object)this, (Object)this, soip, mockResponse));
        callSiteArray[160].call((Object)logger, msg);
    }

    @Test
    public void testShouldAuthorizeClientRequest() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), StandardOidcIdentityProvider.class);
        Map responseBody = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id_token", MOCK_JWT, "access_token", "some.access.token", "refresh_token", "some.refresh.token", "token_type", "bearer"});
        HTTPRequest mockTokenRequest = (HTTPRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)responseBody, (Object)200, (Object)"HTTP OK"), HTTPRequest.class);
        Object tokenResponse = callSiteArray[163].call((Object)soip, (Object)mockTokenRequest);
        callSiteArray[164].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[165].call(tokenResponse)}, new String[]{"Token Response: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenResponse;
            valueRecorder.record(object, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenResponse", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testAuthorizeClientRequestShouldHandleError() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Reference soip = new Reference((Object)((StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), StandardOidcIdentityProvider.class)));
        Map responseBody = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id_token", MOCK_JWT, "access_token", "some.access.token", "refresh_token", "some.refresh.token", "token_type", "bearer"});
        Reference mockTokenRequest = new Reference((Object)((HTTPRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)responseBody, (Object)500, (Object)"HTTP SERVER ERROR"), HTTPRequest.class)));
        public final class _testAuthorizeClientRequestShouldHandleError_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soip;
            private /* synthetic */ Reference mockTokenRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testAuthorizeClientRequestShouldHandleError_closure6(Object _outerInstance, Object _thisObject, Reference soip, Reference mockTokenRequest) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soip = reference2 = soip;
                this.mockTokenRequest = reference = mockTokenRequest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$getCallSiteArray();
                Object nifiToken = callSiteArray[0].call(this.soip.get(), this.mockTokenRequest.get());
                return callSiteArray[1].call(ScriptBytecodeAdapter.getField(_testAuthorizeClientRequestShouldHandleError_closure6.class, StandardOidcIdentityProviderGroovyTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{nifiToken}, new String[]{"NiFi token: ", ""}));
            }

            @Generated
            public StandardOidcIdentityProvider getSoip() {
                CallSite[] callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$getCallSiteArray();
                return (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)this.soip.get(), StandardOidcIdentityProvider.class);
            }

            @Generated
            public HTTPRequest getMockTokenRequest() {
                CallSite[] callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$getCallSiteArray();
                return (HTTPRequest)ScriptBytecodeAdapter.castToType((Object)this.mockTokenRequest.get(), HTTPRequest.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testAuthorizeClientRequestShouldHandleError_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "authorizeClientRequest";
                stringArray[1] = "info";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testAuthorizeClientRequestShouldHandleError_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testAuthorizeClientRequestShouldHandleError_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testAuthorizeClientRequestShouldHandleError_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[168].callCurrent((GroovyObject)this, RuntimeException.class, (Object)new _testAuthorizeClientRequestShouldHandleError_closure6((Object)this, (Object)this, soip, mockTokenRequest));
        callSiteArray[169].call((Object)logger, msg);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = msg;
            valueRecorder.record(object, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object, (Object)"An error occurred while invoking the Token endpoint: null");
            valueRecorder.record((Object)matcher, 12);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert msg =~ \"An error occurred while invoking the Token endpoint: null\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldGetAccessTokenString() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[170].callCurrent((GroovyObject)this);
            soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider;
            soip = standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
        }
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callConstructor(BearerAccessToken.class), AccessToken.class);
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(RefreshToken.class), RefreshToken.class);
        JWSAlgorithm jwsAlgorithm = (JWSAlgorithm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[173].callGetProperty(JWSAlgorithm.class), JWSAlgorithm.class);
        AccessTokenHash EXPECTED_HASH = (AccessTokenHash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].call(AccessTokenHash.class, (Object)mockAccessToken, (Object)jwsAlgorithm), AccessTokenHash.class);
        callSiteArray[175].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_HASH}, new String[]{"Expected at_hash: ", ""}));
        Map mockClaims = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"at_hash", callSiteArray[176].call((Object)EXPECTED_HASH)});
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].callConstructor(JWTClaimsSet.class, (Object)mockClaims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        OIDCTokens mockOidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class);
        OIDCTokenResponse mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].callConstructor(OIDCTokenResponse.class, (Object)mockOidcTokens), OIDCTokenResponse.class);
        String accessTokenString = ShortTypeHandling.castToString((Object)callSiteArray[181].call((Object)soip, (Object)mockResponse));
        callSiteArray[182].call((Object)logger, (Object)new GStringImpl(new Object[]{accessTokenString}, new String[]{"Access token: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = accessTokenString;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert accessTokenString", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldValidateAccessToken() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[183].callCurrent((GroovyObject)this);
            soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider;
            soip = standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
        }
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(BearerAccessToken.class), AccessToken.class);
        callSiteArray[185].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[186].call((Object)mockAccessToken)}, new String[]{"mock access token: ", ""}));
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[187].callConstructor(RefreshToken.class), RefreshToken.class);
        JWSAlgorithm jwsAlgorithm = (JWSAlgorithm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].callGetProperty(JWSAlgorithm.class), JWSAlgorithm.class);
        AccessTokenHash EXPECTED_HASH = (AccessTokenHash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[189].call(AccessTokenHash.class, (Object)mockAccessToken, (Object)jwsAlgorithm), AccessTokenHash.class);
        callSiteArray[190].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_HASH}, new String[]{"Expected at_hash: ", ""}));
        Map claims = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].callStatic(StandardOidcIdentityProviderGroovyTest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"at_hash", callSiteArray[192].call((Object)EXPECTED_HASH)})), Map.class);
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[194].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        OIDCTokens mockOidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[195].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class);
        callSiteArray[196].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[197].callGetProperty(callSiteArray[198].call((Object)mockOidcTokens))}, new String[]{"mock id tokens: ", ""}));
        String accessTokenString = ShortTypeHandling.castToString((Object)callSiteArray[199].call((Object)soip, (Object)mockOidcTokens));
        callSiteArray[200].call((Object)logger, (Object)new GStringImpl(new Object[]{accessTokenString}, new String[]{"Access Token: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = accessTokenString;
            valueRecorder.record((Object)string, 8);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, null);
            valueRecorder.record((Object)bl, 26);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert accessTokenString == null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testValidateAccessTokenShouldHandleMismatchedATHash() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Reference soip = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[201].callCurrent((GroovyObject)this);
            soip.set((Object)((StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class)));
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
            soip.set((Object)standardOidcIdentityProvider);
        }
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callConstructor(BearerAccessToken.class), AccessToken.class);
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callConstructor(RefreshToken.class), RefreshToken.class);
        JWSAlgorithm jwsAlgorithm = (JWSAlgorithm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].callGetProperty(JWSAlgorithm.class), JWSAlgorithm.class);
        AccessTokenHash expectedHash = (AccessTokenHash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].call(AccessTokenHash.class, (Object)mockAccessToken, (Object)jwsAlgorithm), AccessTokenHash.class);
        callSiteArray[206].call((Object)logger, (Object)new GStringImpl(new Object[]{expectedHash}, new String[]{"Expected at_hash: ", ""}));
        Map claims = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[207].callStatic(StandardOidcIdentityProviderGroovyTest.class);
            claims = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            claims = map = StandardOidcIdentityProviderGroovyTest.mockClaims();
        }
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[208].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        Reference mockOidcTokens = new Reference((Object)((OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class)));
        public final class _testValidateAccessTokenShouldHandleMismatchedATHash_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soip;
            private /* synthetic */ Reference mockOidcTokens;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testValidateAccessTokenShouldHandleMismatchedATHash_closure7(Object _outerInstance, Object _thisObject, Reference soip, Reference mockOidcTokens) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soip = reference2 = soip;
                this.mockOidcTokens = reference = mockOidcTokens;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$getCallSiteArray();
                return callSiteArray[0].call(this.soip.get(), this.mockOidcTokens.get());
            }

            @Generated
            public StandardOidcIdentityProvider getSoip() {
                CallSite[] callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$getCallSiteArray();
                return (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)this.soip.get(), StandardOidcIdentityProvider.class);
            }

            @Generated
            public OIDCTokens getMockOidcTokens() {
                CallSite[] callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$getCallSiteArray();
                return (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)this.mockOidcTokens.get(), OIDCTokens.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "validateAccessToken";
                return new CallSiteArray(_testValidateAccessTokenShouldHandleMismatchedATHash_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testValidateAccessTokenShouldHandleMismatchedATHash_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[211].callCurrent((GroovyObject)this, Exception.class, (Object)new _testValidateAccessTokenShouldHandleMismatchedATHash_closure7((Object)this, (Object)this, soip, mockOidcTokens));
        callSiteArray[212].call((Object)logger, msg);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = msg;
            valueRecorder.record(object, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object, (Object)"Unable to validate the Access Token: Access token hash \\(at_hash\\) mismatch");
            valueRecorder.record((Object)matcher, 12);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert msg =~ \"Unable to validate the Access Token: Access token hash \\\\(at_hash\\\\) mismatch\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldGetIdTokenString() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[213].callCurrent((GroovyObject)this);
            soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider;
            soip = standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
        }
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[214].callConstructor(BearerAccessToken.class), AccessToken.class);
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].callConstructor(RefreshToken.class), RefreshToken.class);
        Map claims = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[216].callStatic(StandardOidcIdentityProviderGroovyTest.class);
            claims = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            claims = map = StandardOidcIdentityProviderGroovyTest.mockClaims();
        }
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[217].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        OIDCTokens mockOidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[219].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class);
        String EXPECTED_ID_TOKEN = ShortTypeHandling.castToString((Object)callSiteArray[220].call((Object)mockOidcTokens));
        callSiteArray[221].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_ID_TOKEN}, new String[]{"EXPECTED_ID_TOKEN: ", ""}));
        OIDCTokenResponse mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].callConstructor(OIDCTokenResponse.class, (Object)mockOidcTokens), OIDCTokenResponse.class);
        String idTokenString = ShortTypeHandling.castToString((Object)callSiteArray[223].call((Object)soip, (Object)mockResponse));
        callSiteArray[224].call((Object)logger, (Object)new GStringImpl(new Object[]{idTokenString}, new String[]{"ID Token: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = idTokenString;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert idTokenString", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = idTokenString;
            valueRecorder2.record((Object)string, 8);
            String string2 = EXPECTED_ID_TOKEN;
            valueRecorder2.record((Object)string2, 25);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder2.record((Object)bl, 22);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert idTokenString == EXPECTED_ID_TOKEN", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        Object object = callSiteArray[225].call((Object)idTokenString, (Object)"\\.");
        String header = ShortTypeHandling.castToString((Object)callSiteArray[226].call(object, (Object)0));
        String payload = ShortTypeHandling.castToString((Object)callSiteArray[227].call(object, (Object)1));
        byte[] idTokenBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[228].call(Base64.class, (Object)payload), byte[].class);
        String payloadString = ShortTypeHandling.castToString((Object)callSiteArray[229].callConstructor(String.class, (Object)idTokenBytes, (Object)"UTF-8"));
        callSiteArray[230].call((Object)logger, (Object)payloadString);
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            String string = payloadString;
            valueRecorder3.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"\"email\":\"person@nifi\\.apache\\.org\"");
            valueRecorder3.record((Object)matcher, 22);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert payloadString =~ \"\\\"email\\\":\\\"person@nifi\\\\.apache\\\\.org\\\"\"", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldValidateIdToken() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[231].callCurrent((GroovyObject)this);
            soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider;
            soip = standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
        }
        Map claims = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[232].callStatic(StandardOidcIdentityProviderGroovyTest.class);
            claims = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            claims = map = StandardOidcIdentityProviderGroovyTest.mockClaims();
        }
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[233].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[234].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        IDTokenClaimsSet claimsSet = (IDTokenClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[235].call((Object)soip, (Object)mockJwt), IDTokenClaimsSet.class);
        String claimsSetString = ShortTypeHandling.castToString((Object)callSiteArray[236].call(callSiteArray[237].call((Object)claimsSet)));
        callSiteArray[238].call((Object)logger, (Object)new GStringImpl(new Object[]{claimsSetString}, new String[]{"ID Token Claims Set: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            IDTokenClaimsSet iDTokenClaimsSet = claimsSet;
            valueRecorder.record((Object)iDTokenClaimsSet, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)iDTokenClaimsSet)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert claimsSet", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = claimsSetString;
            valueRecorder2.record((Object)string, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)string, (Object)"\"email\":\"person@nifi\\.apache\\.org\"");
            valueRecorder2.record((Object)matcher, 24);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert claimsSetString =~ \"\\\"email\\\":\\\"person@nifi\\\\.apache\\\\.org\\\"\"", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldGetOidcTokens() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        StandardOidcIdentityProvider soip = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[239].callCurrent((GroovyObject)this);
            soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)object, StandardOidcIdentityProvider.class);
        } else {
            StandardOidcIdentityProvider standardOidcIdentityProvider;
            soip = standardOidcIdentityProvider = this.buildIdentityProviderWithMockTokenValidator();
        }
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].callConstructor(BearerAccessToken.class), AccessToken.class);
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].callConstructor(RefreshToken.class), RefreshToken.class);
        Map claims = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[242].callStatic(StandardOidcIdentityProviderGroovyTest.class);
            claims = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            claims = map = StandardOidcIdentityProviderGroovyTest.mockClaims();
        }
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[243].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        OIDCTokens mockOidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[245].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class);
        String EXPECTED_ID_TOKEN = ShortTypeHandling.castToString((Object)callSiteArray[246].call((Object)mockOidcTokens));
        callSiteArray[247].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_ID_TOKEN}, new String[]{"EXPECTED_ID_TOKEN: ", ""}));
        OIDCTokenResponse mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[248].callConstructor(OIDCTokenResponse.class, (Object)mockOidcTokens), OIDCTokenResponse.class);
        OIDCTokens oidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[249].call((Object)soip, (Object)mockResponse), OIDCTokens.class);
        callSiteArray[250].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[251].call((Object)oidcTokens)}, new String[]{"OIDC Tokens: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            OIDCTokens oIDCTokens = oidcTokens;
            valueRecorder.record((Object)oIDCTokens, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)oIDCTokens)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert oidcTokens", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        JSONObject oidcJson = (JSONObject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].call((Object)oidcTokens), JSONObject.class);
        String idToken = ShortTypeHandling.castToString((Object)callSiteArray[253].call((Object)oidcJson, (Object)"id_token"));
        callSiteArray[254].call((Object)logger, (Object)new GStringImpl(new Object[]{idToken}, new String[]{"ID Token String: ", ""}));
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = idToken;
            valueRecorder2.record((Object)string, 8);
            String string2 = EXPECTED_ID_TOKEN;
            valueRecorder2.record((Object)string2, 19);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder2.record((Object)bl, 16);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert idToken == EXPECTED_ID_TOKEN", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    private StandardOidcIdentityProvider buildIdentityProviderWithMockTokenValidator(Map<String, String> additionalProperties) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        NiFiProperties mockNFP = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].callStatic(StandardOidcIdentityProviderGroovyTest.class, additionalProperties), NiFiProperties.class);
        StandardOidcIdentityProvider soip = (StandardOidcIdentityProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].callConstructor(StandardOidcIdentityProvider.class, (Object)mockNFP), StandardOidcIdentityProvider.class);
        Issuer mockIssuer = (Issuer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[257].callConstructor(Issuer.class, (Object)"mockIssuer"), Issuer.class);
        URI mockURI = (URI)ScriptBytecodeAdapter.castToType((Object)callSiteArray[258].callConstructor(URI.class, (Object)"https://localhost/oidc"), URI.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[259].callConstructor(OIDCProviderMetadata.class, (Object)mockIssuer, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[260].callGetProperty(SubjectType.class)}), (Object)mockURI), OIDCProviderMetadata.class);
        OIDCProviderMetadata oIDCProviderMetadata = metadata;
        ScriptBytecodeAdapter.setProperty((Object)oIDCProviderMetadata, null, (Object)soip, (String)"oidcProviderMetadata");
        ClientID CLIENT_ID = (ClientID)ScriptBytecodeAdapter.castToType((Object)callSiteArray[261].callConstructor(ClientID.class, (Object)"expected_client_id"), ClientID.class);
        Secret CLIENT_SECRET = (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[262].callConstructor(Secret.class, (Object)"expected_client_secret"), Secret.class);
        ClientID clientID = CLIENT_ID;
        ScriptBytecodeAdapter.setProperty((Object)clientID, null, (Object)soip, (String)"clientId");
        Secret secret = CLIENT_SECRET;
        ScriptBytecodeAdapter.setProperty((Object)secret, null, (Object)soip, (String)"clientSecret");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[263].callGetProperty(ClientAuthenticationMethod.class)});
        callSiteArray[264].call(callSiteArray[265].callGetProperty((Object)soip), (Object)"tokenEndpointAuthMethods", (Object)list);
        Object object = callSiteArray[266].callConstructor(URI.class, (Object)"https://localhost/oidc/token");
        callSiteArray[267].call(callSiteArray[268].callGetProperty((Object)soip), (Object)"tokenEndpointURI", object);
        Object object2 = callSiteArray[269].callConstructor(URI.class, (Object)"https://localhost/oidc/userInfo");
        callSiteArray[270].call(callSiteArray[271].callGetProperty((Object)soip), (Object)"userInfoEndpointURI", object2);
        GroovyObject mockTokenValidator = new GroovyObject(this, mockIssuer, CLIENT_ID){
            final /* synthetic */ StandardOidcIdentityProviderGroovyTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                StandardOidcIdentityProviderGroovyTest standardOidcIdentityProviderGroovyTest;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = standardOidcIdentityProviderGroovyTest = p0;
                super((Issuer)ScriptBytecodeAdapter.castToType((Object)p10, Issuer.class), (ClientID)ScriptBytecodeAdapter.castToType((Object)p11, ClientID.class));
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public IDTokenClaimsSet validate(JWT jwt, Nonce nonce) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (IDTokenClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(IDTokenClaimsSet.class, callSiteArray[1].call((Object)jwt)), IDTokenClaimsSet.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$4(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$4(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$4(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ IDTokenClaimsSet super$3$validate(JWT jWT, Nonce nonce) {
                return super.validate(jWT, nonce);
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "getJWTClaimsSet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        GroovyObject groovyObject = mockTokenValidator;
        ScriptBytecodeAdapter.setProperty((Object)groovyObject, null, (Object)soip, (String)"tokenValidator");
        return soip;
    }

    private OIDCTokenResponse mockOIDCTokenResponse(Map<String, Object> additionalClaims) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Map claims = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[272].callStatic(StandardOidcIdentityProviderGroovyTest.class, additionalClaims), Map.class);
        JWTClaimsSet mockJWTClaimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[273].callConstructor(JWTClaimsSet.class, (Object)claims), JWTClaimsSet.class);
        JWT mockJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].callConstructor(PlainJWT.class, (Object)mockJWTClaimsSet), JWT.class);
        AccessToken mockAccessToken = (AccessToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[275].callConstructor(BearerAccessToken.class), AccessToken.class);
        RefreshToken mockRefreshToken = (RefreshToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[276].callConstructor(RefreshToken.class), RefreshToken.class);
        OIDCTokens mockOidcTokens = (OIDCTokens)ScriptBytecodeAdapter.castToType((Object)callSiteArray[277].callConstructor(OIDCTokens.class, (Object)mockJwt, (Object)mockAccessToken, (Object)mockRefreshToken), OIDCTokens.class);
        OIDCTokenResponse mockResponse = (OIDCTokenResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[278].callConstructor(OIDCTokenResponse.class, (Object)mockOidcTokens), OIDCTokenResponse.class);
        return mockResponse;
    }

    private static Map<String, Object> mockClaims(Map<String, Object> additionalClaims) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Map claims = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"iss", "https://accounts.issuer.com", "azp", "1013352044499-05pb1ssdfuihsdfsdsdfdi8r2vike88m.apps.usercontent.com", "aud", "1013352044499-05pb1ssdfuihsdfsdsdfdi8r2vike88m.apps.usercontent.com", "sub", "10703475345439756345540", "email", "person@nifi.apache.org", "email_verified", "true", "at_hash", "JOGISUDHFiyGHDSFwV5Fah2A", "iat", 1590022674, "exp", 1590026274}), additionalClaims), Map.class);
        return claims;
    }

    /*
     * WARNING - void declaration
     */
    private static HTTPRequest mockHttpRequest(Object body, int statusCode, String status, Map<String, String> headers, HTTPRequest.Method method, URL url) {
        void var3_3;
        void var2_2;
        Reference body2 = new Reference(body);
        Reference statusCode2 = new Reference((Object)statusCode);
        Reference status2 = new Reference((Object)var2_2);
        Reference headers2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return new GroovyObject(statusCode2, status2, headers2, body2, method, url){
            public /* synthetic */ Reference body;
            public /* synthetic */ Reference headers;
            public /* synthetic */ Reference status;
            public /* synthetic */ Reference statusCode;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                this.statusCode = reference4 = p0;
                this.status = reference3 = p1;
                this.headers = reference2 = p2;
                this.body = reference = p3;
                Object[] objectArray = new Object[]{p40, p41};
                2 v1 = this;
                switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, HTTPRequest.class)) {
                    case -1668429586: {
                        Object[] objectArray2 = objectArray;
                        super((HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)objectArray[0], HTTPRequest.Method.class), (URI)ScriptBytecodeAdapter.castToType((Object)objectArray[1], URI.class));
                        break;
                    }
                    case -1668340213: {
                        Object[] objectArray2 = objectArray;
                        super((HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)objectArray[0], HTTPRequest.Method.class), (URL)ScriptBytecodeAdapter.castToType((Object)objectArray[1], URL.class));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                    }
                }
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public HTTPResponse send() {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                Reference mockResponse = new Reference((Object)((HTTPResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(HTTPResponse.class, this.statusCode.get()), HTTPResponse.class)));
                callSiteArray[1].call((Object)((HTTPResponse)mockResponse.get()), this.status.get());
                public final class _send_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference mockResponse;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _send_closure1(Object _outerInstance, Object _thisObject, Reference mockResponse) {
                        Reference reference;
                        CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.mockResponse = reference = mockResponse;
                    }

                    public Object doCall(String h, String v) {
                        CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                        return callSiteArray[0].call(this.mockResponse.get(), (Object)h, (Object)v);
                    }

                    @Generated
                    public Object call(String h, String v) {
                        CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[1].callCurrent((GroovyObject)this, (Object)h, (Object)v);
                        }
                        return this.doCall(h, v);
                    }

                    @Generated
                    public HTTPResponse getMockResponse() {
                        CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                        return (HTTPResponse)ScriptBytecodeAdapter.castToType((Object)this.mockResponse.get(), HTTPResponse.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _send_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "setHeader";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _send_closure1.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_send_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _send_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[2].call(callSiteArray[3].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Content-Type", "application/json"}), this.headers.get()), (Object)new _send_closure1((Object)this, (Object)this, mockResponse));
                Object responseBody = this.body.get();
                callSiteArray[4].call((Object)((HTTPResponse)mockResponse.get()), callSiteArray[5].call(JsonOutput.class, responseBody));
                return (HTTPResponse)mockResponse.get();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(2.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(2.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(2.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(2.class, StandardOidcIdentityProviderGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ HTTPResponse super$3$send() {
                return super.send();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "setStatusMessage";
                stringArray[2] = "each";
                stringArray[3] = "plus";
                stringArray[4] = "setContent";
                stringArray[5] = "toJson";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StandardOidcIdentityProviderGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, StandardOidcIdentityProviderGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(StandardOidcIdentityProviderGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    private static NiFiProperties buildNiFiProperties() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.buildNiFiProperties(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    private StandardOidcIdentityProvider buildIdentityProviderWithMockTokenValidator() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return this.buildIdentityProviderWithMockTokenValidator(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    private OIDCTokenResponse mockOIDCTokenResponse() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return this.mockOIDCTokenResponse(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    private static Map<String, Object> mockClaims() {
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockClaims(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    private static HTTPRequest mockHttpRequest(Object body, int statusCode, String status, Map<String, String> headers, HTTPRequest.Method method) {
        void var3_3;
        void var2_2;
        Reference body2 = new Reference(body);
        Reference statusCode2 = new Reference((Object)statusCode);
        Reference status2 = new Reference((Object)var2_2);
        Reference headers2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockHttpRequest(body2.get(), DefaultTypeTransformation.intUnbox((Object)statusCode2.get()), (String)status2.get(), (Map)headers2.get(), method, (URL)callSiteArray[280].callConstructor(URL.class, (Object)"https://localhost/oidc"));
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    private static HTTPRequest mockHttpRequest(Object body, int statusCode, String status, Map<String, String> headers) {
        void var3_3;
        void var2_2;
        Reference body2 = new Reference(body);
        Reference statusCode2 = new Reference((Object)statusCode);
        Reference status2 = new Reference((Object)var2_2);
        Reference headers2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockHttpRequest(body2.get(), DefaultTypeTransformation.intUnbox((Object)statusCode2.get()), (String)status2.get(), (Map)headers2.get(), (HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)callSiteArray[281].callGetProperty(HTTPRequest.Method.class), HTTPRequest.Method.class), (URL)callSiteArray[282].callConstructor(URL.class, (Object)"https://localhost/oidc"));
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    private static HTTPRequest mockHttpRequest(Object body, int statusCode, String status) {
        void var2_2;
        Reference body2 = new Reference(body);
        Reference statusCode2 = new Reference((Object)statusCode);
        Reference status2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockHttpRequest(body2.get(), DefaultTypeTransformation.intUnbox((Object)statusCode2.get()), (String)status2.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)callSiteArray[283].callGetProperty(HTTPRequest.Method.class), HTTPRequest.Method.class), (URL)callSiteArray[284].callConstructor(URL.class, (Object)"https://localhost/oidc"));
    }

    @Generated
    private static HTTPRequest mockHttpRequest(Object body, int statusCode) {
        Reference body2 = new Reference(body);
        Reference statusCode2 = new Reference((Object)statusCode);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockHttpRequest(body2.get(), DefaultTypeTransformation.intUnbox((Object)statusCode2.get()), "HTTP Response", ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)callSiteArray[285].callGetProperty(HTTPRequest.Method.class), HTTPRequest.Method.class), (URL)callSiteArray[286].callConstructor(URL.class, (Object)"https://localhost/oidc"));
    }

    @Generated
    private static HTTPRequest mockHttpRequest(Object body) {
        Reference body2 = new Reference(body);
        CallSite[] callSiteArray = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray();
        return StandardOidcIdentityProviderGroovyTest.mockHttpRequest(body2.get(), 200, "HTTP Response", ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (HTTPRequest.Method)ShortTypeHandling.castToEnum((Object)callSiteArray[287].callGetProperty(HTTPRequest.Method.class), HTTPRequest.Method.class), (URL)callSiteArray[288].callConstructor(URL.class, (Object)"https://localhost/oidc"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != StandardOidcIdentityProviderGroovyTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Map map;
        Object object = StandardOidcIdentityProviderGroovyTest.$getCallSiteArray()[289].call(LoggerFactory.class, StandardOidcIdentityProviderGroovyTest.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        DEFAULT_NIFI_PROPERTIES = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"nifi.security.user.oidc.discovery.url", "https://localhost/oidc", "nifi.security.user.login.identity.provider", "provider", "nifi.security.user.knox.url", "url", "nifi.security.user.oidc.connect.timeout", "1000", "nifi.security.user.oidc.read.timeout", "1000", "nifi.security.user.oidc.client.id", "expected_client_id", "nifi.security.user.oidc.client.secret", "expected_client_secret", "nifi.security.user.oidc.claim.identifying.user", "username", "nifi.security.user.oidc.preferred.jwsalgorithm", ""});
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "metaClass";
        stringArray[1] = "buildNiFiProperties";
        stringArray[2] = "plus";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "sort";
        stringArray[5] = "keySet";
        stringArray[6] = "findAll";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "getAvailableClaims";
        stringArray[9] = "info";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "PUBLIC";
        stringArray[15] = "CLIENT_SECRET_POST";
        stringArray[16] = "putAt";
        stringArray[17] = "oidcProviderMetadata";
        stringArray[18] = "getAt";
        stringArray[19] = "oidcProviderMetadata";
        stringArray[20] = "info";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "createClientAuthentication";
        stringArray[25] = "info";
        stringArray[26] = "getProperties";
        stringArray[27] = "getClientID";
        stringArray[28] = "getClientID";
        stringArray[29] = "info";
        stringArray[30] = "value";
        stringArray[31] = "clientSecret";
        stringArray[32] = "getClientSecret";
        stringArray[33] = "getClientSecret";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "PUBLIC";
        stringArray[39] = "CLIENT_SECRET_BASIC";
        stringArray[40] = "putAt";
        stringArray[41] = "oidcProviderMetadata";
        stringArray[42] = "getAt";
        stringArray[43] = "oidcProviderMetadata";
        stringArray[44] = "info";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "createClientAuthentication";
        stringArray[49] = "info";
        stringArray[50] = "properties";
        stringArray[51] = "getClientID";
        stringArray[52] = "getClientID";
        stringArray[53] = "getMethod";
        stringArray[54] = "getMethod";
        stringArray[55] = "info";
        stringArray[56] = "value";
        stringArray[57] = "clientSecret";
        stringArray[58] = "getClientSecret";
        stringArray[59] = "clientSecret";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "PUBLIC";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "CLIENT_SECRET_BASIC";
        stringArray[70] = "putAt";
        stringArray[71] = "oidcProviderMetadata";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "putAt";
        stringArray[74] = "oidcProviderMetadata";
        stringArray[75] = "createClientAuthentication";
        stringArray[76] = "createTokenHTTPRequest";
        stringArray[77] = "info";
        stringArray[78] = "dump";
        stringArray[79] = "info";
        stringArray[80] = "decode";
        stringArray[81] = "query";
        stringArray[82] = "name";
        stringArray[83] = "getMethod";
        stringArray[84] = "query";
        stringArray[85] = "value";
        stringArray[86] = "encode";
        stringArray[87] = "query";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "<$constructor$>";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "PUBLIC";
        stringArray[93] = "mockHttpRequest";
        stringArray[94] = "lookupIdentityInUserInfo";
        stringArray[95] = "info";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "PUBLIC";
        stringArray[101] = "mockHttpRequest";
        stringArray[102] = "shouldFail";
        stringArray[103] = "expected";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "PUBLIC";
        stringArray[109] = "mockHttpRequest";
        stringArray[110] = "shouldFail";
        stringArray[111] = "expected";
        stringArray[112] = "plus";
        stringArray[113] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[114] = "mockOIDCTokenResponse";
        stringArray[115] = "info";
        stringArray[116] = "dump";
        stringArray[117] = "convertOIDCTokenToLoginAuthenticationToken";
        stringArray[118] = "info";
        stringArray[119] = "tokenize";
        stringArray[120] = "getAt";
        stringArray[121] = "getAt";
        stringArray[122] = "info";
        stringArray[123] = "split";
        stringArray[124] = "parseLong";
        stringArray[125] = "getAt";
        stringArray[126] = "parseLong";
        stringArray[127] = "plus";
        stringArray[128] = "currentTimeMillis";
        stringArray[129] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[130] = "mockOIDCTokenResponse";
        stringArray[131] = "info";
        stringArray[132] = "dump";
        stringArray[133] = "convertOIDCTokenToLoginAuthenticationToken";
        stringArray[134] = "info";
        stringArray[135] = "tokenize";
        stringArray[136] = "getAt";
        stringArray[137] = "getAt";
        stringArray[138] = "info";
        stringArray[139] = "split";
        stringArray[140] = "parseLong";
        stringArray[141] = "getAt";
        stringArray[142] = "info";
        stringArray[143] = "plus";
        stringArray[144] = "currentTimeMillis";
        stringArray[145] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[146] = "mockOIDCTokenResponse";
        stringArray[147] = "info";
        stringArray[148] = "dump";
        stringArray[149] = "convertOIDCTokenToLoginAuthenticationToken";
        stringArray[150] = "info";
        stringArray[151] = "tokenize";
        stringArray[152] = "getAt";
        stringArray[153] = "getAt";
        stringArray[154] = "info";
        stringArray[155] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[156] = "mockOIDCTokenResponse";
        stringArray[157] = "info";
        stringArray[158] = "dump";
        stringArray[159] = "shouldFail";
        stringArray[160] = "expected";
        stringArray[161] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[162] = "mockHttpRequest";
        stringArray[163] = "authorizeClientRequest";
        stringArray[164] = "info";
        stringArray[165] = "dump";
        stringArray[166] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[167] = "mockHttpRequest";
        stringArray[168] = "shouldFail";
        stringArray[169] = "expected";
        stringArray[170] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "RS256";
        stringArray[174] = "compute";
        stringArray[175] = "info";
        stringArray[176] = "toString";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "<$constructor$>";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "getAccessTokenString";
        stringArray[182] = "info";
        stringArray[183] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "info";
        stringArray[186] = "toString";
        stringArray[187] = "<$constructor$>";
        stringArray[188] = "RS256";
        stringArray[189] = "compute";
        stringArray[190] = "info";
        stringArray[191] = "mockClaims";
        stringArray[192] = "toString";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "<$constructor$>";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "info";
        stringArray[197] = "properties";
        stringArray[198] = "getIDToken";
        stringArray[199] = "validateAccessToken";
        stringArray[200] = "info";
        stringArray[201] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "RS256";
        stringArray[205] = "compute";
        stringArray[206] = "info";
        stringArray[207] = "mockClaims";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "<$constructor$>";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "shouldFail";
        stringArray[212] = "expected";
        stringArray[213] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[214] = "<$constructor$>";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "mockClaims";
        stringArray[217] = "<$constructor$>";
        stringArray[218] = "<$constructor$>";
        stringArray[219] = "<$constructor$>";
        stringArray[220] = "getIDTokenString";
        stringArray[221] = "info";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "getIdTokenString";
        stringArray[224] = "info";
        stringArray[225] = "split";
        stringArray[226] = "getAt";
        stringArray[227] = "getAt";
        stringArray[228] = "decodeBase64";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "info";
        stringArray[231] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[232] = "mockClaims";
        stringArray[233] = "<$constructor$>";
        stringArray[234] = "<$constructor$>";
        stringArray[235] = "validateIdToken";
        stringArray[236] = "toString";
        stringArray[237] = "toJSONObject";
        stringArray[238] = "info";
        stringArray[239] = "buildIdentityProviderWithMockTokenValidator";
        stringArray[240] = "<$constructor$>";
        stringArray[241] = "<$constructor$>";
        stringArray[242] = "mockClaims";
        stringArray[243] = "<$constructor$>";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "<$constructor$>";
        stringArray[246] = "getIDTokenString";
        stringArray[247] = "info";
        stringArray[248] = "<$constructor$>";
        stringArray[249] = "getOidcTokens";
        stringArray[250] = "info";
        stringArray[251] = "toJSONObject";
        stringArray[252] = "toJSONObject";
        stringArray[253] = "getAt";
        stringArray[254] = "info";
        stringArray[255] = "buildNiFiProperties";
        stringArray[256] = "<$constructor$>";
        stringArray[257] = "<$constructor$>";
        stringArray[258] = "<$constructor$>";
        stringArray[259] = "<$constructor$>";
        stringArray[260] = "PUBLIC";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "<$constructor$>";
        stringArray[263] = "CLIENT_SECRET_BASIC";
        stringArray[264] = "putAt";
        stringArray[265] = "oidcProviderMetadata";
        stringArray[266] = "<$constructor$>";
        stringArray[267] = "putAt";
        stringArray[268] = "oidcProviderMetadata";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "putAt";
        stringArray[271] = "oidcProviderMetadata";
        stringArray[272] = "mockClaims";
        stringArray[273] = "<$constructor$>";
        stringArray[274] = "<$constructor$>";
        stringArray[275] = "<$constructor$>";
        stringArray[276] = "<$constructor$>";
        stringArray[277] = "<$constructor$>";
        stringArray[278] = "<$constructor$>";
        stringArray[279] = "plus";
        stringArray[280] = "<$constructor$>";
        stringArray[281] = "GET";
        stringArray[282] = "<$constructor$>";
        stringArray[283] = "GET";
        stringArray[284] = "<$constructor$>";
        stringArray[285] = "GET";
        stringArray[286] = "<$constructor$>";
        stringArray[287] = "GET";
        stringArray[288] = "<$constructor$>";
        stringArray[289] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[290];
        StandardOidcIdentityProviderGroovyTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardOidcIdentityProviderGroovyTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardOidcIdentityProviderGroovyTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

