/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.ContentRequestContext;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ViewableContent;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentViewerController
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ContentViewerController.class);
    private static final int BUFFER_LENGTH = 1536;
    private static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    private static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    private static final String FORWARDED_PREFIX_HTTP_HEADER = "X-Forwarded-Prefix";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewableContent.DisplayMode displayMode;
        DownloadableContent downloadableContent;
        ContentRequestContext contentRequest;
        response.addHeader("Content-Type", "text/html; charset=UTF-8");
        ServletContext servletContext = request.getServletContext();
        ContentAccess contentAccess = (ContentAccess)servletContext.getAttribute("nifi-content-access");
        try {
            contentRequest = this.getContentRequest(request);
        }
        catch (Exception e) {
            logger.warn("Content loading failed", (Throwable)e);
            response.sendError(500, "Content loading failed");
            return;
        }
        if (contentRequest.getDataUri() == null) {
            response.sendError(400, "Data Reference URI must be specified");
            return;
        }
        try {
            downloadableContent = contentAccess.getContent(contentRequest);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("Content not found", (Throwable)e);
            response.sendError(404, "Content not found");
            return;
        }
        catch (AccessDeniedException e) {
            logger.warn("Content access denied", (Throwable)e);
            response.sendError(403, "Content access denied");
            return;
        }
        catch (Exception e) {
            logger.warn("Content retrieval failed", (Throwable)e);
            response.sendError(500, "Content retrieval failed");
            return;
        }
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = ViewableContent.DisplayMode.Original.name();
        }
        try {
            displayMode = ViewableContent.DisplayMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, "Display mode not supported [%s]".formatted(mode));
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(downloadableContent.getContent());
        try {
            String mimeType;
            if (downloadableContent.getType() == null || StringUtils.startsWithIgnoreCase((CharSequence)downloadableContent.getType(), (CharSequence)MediaType.OCTET_STREAM.toString())) {
                DefaultDetector detector = new DefaultDetector();
                TikaInputStream tikaStream = TikaInputStream.get((InputStream)bis);
                Metadata metadata = new Metadata();
                metadata.set("resourceName", downloadableContent.getFilename());
                MediaType mediatype = detector.detect((InputStream)tikaStream, metadata);
                mimeType = mediatype.toString();
            } else {
                mimeType = downloadableContent.getType();
            }
            String normalizedMimeType = mimeType.split(";", 2)[0].toLowerCase();
            request.setAttribute("filename", (Object)downloadableContent.getFilename());
            request.setAttribute("contentType", (Object)mimeType);
            request.getRequestDispatcher("/WEB-INF/jsp/header.jsp").include((ServletRequest)request, (ServletResponse)response);
            request.removeAttribute("filename");
            request.removeAttribute("contentType");
            if (ViewableContent.DisplayMode.Hex.equals((Object)displayMode)) {
                byte[] buffer = new byte[1536];
                int read = StreamUtils.fillBuffer((InputStream)bis, (byte[])buffer, (boolean)false);
                byte[] bytes = buffer;
                if (read != buffer.length) {
                    bytes = new byte[read];
                    System.arraycopy(buffer, 0, bytes, 0, read);
                }
                String base64 = Base64.encodeBase64String((byte[])bytes);
                request.setAttribute("content", (Object)base64);
                request.getRequestDispatcher("/WEB-INF/jsp/hexview.jsp").include((ServletRequest)request, (ServletResponse)response);
            } else {
                String contentViewerUri = servletContext.getInitParameter(normalizedMimeType);
                if (contentViewerUri == null) {
                    request.getRequestDispatcher("/WEB-INF/jsp/no-viewer.jsp").include((ServletRequest)request, (ServletResponse)response);
                } else {
                    request.setAttribute("org.apache.nifi.web.content", (Object)new /* Unavailable Anonymous Inner Class!! */);
                    try {
                        ServletContext viewerContext = (ServletContext)servletContext.getAttribute(contentViewerUri);
                        viewerContext.getRequestDispatcher("/view-content").include((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (Exception e) {
                        logger.error("Content preparation failed for Content Viewer [{}]", (Object)contentViewerUri, (Object)e);
                        response.sendError(500, "Content preparation failed");
                        bis.close();
                        return;
                    }
                    request.removeAttribute("org.apache.nifi.web.content");
                }
            }
            request.getRequestDispatcher("/WEB-INF/jsp/footer.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            try {
                bis.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private ContentRequestContext getContentRequest(HttpServletRequest request) {
        String ref = request.getParameter("ref");
        String clientId = request.getParameter("clientId");
        UriBuilder refUriBuilder = UriBuilder.fromUri((String)ref);
        refUriBuilder.scheme(request.getScheme());
        String proxyContextPath = this.getFirstHeaderValue(request, new String[]{PROXY_CONTEXT_PATH_HTTP_HEADER, FORWARDED_CONTEXT_HTTP_HEADER, FORWARDED_PREFIX_HTTP_HEADER});
        if (StringUtils.isNotBlank((CharSequence)proxyContextPath)) {
            refUriBuilder.replacePath(StringUtils.substringAfter((String)UriBuilder.fromUri((String)ref).build(new Object[0]).getPath(), (String)proxyContextPath));
        }
        URI refUri = refUriBuilder.build(new Object[0]);
        String query = refUri.getQuery();
        String rawClusterNodeId = null;
        if (query != null) {
            String[] queryParameters = query.split("&");
            for (int i = 0; i < queryParameters.length; ++i) {
                if (!queryParameters[0].startsWith("clusterNodeId=")) continue;
                rawClusterNodeId = StringUtils.substringAfterLast((String)queryParameters[0], (String)"clusterNodeId=");
            }
        }
        String clusterNodeId = rawClusterNodeId;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getFirstHeaderValue(HttpServletRequest httpServletRequest, String ... keys) {
        if (keys == null) {
            return null;
        }
        for (String key : keys) {
            String value = httpServletRequest.getHeader(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

