/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.DataAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.repository.ContentNotFoundException;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConnectionDAO
extends ComponentDAO
implements ConnectionDAO {
    private static final Logger logger = LoggerFactory.getLogger(StandardConnectionDAO.class);
    private FlowController flowController;
    private Authorizer authorizer;

    private Connection locateConnection(String connectionId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        Connection connection = rootGroup.findConnection(connectionId);
        if (connection == null) {
            throw new ResourceNotFoundException(String.format("Unable to find connection with id '%s'.", connectionId));
        }
        return connection;
    }

    public boolean hasConnection(String id) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        return rootGroup.findConnection(id) != null;
    }

    public Connection getConnection(String id) {
        return this.locateConnection(id);
    }

    public Set<Connection> getConnections(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getConnections();
    }

    public DropFlowFileStatus getFlowFileDropRequest(String connectionId, String dropRequestId) {
        Connection connection = this.locateConnection(connectionId);
        FlowFileQueue queue = connection.getFlowFileQueue();
        DropFlowFileStatus dropRequest = queue.getDropFlowFileStatus(dropRequestId);
        if (dropRequest == null) {
            throw new ResourceNotFoundException(String.format("Unable to find drop request with id '%s'.", dropRequestId));
        }
        return dropRequest;
    }

    public ListFlowFileStatus getFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.locateConnection(connectionId);
        FlowFileQueue queue = connection.getFlowFileQueue();
        ListFlowFileStatus listRequest = queue.getListFlowFileStatus(listingRequestId);
        if (listRequest == null) {
            throw new ResourceNotFoundException(String.format("Unable to find listing request with id '%s'.", listingRequestId));
        }
        return listRequest;
    }

    public FlowFileRecord getFlowFile(String id, String flowFileUuid) {
        try {
            Connection connection = this.locateConnection(id);
            FlowFileQueue queue = connection.getFlowFileQueue();
            FlowFileRecord flowFile = queue.getFlowFile(flowFileUuid);
            if (flowFile == null) {
                throw new ResourceNotFoundException(String.format("The FlowFile with UUID %s is no longer in the active queue.", flowFileUuid));
            }
            Map attributes = flowFile.getAttributes();
            DataAuthorizable dataAuthorizable = new DataAuthorizable(connection.getSourceAuthorizable());
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser(), attributes);
            return flowFile;
        }
        catch (IOException ioe) {
            logger.error(String.format("Unable to get the flowfile (%s) at this time.", flowFileUuid), (Throwable)ioe);
            throw new IllegalStateException("Unable to get the FlowFile at this time.");
        }
    }

    private void configureConnection(Connection connection, ConnectionDTO connectionDTO) {
        String loadBalanceCompressionName;
        ArrayList<FlowFilePrioritizer> newPrioritizers = null;
        List prioritizers = connectionDTO.getPrioritizers();
        if (this.isNotNull((Object)prioritizers)) {
            ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
            newPrioritizers = new ArrayList<FlowFilePrioritizer>();
            for (String className : newPrioritizersClasses) {
                try {
                    newPrioritizers.add(this.flowController.getFlowManager().createPrioritizer(className));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                }
            }
        }
        if (this.isNotNull((Object)connectionDTO.getFlowFileExpiration())) {
            connection.getFlowFileQueue().setFlowFileExpiration(connectionDTO.getFlowFileExpiration());
        }
        if (this.isNotNull((Object)connectionDTO.getBackPressureObjectThreshold())) {
            connection.getFlowFileQueue().setBackPressureObjectThreshold(connectionDTO.getBackPressureObjectThreshold().longValue());
        }
        if (this.isNotNull((Object)connectionDTO.getBackPressureDataSizeThreshold())) {
            connection.getFlowFileQueue().setBackPressureDataSizeThreshold(connectionDTO.getBackPressureDataSizeThreshold());
        }
        if (this.isNotNull(newPrioritizers)) {
            connection.getFlowFileQueue().setPriorities(newPrioritizers);
        }
        String loadBalanceStrategyName = connectionDTO.getLoadBalanceStrategy();
        String loadBalancePartitionAttribute = connectionDTO.getLoadBalancePartitionAttribute();
        if (this.isNotNull((Object)loadBalanceStrategyName)) {
            LoadBalanceStrategy loadBalanceStrategy = LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
            connection.getFlowFileQueue().setLoadBalanceStrategy(loadBalanceStrategy, loadBalancePartitionAttribute);
        }
        if (this.isNotNull((Object)(loadBalanceCompressionName = connectionDTO.getLoadBalanceCompression()))) {
            connection.getFlowFileQueue().setLoadBalanceCompression(LoadBalanceCompression.valueOf((String)loadBalanceCompressionName));
        }
        if (this.isNotNull((Object)connectionDTO.getBends())) {
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : connectionDTO.getBends()) {
                if (bend == null) continue;
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
        }
        if (this.isNotNull((Object)connectionDTO.getName())) {
            connection.setName(connectionDTO.getName());
        }
        if (this.isNotNull((Object)connectionDTO.getLabelIndex())) {
            connection.setLabelIndex(connectionDTO.getLabelIndex().intValue());
        }
        if (this.isNotNull((Object)connectionDTO.getzIndex())) {
            connection.setZIndex(connectionDTO.getzIndex().longValue());
        }
    }

    private List<String> validateProposedConfiguration(String groupId, ConnectionDTO connectionDTO) {
        ConnectableDTO proposedDestination;
        Matcher expirationMatcher;
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)connectionDTO.getBackPressureObjectThreshold()) && connectionDTO.getBackPressureObjectThreshold() < 0L) {
            validationErrors.add("Max queue size must be a non-negative integer");
        }
        if (this.isNotNull((Object)connectionDTO.getFlowFileExpiration()) && !(expirationMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(connectionDTO.getFlowFileExpiration())).matches()) {
            validationErrors.add("Flow file expiration is not a valid time duration (ie 30 sec, 5 min)");
        }
        if (this.isNotNull((Object)connectionDTO.getLabelIndex()) && connectionDTO.getLabelIndex() < 0) {
            validationErrors.add("The label index must be positive.");
        }
        if ((proposedDestination = connectionDTO.getDestination()) != null && ConnectableType.REMOTE_INPUT_PORT.name().equals(proposedDestination.getType())) {
            if (proposedDestination.getGroupId() == null) {
                validationErrors.add("When the destination is a remote input port its group id is required.");
                return validationErrors;
            }
            ProcessGroup destinationParentGroup = this.locateProcessGroup(this.flowController, groupId);
            RemoteProcessGroup remoteProcessGroup = destinationParentGroup.getRemoteProcessGroup(proposedDestination.getGroupId());
            if (remoteProcessGroup == null) {
                validationErrors.add("Unable to find the specified remote process group.");
                return validationErrors;
            }
            RemoteGroupPort remoteInputPort = remoteProcessGroup.getInputPort(proposedDestination.getId());
            if (remoteInputPort == null) {
                validationErrors.add("Unable to find the specified destination.");
                return validationErrors;
            }
        }
        return validationErrors;
    }

    public Connection createConnection(String groupId, ConnectionDTO connectionDTO) {
        Connectable destination;
        Connectable source;
        List validationErrors;
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        if (this.isNotNull((Object)connectionDTO.getParentGroupId()) && !this.flowController.getFlowManager().areGroupsSame(connectionDTO.getParentGroupId(), groupId)) {
            throw new IllegalStateException("Cannot specify a different Parent Group ID than the Group to which the Connection is being added");
        }
        ConnectableDTO sourceConnectableDTO = connectionDTO.getSource();
        ConnectableDTO destinationConnectableDTO = connectionDTO.getDestination();
        if (sourceConnectableDTO == null || destinationConnectableDTO == null) {
            throw new IllegalArgumentException("Both source and destinations must be specified.");
        }
        if (sourceConnectableDTO.getGroupId() == null) {
            sourceConnectableDTO.setGroupId(groupId);
        }
        if (destinationConnectableDTO.getGroupId() == null) {
            destinationConnectableDTO.setGroupId(groupId);
        }
        if (!(validationErrors = this.validateProposedConfiguration(groupId, connectionDTO)).isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceConnectableDTO.getType())) {
            ProcessGroup sourceParentGroup = this.locateProcessGroup(this.flowController, groupId);
            RemoteProcessGroup remoteProcessGroup = sourceParentGroup.getRemoteProcessGroup(sourceConnectableDTO.getGroupId());
            source = remoteProcessGroup.getOutputPort(sourceConnectableDTO.getId());
        } else {
            ProcessGroup sourceGroup = this.locateProcessGroup(this.flowController, sourceConnectableDTO.getGroupId());
            source = sourceGroup.getConnectable(sourceConnectableDTO.getId());
        }
        if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationConnectableDTO.getType())) {
            ProcessGroup destinationParentGroup = this.locateProcessGroup(this.flowController, groupId);
            RemoteProcessGroup remoteProcessGroup = destinationParentGroup.getRemoteProcessGroup(destinationConnectableDTO.getGroupId());
            destination = remoteProcessGroup.getInputPort(destinationConnectableDTO.getId());
        } else {
            ProcessGroup destinationGroup = this.locateProcessGroup(this.flowController, destinationConnectableDTO.getGroupId());
            destination = destinationGroup.getConnectable(destinationConnectableDTO.getId());
        }
        HashSet relationships = new HashSet();
        if (this.isNotNull((Object)connectionDTO.getSelectedRelationships())) {
            relationships.addAll(connectionDTO.getSelectedRelationships());
        }
        Connection connection = this.flowController.createConnection(connectionDTO.getId(), connectionDTO.getName(), source, destination, relationships);
        this.configureConnection(connection, connectionDTO);
        group.addConnection(connection);
        return connection;
    }

    public DropFlowFileStatus createFlowFileDropRequest(String id, String dropRequestId) {
        Connection connection = this.locateConnection(id);
        FlowFileQueue queue = connection.getFlowFileQueue();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        return queue.dropFlowFiles(dropRequestId, user.getIdentity());
    }

    public ListFlowFileStatus createFlowFileListingRequest(String id, String listingRequestId) {
        Connection connection = this.locateConnection(id);
        FlowFileQueue queue = connection.getFlowFileQueue();
        this.verifyList(queue);
        return queue.listFlowFiles(listingRequestId, 100);
    }

    public void verifyCreate(String groupId, ConnectionDTO connectionDTO) {
        RemoteProcessGroup remoteProcessGroup;
        List validationErrors = this.validateProposedConfiguration(groupId, connectionDTO);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        ConnectableDTO sourceDto = connectionDTO.getSource();
        if (sourceDto == null || sourceDto.getId() == null) {
            throw new IllegalArgumentException("Cannot create connection without specifying source");
        }
        ConnectableDTO destinationDto = connectionDTO.getDestination();
        if (destinationDto == null || destinationDto.getId() == null) {
            throw new IllegalArgumentException("Cannot create connection without specifying destination");
        }
        if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDto.getType())) {
            ProcessGroup sourceParentGroup = this.locateProcessGroup(this.flowController, groupId);
            remoteProcessGroup = sourceParentGroup.getRemoteProcessGroup(sourceDto.getGroupId());
            if (remoteProcessGroup == null) {
                throw new IllegalArgumentException("Unable to find the specified remote process group.");
            }
            RemoteGroupPort sourceConnectable = remoteProcessGroup.getOutputPort(sourceDto.getId());
            if (sourceConnectable == null) {
                throw new IllegalArgumentException("The specified source for the connection does not exist");
            }
            if (!sourceConnectable.getTargetExists()) {
                throw new IllegalArgumentException("The specified remote output port does not exist.");
            }
        } else {
            ProcessGroup sourceGroup = this.locateProcessGroup(this.flowController, sourceDto.getGroupId());
            Connectable sourceConnectable = sourceGroup.getConnectable(sourceDto.getId());
            if (sourceConnectable == null) {
                throw new IllegalArgumentException("The specified source for the connection does not exist");
            }
            if (sourceConnectable instanceof PublicPort && TransferDirection.SEND.equals((Object)((PublicPort)sourceConnectable).getDirection())) {
                throw new IllegalArgumentException("The specified source for the connection cannot be connected to local components.");
            }
        }
        if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDto.getType())) {
            ProcessGroup destinationParentGroup = this.locateProcessGroup(this.flowController, groupId);
            remoteProcessGroup = destinationParentGroup.getRemoteProcessGroup(destinationDto.getGroupId());
            if (remoteProcessGroup == null) {
                throw new IllegalArgumentException("Unable to find the specified remote process group.");
            }
            RemoteGroupPort destinationConnectable = remoteProcessGroup.getInputPort(destinationDto.getId());
            if (destinationConnectable == null) {
                throw new IllegalArgumentException("The specified destination for the connection does not exist");
            }
            if (!destinationConnectable.getTargetExists()) {
                throw new IllegalArgumentException("The specified remote input port does not exist.");
            }
        } else {
            ProcessGroup destinationGroup = this.locateProcessGroup(this.flowController, destinationDto.getGroupId());
            Connectable destinationConnectable = destinationGroup.getConnectable(destinationDto.getId());
            if (destinationConnectable == null) {
                throw new IllegalArgumentException("The specified destination for the connection does not exist");
            }
            if (destinationConnectable instanceof PublicPort && TransferDirection.RECEIVE.equals((Object)((PublicPort)destinationConnectable).getDirection())) {
                throw new IllegalArgumentException("The specified destination for the connection cannot be connected from local components.");
            }
        }
    }

    private void verifyList(FlowFileQueue queue) {
        queue.verifyCanList();
    }

    public void verifyList(String id) {
        Connection connection = this.locateConnection(id);
        FlowFileQueue queue = connection.getFlowFileQueue();
        this.verifyList(queue);
    }

    public void verifyUpdate(ConnectionDTO connectionDTO) {
        this.verifyUpdate(this.locateConnection(connectionDTO.getId()), connectionDTO);
    }

    private void verifyUpdate(Connection connection, ConnectionDTO connectionDTO) {
        if (this.isAnyNotNull(new Object[]{connectionDTO.getBackPressureDataSizeThreshold(), connectionDTO.getBackPressureObjectThreshold(), connectionDTO.getDestination(), connectionDTO.getFlowFileExpiration(), connectionDTO.getName(), connectionDTO.getPosition(), connectionDTO.getPrioritizers(), connectionDTO.getSelectedRelationships()})) {
            List validationErrors = this.validateProposedConfiguration(connection.getProcessGroup().getIdentifier(), connectionDTO);
            if (!validationErrors.isEmpty()) {
                throw new ValidationException(validationErrors);
            }
            Connectable destination = connection.getDestination();
            if (destination != null && destination.isRunning() && destination.getConnectableType() != ConnectableType.FUNNEL && destination.getConnectableType() != ConnectableType.INPUT_PORT) {
                throw new ValidationException(Collections.singletonList("Cannot change the destination of connection because the current destination is running"));
            }
            connection.verifyCanUpdate();
        }
    }

    public Connection updateConnection(ConnectionDTO connectionDTO) {
        ConnectableDTO proposedDestination;
        Connection connection = this.locateConnection(connectionDTO.getId());
        ProcessGroup group = connection.getProcessGroup();
        this.verifyUpdate(connection, connectionDTO);
        ArrayList<Relationship> newProcessorRelationships = new ArrayList<Relationship>();
        Connectable newDestination = null;
        Connectable existingSource = connection.getSource();
        if (this.isNotNull((Object)connectionDTO.getSource()) && !existingSource.getIdentifier().equals(connectionDTO.getSource().getId())) {
            throw new IllegalStateException("Connection with ID " + connectionDTO.getId() + " has conflicting Source ID");
        }
        Set relationships = connectionDTO.getSelectedRelationships();
        if (this.isNotNull((Object)relationships)) {
            if (relationships.isEmpty()) {
                throw new IllegalArgumentException("Cannot remove all relationships from Connection with ID " + connection.getIdentifier() + " -- remove the Connection instead");
            }
            if (existingSource == null) {
                throw new IllegalArgumentException("Cannot specify new relationships without including the source.");
            }
            for (String relationship : relationships) {
                Relationship processorRelationship = existingSource.getRelationship(relationship);
                if (processorRelationship == null) {
                    throw new IllegalArgumentException("Unable to locate " + relationship + " relationship.");
                }
                newProcessorRelationships.add(processorRelationship);
            }
        }
        if ((proposedDestination = connectionDTO.getDestination()) != null) {
            Connectable currentDestination = connection.getDestination();
            if (ConnectableType.REMOTE_INPUT_PORT.name().equals(proposedDestination.getType())) {
                if (proposedDestination.getGroupId() == null) {
                    throw new IllegalArgumentException("When the destination is a remote input port its group id is required.");
                }
                boolean isDifferentRemoteProcessGroup = false;
                if (currentDestination.getConnectableType() == ConnectableType.REMOTE_INPUT_PORT) {
                    RemoteGroupPort remotePort = (RemoteGroupPort)currentDestination;
                    if (!proposedDestination.getGroupId().equals(remotePort.getRemoteProcessGroup().getIdentifier())) {
                        isDifferentRemoteProcessGroup = true;
                    }
                }
                if (!proposedDestination.getId().equals(currentDestination.getIdentifier()) || isDifferentRemoteProcessGroup) {
                    ProcessGroup destinationParentGroup = this.locateProcessGroup(this.flowController, group.getIdentifier());
                    RemoteProcessGroup remoteProcessGroup = destinationParentGroup.getRemoteProcessGroup(proposedDestination.getGroupId());
                    if (remoteProcessGroup == null) {
                        throw new IllegalArgumentException("Unable to find the specified remote process group.");
                    }
                    RemoteGroupPort remoteInputPort = remoteProcessGroup.getInputPort(proposedDestination.getId());
                    if (remoteInputPort == null) {
                        throw new IllegalArgumentException("Unable to find the specified destination.");
                    }
                    if (!remoteInputPort.getTargetExists()) {
                        throw new IllegalArgumentException("The specified remote input port does not exist.");
                    }
                    newDestination = remoteInputPort;
                }
            } else if (!proposedDestination.getId().equals(currentDestination.getIdentifier())) {
                ProcessGroup destinationGroup;
                if (proposedDestination.getGroupId() == null) {
                    proposedDestination.setGroupId(group.getIdentifier());
                }
                if ((newDestination = (destinationGroup = this.locateProcessGroup(this.flowController, proposedDestination.getGroupId())).getConnectable(proposedDestination.getId())) == null) {
                    throw new IllegalArgumentException("Unable to find the specified destination.");
                }
            }
        }
        this.configureConnection(connection, connectionDTO);
        group.onComponentModified();
        if (!newProcessorRelationships.isEmpty()) {
            connection.setRelationships(newProcessorRelationships);
        }
        if (this.isNotNull(newDestination)) {
            connection.setDestination(newDestination);
        }
        return connection;
    }

    public void verifyDelete(String id) {
        Connection connection = this.locateConnection(id);
        connection.verifyCanDelete();
    }

    public void deleteConnection(String id) {
        Connection connection = this.locateConnection(id);
        connection.getProcessGroup().removeConnection(connection);
    }

    public DropFlowFileStatus deleteFlowFileDropRequest(String connectionId, String dropRequestId) {
        Connection connection = this.locateConnection(connectionId);
        FlowFileQueue queue = connection.getFlowFileQueue();
        DropFlowFileStatus dropFlowFileStatus = queue.cancelDropFlowFileRequest(dropRequestId);
        if (dropFlowFileStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to find drop request with id '%s'.", dropRequestId));
        }
        return dropFlowFileStatus;
    }

    public ListFlowFileStatus deleteFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.locateConnection(connectionId);
        FlowFileQueue queue = connection.getFlowFileQueue();
        ListFlowFileStatus listFlowFileStatus = queue.cancelListFlowFileRequest(listingRequestId);
        if (listFlowFileStatus == null) {
            throw new ResourceNotFoundException(String.format("Unable to find listing request with id '%s'.", listingRequestId));
        }
        return listFlowFileStatus;
    }

    public DownloadableContent getContent(String id, String flowFileUuid, String requestUri) {
        try {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Connection connection = this.locateConnection(id);
            FlowFileQueue queue = connection.getFlowFileQueue();
            FlowFileRecord flowFile = queue.getFlowFile(flowFileUuid);
            if (flowFile == null) {
                throw new ResourceNotFoundException(String.format("The FlowFile with UUID %s is no longer in the active queue.", flowFileUuid));
            }
            Map attributes = flowFile.getAttributes();
            DataAuthorizable dataAuthorizable = new DataAuthorizable(connection.getSourceAuthorizable());
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, user, attributes);
            String filename = (String)attributes.get(CoreAttributes.FILENAME.key());
            if (filename == null) {
                filename = flowFileUuid;
            }
            String type = (String)attributes.get(CoreAttributes.MIME_TYPE.key());
            InputStream content = this.flowController.getContent(flowFile, user.getIdentity(), requestUri);
            return new DownloadableContent(filename, type, content);
        }
        catch (ContentNotFoundException cnfe) {
            throw new ResourceNotFoundException("Unable to find the specified content.");
        }
        catch (IOException ioe) {
            logger.error(String.format("Unable to get the content for flowfile (%s) at this time.", flowFileUuid), (Throwable)ioe);
            throw new IllegalStateException("Unable to get the content at this time.");
        }
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

