/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.contextlistener;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.IOException;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.repository.RepositoryPurgeException;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiCoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationStartupContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStartupContextListener.class);
    private FlowController flowController = null;
    private FlowService flowService = null;

    public void contextInitialized(ServletContextEvent sce) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        NiFiProperties properties = (NiFiProperties)ctx.getBean("nifiProperties", NiFiProperties.class);
        try {
            this.flowService = (FlowService)ctx.getBean("flowService", FlowService.class);
            this.flowController = (FlowController)ctx.getBean("flowController", FlowController.class);
            if (!properties.isNode()) {
                logger.info("Starting Flow Controller...");
                this.flowService.start();
                this.flowService.load(null);
                this.flowController.onFlowInitialized(properties.getAutoResumeState());
                logger.info("Flow Controller started successfully.");
            }
        }
        catch (IOException | RepositoryPurgeException | BeansException e) {
            this.shutdown();
            throw new NiFiCoreException("Unable to start Flow Controller.", e);
        }
        try {
            ctx.getBean("loginIdentityProvider");
            ctx.getBean("authorizer");
        }
        catch (BeansException e) {
            this.shutdown();
            throw new NiFiCoreException("Unable to start Flow Controller.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        logger.info("Flow Service shutdown started");
        this.shutdown();
        logger.info("Flow Service shutdown completed");
    }

    private void shutdown() {
        try {
            if (this.flowService != null && this.flowService.isRunning()) {
                this.flowService.stop(false);
            }
        }
        catch (Exception e) {
            String msg = "Problem occurred ensuring flow controller or repository was properly terminated due to " + e;
            if (logger.isDebugEnabled()) {
                logger.warn(msg, (Throwable)e);
            }
            logger.warn(msg);
        }
    }
}

