/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.exception.NoConnectedNodesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoClusterCoordinatorExceptionMapper
implements ExceptionMapper<NoClusterCoordinatorException> {
    private static final Logger logger = LoggerFactory.getLogger(NoConnectedNodesException.class);

    public Response toResponse(NoClusterCoordinatorException ex) {
        logger.info(String.format("Cluster failed processing request: %s. Returning %s response.", ex, Response.Status.SERVICE_UNAVAILABLE));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)ex.getMessage()).type("text/plain").build();
    }
}

